/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus.getCouponStatus;

import com.gridnine.bof.midoffice.ibus.BookingFileOperationParameters;
import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.booking.ProductIndex;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.CouponStatus;
import com.gridnine.xtrip.common.model.booking.air.CouponStatusState;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.ibus.getCouponStatus.CouponStatusTranslator;
import com.gridnine.xtrip.server.gds.ibus.getCouponStatus.GetCouponStatusIBusHandler;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class UpdateCouponStatusHandler
implements GetCouponStatusIBusHandler {
    @Override
    public Collection<Product> getProducts(MessageContext ctx) {
        Collection indexes = (Collection)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.PRODUCT_INDEXES);
        Set uids = indexes.stream().map(ProductIndex::getNavigationKey).collect(Collectors.toSet());
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        return AirProductHelper.getAirProductsStream((Reservation)reservation).filter(p -> uids.contains(p.getUid())).collect(Collectors.toList());
    }

    @Override
    public void handle(Product product, List<String> statuses, CouponStatusTranslator translator, MessageContext ctx) {
        List segments = AirProductHelper.getProductSegmentsList((Product)product);
        boolean saveNeeded = false;
        Iterator<String> statusIterator = statuses.iterator();
        for (Segment segment : segments) {
            CouponStatus gdsStatus;
            CouponStatus status = segment.getCouponStatus();
            if (status == (gdsStatus = translator.isUsed(statusIterator.next()) ? CouponStatus.USED : CouponStatus.NOT_USED)) continue;
            segment.setCouponStatus(gdsStatus);
            saveNeeded = true;
        }
        if (product.getCouponStatusState() != CouponStatusState.SET) {
            product.setCouponStatusState(CouponStatusState.SET);
            saveNeeded = true;
        }
        if (saveNeeded) {
            BookingFileOperationParameters parameters = (BookingFileOperationParameters)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE_OPERATION_PARAMETERS);
            parameters.setSaveBookingFile(true);
        }
    }
}

