/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus.getFareRules;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.FareRules;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.Document;
import com.gridnine.xtrip.common.model.system.DocumentType;
import com.gridnine.xtrip.common.util.XSSerializable;
import com.gridnine.xtrip.common.xml.XSUtil;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.codec.digest.DigestUtils;

public class SaveFareRulesProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityContainer bfCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        List paragraphs = (List)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FARE_RULES);
        String contextStr = (String)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FARE_REMARKS_SEARCH_CONTEXT);
        FareRules fareRules = new FareRules();
        fareRules.getParagraphs().addAll(paragraphs);
        String content = XSUtil.toString((XSSerializable)fareRules);
        String uid = GDSHelper.buildSavedFareRulesContainerUid(reservation, contextStr);
        EntityContainer ctr = new EntityContainer(Document.class, uid);
        ((Document)ctr.getEntity()).setCheckSum(DigestUtils.md5Hex((String)content));
        ((Document)ctr.getEntity()).setContent(content.getBytes());
        ((Document)ctr.getEntity()).setContentType(ContentType.XML);
        ((Document)ctr.getEntity()).setCreated(new Date());
        ((Document)ctr.getEntity()).setName(String.format("%s.xml", uid));
        ((Document)ctr.getEntity()).setOwner(bfCtr.toReference());
        ((Document)ctr.getEntity()).setTitle(uid);
        ((Document)ctr.getEntity()).setType(DocumentType.FARE_RULES);
        HashSet<EntityContainer> documents = (HashSet<EntityContainer>)ctx.getObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE_DOCUMENTS);
        if (documents == null) {
            documents = new HashSet<EntityContainer>();
            ctx.putObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE_DOCUMENTS, documents);
        }
        documents.add(ctr);
    }
}

