/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus.http;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.BaseGdsAccount;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.system.Document;
import com.gridnine.xtrip.server.ibus.components.BaseAdvice;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.http.IBusHttpContextKeys;
import java.util.HashSet;
import java.util.Map;

public class HttpLogBookingFileAdvice
extends BaseAdvice {
    private String docName;

    public void configure(Map<String, String> params) throws Exception {
        this.docName = params.get("doc-name");
    }

    public void before(MessageContext ctx) throws Exception {
        ctx.putObject((Enum)IBusHttpContextKeys.ENABLE_LOG_DOCUMENT, (Object)Boolean.TRUE);
    }

    public void after(MessageContext ctx) throws Exception {
        Document doc = (Document)ctx.getObject((Enum)IBusHttpContextKeys.HTTP_LOG_DOCUMENT);
        if (doc != null) {
            HashSet<Document> documents;
            EntityContainer gdsAccountCtr;
            doc.setName(this.docName + ".xml");
            doc.setTitle(this.docName + " transactions");
            EntityContainer bfCtr = (EntityContainer)ctx.getObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
            if (bfCtr != null) {
                doc.setOwner(bfCtr.toReference());
            }
            if ((gdsAccountCtr = (EntityContainer)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT)) != null) {
                doc.setTitle(doc.getTitle() + String.format(" (%s)", ((BaseGdsAccount)gdsAccountCtr.getEntity()).getName()));
            }
            if ((documents = (HashSet<Document>)ctx.getObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE_DOCUMENTS)) == null) {
                documents = new HashSet<Document>();
                ctx.putObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE_DOCUMENTS, documents);
            }
            documents.add(doc);
        }
    }
}

