/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus.http;

import com.gridnine.bof.midoffice.ibus.MaskSensitiveTraceDataHelper;
import com.gridnine.xtrip.common.model.system.BaseFileDocument;
import com.gridnine.xtrip.common.model.system.Document;
import com.gridnine.xtrip.common.model.system.DocumentType;
import com.gridnine.xtrip.server.ibus.components.BaseAdvice;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.http.HttpInvocationContext;
import com.gridnine.xtrip.server.model.ibus.http.IBusHttpContextKeys;
import java.util.Map;

public class HttpLoggingAdvice
extends BaseAdvice {
    private boolean xmlBody;
    private boolean json;

    public void configure(Map<String, String> params) throws Exception {
        this.xmlBody = Boolean.parseBoolean(params.get("xml-body"));
        this.json = Boolean.parseBoolean(params.get("json"));
    }

    public void before(MessageContext ctx) throws Exception {
        Boolean enable = (Boolean)ctx.getObject((Enum)IBusHttpContextKeys.ENABLE_LOG_DOCUMENT);
        if (Boolean.TRUE.equals(enable)) {
            HttpInvocationContext.get().begin();
        }
    }

    public void after(MessageContext ctx) throws Exception {
        if (!HttpInvocationContext.get().isActive()) {
            return;
        }
        try {
            Document document = this.json ? HttpInvocationContext.get().buildJsonDocument() : HttpInvocationContext.get().buildDocument(this.xmlBody);
            document.setType(DocumentType.GDS_LOG);
            MaskSensitiveTraceDataHelper.maskData((MessageContext)ctx, (BaseFileDocument)document);
            ctx.putObject((Enum)IBusHttpContextKeys.HTTP_LOG_DOCUMENT, (Object)document);
        }
        finally {
            HttpInvocationContext.get().end();
        }
    }
}

