/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus.mco;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.MCOReservationRequestStatus;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseRoutingKeyProvider;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.List;
import org.apache.commons.lang.BooleanUtils;

public class IsBookingFileOkToUpdateMcoProvider
extends BaseRoutingKeyProvider {
    public String getRoutingKey(MessageContext ctx) throws Exception {
        EntityContainer bfCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
        Boolean forceUpdate = (Boolean)ctx.getObject((Enum)IBusGdsContextKeys.FORCE_UPDATE_MCO_STATUSES);
        boolean isOk = BooleanUtils.isTrue((Boolean)forceUpdate) || this.isBookingOkToUpdateMco((BookingFile)bfCtr.getEntity());
        return Boolean.toString(isOk);
    }

    private boolean isBookingOkToUpdateMco(BookingFile booking) {
        for (Reservation reservation : booking.getReservations()) {
            List products = AirProductHelper.getProducts((Reservation)reservation);
            for (Product product : products) {
                if (ProductCategory.MCO != product.getProductCategory() || MCOReservationRequestStatus.PENDING != product.getMcoReservationRequestStatus()) continue;
                return true;
            }
        }
        return false;
    }
}

