/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus.mtd;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.BaseMtdFareSettingsIndex;
import com.gridnine.xtrip.common.gds.model.MtdSearchParameters;
import com.gridnine.xtrip.common.gds.mtd.CommonMtdHelper;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class ApplicableMtdGdsAccountsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        MtdSearchParameters parameters = (MtdSearchParameters)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.MTD_FLIGHT_SEARCH_PARAMETERS);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        List<BaseMtdFareSettingsIndex> data = this.search(parameters, salesContext);
        ctx.putObject((Enum)IBusGdsContextKeys.APPLICABLE_GDS_ACCOUNTS, data.stream().map(BaseMtdFareSettingsIndex::getGdsAccount).distinct().map(ref -> EntityStorage.get().resolve(ref)).filter(Objects::nonNull).collect(Collectors.toSet()));
        ctx.putObject((Enum)IBusGdsContextKeys.MTD_APPLICABLE_FARE_SETTINGS, data);
    }

    protected List<BaseMtdFareSettingsIndex> search(MtdSearchParameters parameters, SalesContext salesContext) {
        return CommonMtdHelper.search(Collections.singletonList(salesContext.getAgency()), (MtdSearchParameters)parameters, (EntityReference)salesContext.getSubagency());
    }
}

