/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus.mtd;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.MtdParameters;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.dict.PassengerStatus;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.List;

public class SaveMtdInformationToReservationProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Flight flight = (Flight)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT);
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        MtdParameters parameters = flight.getMtdParameters();
        reservation.setMtdParameters(parameters);
        if (parameters != null) {
            this.updateProducts(reservation, parameters.getPassengerStatus());
        }
        reservation.setMtdSettings(flight.getMtdSettings());
    }

    private void updateProducts(Reservation reservation, PassengerStatus passengerStatus) {
        AirProductHelper.getProducts((Reservation)reservation).forEach(prod -> {
            this.updatefops(AirProductHelper.getVendorFops((Product)prod), passengerStatus);
            this.updatefops(AirProductHelper.getSubagentFops((Product)prod, (boolean)false), passengerStatus);
            this.updatefops(AirProductHelper.getClientFops((Product)prod), passengerStatus);
        });
    }

    private void updatefops(List<ProductFop> fops, PassengerStatus passengerStatus) {
        fops.forEach(fop -> fop.setPassengerStatus(passengerStatus));
    }
}

