/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus.multiTicket;

import com.google.common.collect.Lists;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.ibus.multiTicket.MultiTicketSplittedFlight;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.List;

public class MultiTicketSplitFlightsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        List flights = (List)ctx.getObject((Enum)IBusGdsContextKeys.FLIGHTS);
        if (flights != null) {
            ArrayList<MultiTicketSplittedFlight> splittedFlights = new ArrayList<MultiTicketSplittedFlight>();
            for (Flight flight : flights) {
                if (flight.getMultiTicketBreakdown().isEmpty()) continue;
                splittedFlights.add(new MultiTicketSplittedFlight(flight));
            }
            for (MultiTicketSplittedFlight splittedFlight : splittedFlights) {
                int idx = flights.indexOf(splittedFlight.getOriginalFlight());
                flights.remove(idx);
                for (Flight part : Lists.reverse(splittedFlight.getParts())) {
                    flights.add(idx, part);
                }
            }
            ctx.putObject((Enum)IBusGdsContextKeys.MULTI_TICKET_SPLITTED_FLIGHTS, splittedFlights);
        }
    }
}

