/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus.multiTicket;

import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightMultiTicketItem;
import com.gridnine.xtrip.common.incidents.IncidentsLog;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;

class MultiTicketSplittedFlight {
    private final Flight originalFlight;
    private final List<Flight> parts = new ArrayList<Flight>();

    Flight getOriginalFlight() {
        return this.originalFlight;
    }

    List<Flight> getParts() {
        return this.parts;
    }

    MultiTicketSplittedFlight(Flight flight) throws Exception {
        this.originalFlight = flight;
        for (FlightMultiTicketItem item : flight.getMultiTicketBreakdown()) {
            Flight part = (Flight)XCloneHelper.clone((XCloneable)flight, (boolean)false);
            part.setUid(item.getUid());
            MultiTicketSplittedFlight.safeReplace(item.getSegmentTariffs(), part.getSegmentTariffs());
            MultiTicketSplittedFlight.safeReplace(item.getFares(), part.getFares());
            MultiTicketSplittedFlight.safeReplace(item.getTaxes(), part.getTaxes());
            MultiTicketSplittedFlight.safeReplace(item.getAncillaryFees(), part.getAncillaryFees());
            part.setCarrier(item.getCarrier());
            this.parts.add(part);
        }
    }

    Flight buildMergedFlight() throws Exception {
        Flight result = this.originalFlight;
        result.getContractRelations().clear();
        boolean firstPart = true;
        for (Flight part : this.parts) {
            FlightHelper.mergeContractRelations((Flight)result, (Flight)part);
            MultiTicketSplittedFlight.mergeTripartiteParameters(result, part, firstPart);
            ((FlightMultiTicketItem)CollectionUtil.find((Iterable)result.getMultiTicketBreakdown(), (String)part.getUid())).getContractRelations().putAll(part.getContractRelations());
            firstPart = false;
        }
        return result;
    }

    private static <E extends BaseEntity> void safeReplace(List<E> from, List<E> to) throws Exception {
        to.clear();
        for (BaseEntity item : from) {
            to.add(XCloneHelper.clone((XCloneable)item, (boolean)false));
        }
    }

    private static void mergeTripartiteParameters(Flight result, Flight part, boolean firstPart) throws Exception {
        if (firstPart) {
            result.setAccountCode(part.getAccountCode());
            result.setAccountCodeApplied(part.isAccountCodeApplied());
            result.setTourCode(part.getTourCode());
        } else {
            MultiTicketSplittedFlight.checkParameter(result, part, Flight::getAccountCode, Flight::setAccountCode, null, "accountCode");
            MultiTicketSplittedFlight.checkParameter(result, part, Flight::isAccountCodeApplied, Flight::setAccountCodeApplied, false, "accountCodeApplied");
            MultiTicketSplittedFlight.checkParameter(result, part, Flight::getTourCode, Flight::setTourCode, null, "tourCode");
        }
    }

    private static <T> void checkParameter(Flight result, Flight part, Function<Flight, T> getter, BiConsumer<Flight, T> setter, T defaultValue, String propertyName) {
        T partValue;
        T resultValue = getter.apply(result);
        if (!Objects.equals(resultValue, partValue = getter.apply(part))) {
            setter.accept(result, (Flight)defaultValue);
            IncidentsLog.reportStackTrace((String)String.format("ambiguous %s: %s in %s (result) vs %s in %s (part)", propertyName, resultValue, FlightHelper.toIdentifiableString((Flight)result), partValue, FlightHelper.toIdentifiableString((Flight)part)));
        }
    }
}

