/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus.queue;

import com.gridnine.xtrip.common.gds.helper.PccHelper;
import com.gridnine.xtrip.common.gds.model.AgentNotificationEvent;
import com.gridnine.xtrip.common.gds.model.AirlineMessage;
import com.gridnine.xtrip.common.gds.model.BaseQueueWatchEvent;
import com.gridnine.xtrip.common.gds.model.DupeWarningEvent;
import com.gridnine.xtrip.common.gds.model.IgnoreEvent;
import com.gridnine.xtrip.common.gds.model.ManualHandlingEvent;
import com.gridnine.xtrip.common.gds.model.QueueWatchAgentNotificationData;
import com.gridnine.xtrip.common.gds.model.QueueWatchAgentNotificationType;
import com.gridnine.xtrip.common.gds.model.QueueWatchTerminalChangeAgentNotificationData;
import com.gridnine.xtrip.common.gds.model.ScheduleChangeEvent;
import com.gridnine.xtrip.common.gds.model.SegmentsCancelledEvent;
import com.gridnine.xtrip.common.gds.model.SegmentsCancelledEventReason;
import com.gridnine.xtrip.common.gds.model.ServiceStatusChangeEvent;
import com.gridnine.xtrip.common.gds.model.TicketTimelimitChangeEvent;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.profile.PccParameter;
import com.gridnine.xtrip.common.model.profile.PccParameterName;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.Streams;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AirlineMessageParser {
    private static final List<String> serviceStatusChangeTypes = Arrays.asList("ABAG", "ABGS", "XBAF", "XBGS", "EBAG", "MBAG", "ASVC", "AVIH", "AVML", "AUTO", "BBAG", "BBGS", "BBML", "BEEF", "BIKE", "BLML", "BLND", "BRML", "BSCT", "BULK", "CBAG", "CBBG", "CHCK", "CHML", "CKBG", "DBML", "DEAF", "EXBG", "EXST", "FBAG", "FIML", "FPML", "FQTV", "FRAG", "GFML", "OVWT", "PDBG", "PDPS", "PETC", "PFML", "PRAC", "PRML", "PSPT", "HBAG", "HFML", "HKML", "HNML", "INSR", "INVG", "JNML", "JPML", "KSML", "LCML", "LFML", "LIMO", "LPML", "LOUG", "LSML", "MAAS", "MEDA", "MEML", "MOML", "NFML", "NLML", "NOML", "NSML", "NSSA", "NSSB", "NSST", "NSSW", "OATM", "OBAG", "ORML", "RQST", "RVML", "SDML", "SEAF", "SEAT", "SEML", "SFML", "SGML", "SHML", "SIML", "SJML", "SKML", "SMSA", "SMSB", "SMST", "SMSW", "SPEQ", "SPML", "STBY", "UMNR", "UPGD", "UPGR", "UPML", "VGML", "VJML", "VLML", "VVIP", "WBAG", "WCBD", "WCBW", "WCHC", "WCHR", "WCHS", "WCMP", "WEAP", "XBAA", "XBAG", "XBGW", "XXML", "\u0410\u0412\u041f\u0429", "\u0411\u0413\u0416\u041a", "\u0411\u0413\u0416\u0425", "\u0411\u0416\u041f\u0429", "\u0411\u0421\u041f\u0429", "\u0412\u0410\u0416\u041d", "\u0412\u0413\u041f\u0429", "\u0412\u041c\u0421\u0422", "\u0412\u0421\u041f\u0429", "\u0413\u041f\u0421\u0416", "\u0413\u0420\u041f\u0429", "\u0414\u0411\u041f\u0429", "\u0414\u041a\u041c\u041d", "\u0414\u041a\u041c\u041e", "\u0414\u041a\u041c\u041f", "\u0414\u041a\u041c\u0421", "\u0414\u041b\u0411\u0416", "\u0414\u041f\u041c\u0421", "\u0414\u0422\u041f\u0429", "\u0416\u0412\u0422\u0411", "\u0416\u0412\u0422\u041a", "\u0418\u041d\u0412\u041a", "\u0418\u041d\u041f\u0429", "\u0418\u041d\u0424\u0420", "\u0418\u041d\u0424\u0422", "\u041a\u0428\u041f\u0429", "\u041b\u042e\u041b\u041a", "\u041c\u041f\u041f\u0429", "\u041c\u0421\u041f\u0429", "\u041d\u0411\u041f\u0429", "\u041d\u0416\u041f\u0429", "\u041d\u041a\u041c\u041d", "\u041d\u041a\u041c\u041f", "\u041d\u041a\u041c\u0421", "\u041d\u041a\u041f\u0429", "\u041d\u041c\u0421\u0422", "\u041e\u0420\u0423\u0416", "\u041f\u0420\u041f\u0429", "\u041f\u0421\u041f\u0422", "\u0420\u0411\u0421\u041f", "\u0421\u041b\u041f\u0416", "\u0421\u041c\u0421\u0422", "\u0421\u041f\u041e\u0411", "\u0421\u0420\u041f\u0429", "\u0421\u0425\u0411\u0413", "\u0421\u0426\u041f\u0429", "\u0424\u0420\u041f\u0429", "\u0427\u041f\u0421\u0416");
    private static final List<String> ignoreEventTypes = Arrays.asList("ACKI", "ADPI", "BSNS", "BUSI", "CHLD", "CHNM", "CKFE", "CKIN", "CLAS", "CTCE", "CTCM", "CTCR", "DEAL", "DEPA", "DEPU", "DOCA", "DOCO", "DOCS", "EMPL", "FAST", "FLEX", "FOID", "FQTR", "FQTU", "GRPO", "GRPS", "INFT", "JUST", "TKNE", "TKNM", "PCTC", "TLAC");
    private static final Logger log = LoggerFactory.getLogger(AirlineMessageParser.class);
    private static final String AS_AIRLINE = "airline";
    private static final String AS_BKGCLS = "bkgcls";
    private static final String AS_COUNT = "count";
    private static final String AS_DATE = "date";
    private static final String AS_DATETIME = "datetime";
    private static final String AS_DESCRIPTION = "description";
    private static final String AS_FLTNO = "fltno";
    private static final String AS_FROM = "from";
    private static final String AS_STATUS = "status";
    private static final String AS_TIME = "time";
    private static final String AS_TIMEZONE = "timezone";
    private static final String AS_TO = "to";
    private static final String AS_DEPARTURE_ARRIVAL = "deparr";
    private static final String AS_TERMINAL = "terminal";
    public static final String HK = AirlineMessageParser.or("HK[0-9]", "\u041d\u041a[0-9]");
    private static final String S = "[ \\/\\.\\-\\:]+";
    private static final String OS = AirlineMessageParser.opt("[ \\/\\.\\-\\:]+");
    private static final String ANYTHING = ".*";
    private static final String ADVISE = AirlineMessageParser.or("ADV", "ISSUE", "RI", "AD", "ADVISE", "ISS", "ADTK", "PRVD", "PROVIDE", "SEND", "UPDATE");
    private static final String AIRLINE = "[A-Z0-9]{2}";
    private static final String BKGCLS = "[A-Z]";
    private static final String CANCEL = AirlineMessageParser.opt(AirlineMessageParser.opt("[A-Z0-9]{2}[ \\/\\.\\-\\:]+" + AirlineMessageParser.opt("OPTG\\/MKTG[ \\/\\.\\-\\:]+")) + AirlineMessageParser.or("PNR", "SEG", "SEGS", "SPACE", "FLTS")) + OS + AirlineMessageParser.opt(AirlineMessageParser.or("WILL BE", "WILLBE", "SUBJECT TO", "SUBJ TO", "TO AVOID", "WILL") + OS) + AirlineMessageParser.opt("AUTO" + OS) + AirlineMessageParser.or("XX", "CANCELL?ED", "CNL", "CANCEL", "XLD", "CXL", "XXLD?", "CNLD", "CXLD", "CANX", "XXNAL", "CNLD");
    private static final String EMD = AirlineMessageParser.or("EMD");
    private static final String FLTNO = "\\d{1,4}";
    private static final String GEO = "[A-Z\u0410-\u042f]{3}";
    private static final String LOCALTIME = AirlineMessageParser.or("LT", "LOCAL TIME", "TIME");
    private static final String OR = AirlineMessageParser.or("OR", "OTHERWISE");
    private static final String PLEASE = AirlineMessageParser.or("PLS", "REMINDER", "PLZ", "PLEASE", "REMINDER PLS");
    private static final String TICKET = AirlineMessageParser.opt("AUTOMATIC[ \\/\\.\\-\\:]+") + AirlineMessageParser.or("TKNE", "TKT NBRS?", "TKNO", "TKT", "TKTS", "TICKET", "TK", "TKTNBR", "TICKETS", "ELECTRONIC TKT NR", "SSR TKNA\\/E\\/M\\/C", "TKTNUMBR", "TKT NUMBER") + AirlineMessageParser.opt("[ \\/\\.\\-\\:]+" + AirlineMessageParser.or("FOR ITIN", "OF [A-Z0-9]{2} SEGS?"));
    private static final String TO = AirlineMessageParser.or("TO", "FOR");
    private static final String UNTIL = AirlineMessageParser.or("BY", "ON", "SET", "BEFORE", "ON\\/BEFORE", "LATEST");
    private static final String RLOC = "[A-Z0-9]{6}";
    private static final String DAYOFWEEK = AirlineMessageParser.or("MON", "TUE", "WED", "THU", "FRI", "SAT", "SUN");
    private static final String MONTH_MMM = AirlineMessageParser.or("JAN", "FEB", "MAR", "APR", "MAY", "JUN", "JUL", "AUG", "SEP", "OCT", "NOV", "DEC");
    private static final DateTimeFormatter DTF_DDMMMYYYY = new DateTimeFormatterBuilder().parseCaseInsensitive().appendPattern("ddMMMyyyy").toFormatter(Locale.ENGLISH);
    private static final DateTimeFormatter DTF_DDMMMYY = new DateTimeFormatterBuilder().parseCaseInsensitive().appendPattern("ddMMMyy").toFormatter(Locale.ENGLISH);
    private static final DateTimeFormatter DTF_DDMMM = new DateTimeFormatterBuilder().parseCaseInsensitive().parseDefaulting(ChronoField.YEAR, LocalDate.now().getYear()).appendPattern("ddMMM").toFormatter(Locale.ENGLISH);
    private static final DateTimeFormatter DTF_DMMM = new DateTimeFormatterBuilder().parseCaseInsensitive().parseDefaulting(ChronoField.YEAR, LocalDate.now().getYear()).appendPattern("dMMM").toFormatter(Locale.ENGLISH);
    private static final DateTimeFormatter DTF_MMDDYY = DateTimeFormatter.ofPattern("MM/dd/yy");
    private static final DateTimeFormatter DTF_DDMMYY = DateTimeFormatter.ofPattern("ddMMyy");
    private static final Map<Pattern, DateParser> DATE_FORMATS = new LinkedHashMap<Pattern, DateParser>();
    private static final String DATE;
    private static final Map<Pattern, TimeParser> TIME_FORMATS;
    private static final String TIME;
    private static final String AS_GEO = "geo";
    private static final List<Pattern> PS_GEO_LOCALTIME;
    private static final String GEO_EXCLUSION = "IRC";
    private static final Map<Pattern, TimeZoneParser> TIMEZONE_FORMATS;
    private static final List<Pattern> PCC_TIME_ZONE_PATTERNS;
    private static final String TIMEZONE;
    private static final String HOURS;
    private static final Pattern P_DATETIME_HOURS_AFTER_RES;
    private static final Pattern P_DATETIME_HOURS_AFTER_RES2;
    private static final Pattern P_DATETIME_HOURS_BEFORE_DEP;
    private static Map<Pattern, DateTimeParser> DATETIME_FORMATS;
    private static final String DATETIME;
    private static final List<Pattern> PS_SERVICE_STATUS_CHANGE;
    private static final List<MiscUtil.Pair<String, Pattern>> PS_SERVICE_STATUS_CHANGE2;
    private static final Pattern P_SERVICE_STATUS_CHANGE_EXC1;
    public static final List<Pattern> PS_OPW;
    public static final List<Pattern> PS_OPC;
    public static final List<Pattern> PS_ADMD;
    public static final List<Pattern> PS_ADTK;
    private static final List<Pattern> PS_DUPE;
    private static final List<Pattern> PS_IGNORE;
    private static final List<Pattern> PS_SEGMENTS_CANCELED;
    private static final List<Pattern> PS_SEGMENTS_CANCELED_NO_SHOW;
    private static final List<Pattern> PS_TKTL;
    private static final List<Pattern> PS_SCHEDULE_CHANGE;
    private static final List<Pattern> PS_MANUAL_HANDLING;
    private static final List<MiscUtil.Pair<Pattern, QueueWatchAgentNotificationType>> PS_AGENT_NOTIFICATION;

    public static List<BaseQueueWatchEvent> parse(AirlineMessage message, Reservation reservation) {
        ArrayList<BaseQueueWatchEvent> result = new ArrayList<BaseQueueWatchEvent>();
        if (message != null) {
            BaseQueueWatchEvent event = AirlineMessageParser.parseSingleMessage(message, reservation);
            if (event != null) {
                result.add(event);
            } else {
                String originalMessage = message.getMessage();
                List<String> lines = Arrays.asList(originalMessage.split("\n"));
                int i = 0;
                while (i < lines.size()) {
                    int jmax = -1;
                    int j = i + 1;
                    while (j < lines.size() + 1) {
                        List<String> subList = lines.subList(i, j);
                        message.setMessage(String.join((CharSequence)"\n", subList).trim());
                        BaseQueueWatchEvent event2 = AirlineMessageParser.parseSingleMessage(message, reservation);
                        if (event2 == null) break;
                        event = event2;
                        jmax = j++;
                    }
                    if (jmax < 0) {
                        log.error(String.format("failed parsing %s %s", message.getType(), originalMessage));
                        return null;
                    }
                    result.add(event);
                    i = jmax;
                }
            }
            for (BaseQueueWatchEvent event1 : result) {
                event1.setDateTime(message.getDate());
            }
        }
        return result;
    }

    private static BaseQueueWatchEvent parseSingleMessage(AirlineMessage message, Reservation reservation) {
        if (serviceStatusChangeTypes.contains(message.getType())) {
            return AirlineMessageParser.parseServiceStatusChange(message);
        }
        if (ignoreEventTypes.contains(message.getType())) {
            return new IgnoreEvent();
        }
        switch (message.getType()) {
            case "ADMD": {
                return AirlineMessageParser.parseADMD(message);
            }
            case "ADTK": {
                return AirlineMessageParser.parseADTK(message, reservation);
            }
            case "OPC": {
                return AirlineMessageParser.parseOPC(message, reservation);
            }
            case "OPW": {
                return AirlineMessageParser.parseOPW(message, reservation);
            }
            case "QERR": {
                return new ManualHandlingEvent();
            }
            case "OTHS": {
                return AirlineMessageParser.parseOTHS(message, reservation);
            }
            case "TKTL": {
                return AirlineMessageParser.parseTKTL(message, reservation);
            }
            case "\u041f\u0420\u041e\u0427": {
                return AirlineMessageParser.parseOTHS(message, reservation);
            }
            case "\u0421\u0422\u041a\u0422": {
                return AirlineMessageParser.parseCTKT(message, reservation);
            }
        }
        log.error(String.format("unknown type %s", message.getType()));
        return null;
    }

    private static BaseQueueWatchEvent parseServiceStatusChange(AirlineMessage message) {
        for (int i = 0; i < PS_SERVICE_STATUS_CHANGE.size(); ++i) {
            Matcher m = PS_SERVICE_STATUS_CHANGE.get(i).matcher(message.getMessage());
            if (!m.matches()) continue;
            log.debug(String.format("PS_SERVICE_STATUS_CHANGE[%d]", i));
            ServiceStatusChangeEvent result = new ServiceStatusChangeEvent();
            result.setStatus(m.group(AS_STATUS));
            return result;
        }
        if (P_SERVICE_STATUS_CHANGE_EXC1.matcher(message.getMessage()).matches()) {
            switch (message.getType()) {
                case "CHML": 
                case "HNML": {
                    return new IgnoreEvent();
                }
            }
        }
        log.error(String.format("unknown service status change format for type %s: %s", message.getType(), message.getMessage()));
        return null;
    }

    private static BaseQueueWatchEvent parseServiceStatusChange2(AirlineMessage message) {
        for (int i = 0; i < PS_SERVICE_STATUS_CHANGE2.size(); ++i) {
            Matcher m;
            MiscUtil.Pair<String, Pattern> pair = PS_SERVICE_STATUS_CHANGE2.get(i);
            if (!message.getType().equals(pair.getFirst()) || !(m = ((Pattern)pair.getSecond()).matcher(message.getMessage())).matches()) continue;
            log.debug(String.format("PS_SERVICE_STATUS_CHANGE[%d]", i));
            ServiceStatusChangeEvent result = new ServiceStatusChangeEvent();
            result.setStatus(m.group(AS_STATUS));
            return result;
        }
        return null;
    }

    private static BaseQueueWatchEvent parseOPW(AirlineMessage message, Reservation reservation) {
        for (int i = 0; i < PS_OPW.size(); ++i) {
            Matcher m = PS_OPW.get(i).matcher(message.getMessage());
            if (!m.matches()) continue;
            log.debug(String.format("PS_OPW[%d]", i));
            TicketTimelimitChangeEvent result = new TicketTimelimitChangeEvent();
            result.setNewTimelimit(AirlineMessageParser.parseNewTimelimitOP(m, message, reservation));
            return result;
        }
        log.error(String.format("unknown OPW format: %s", message.getMessage()));
        return null;
    }

    private static BaseQueueWatchEvent parseOPC(AirlineMessage message, Reservation reservation) {
        for (int i = 0; i < PS_OPC.size(); ++i) {
            Matcher m = PS_OPC.get(i).matcher(message.getMessage());
            if (!m.matches()) continue;
            log.debug(String.format("PS_OPC[%d]", i));
            TicketTimelimitChangeEvent result = new TicketTimelimitChangeEvent();
            result.setNewTimelimit(AirlineMessageParser.parseNewTimelimitOP(m, message, reservation));
            return result;
        }
        log.error(String.format("unknown OPC format: %s", message.getMessage()));
        return null;
    }

    private static BaseQueueWatchEvent parseADMD(AirlineMessage message) {
        for (int i = 0; i < PS_ADMD.size(); ++i) {
            Matcher m = PS_ADMD.get(i).matcher(message.getMessage());
            if (!m.matches()) continue;
            log.debug(String.format("PS_ADMD[%d]", i));
            return new IgnoreEvent();
        }
        log.error(String.format("unknown ADMD format: %s", message.getMessage()));
        return null;
    }

    private static BaseQueueWatchEvent parseADTK(AirlineMessage message, Reservation reservation) {
        Matcher m;
        int i;
        for (i = 0; i < PS_ADTK.size(); ++i) {
            m = PS_ADTK.get(i).matcher(message.getMessage());
            if (!m.matches()) continue;
            log.debug(String.format("PS_ADTK[%d]", i));
            TicketTimelimitChangeEvent result = new TicketTimelimitChangeEvent();
            result.setNewTimelimit(AirlineMessageParser.parseNewTimelimit(m, message, reservation));
            return result;
        }
        for (i = 0; i < PS_SEGMENTS_CANCELED_NO_SHOW.size(); ++i) {
            m = PS_SEGMENTS_CANCELED_NO_SHOW.get(i).matcher(message.getMessage());
            if (!m.matches()) continue;
            log.debug(String.format("PS_SEGMENTS_CANCELED_NO_SHOW[%d]", i));
            SegmentsCancelledEvent result = new SegmentsCancelledEvent();
            result.setReason(SegmentsCancelledEventReason.NO_SHOW);
            return result;
        }
        for (i = 0; i < PS_SEGMENTS_CANCELED.size(); ++i) {
            m = PS_SEGMENTS_CANCELED.get(i).matcher(message.getMessage());
            if (!m.matches()) continue;
            log.debug(String.format("PS_SEGMENTS_CANCELED[%d]", i));
            SegmentsCancelledEvent result = new SegmentsCancelledEvent();
            return result;
        }
        for (i = 0; i < PS_IGNORE.size(); ++i) {
            m = PS_IGNORE.get(i).matcher(message.getMessage());
            if (!m.matches()) continue;
            log.debug(String.format("PS_IGNORE[%d]", i));
            return new IgnoreEvent();
        }
        log.error(String.format("unknown ADTK format: %s", message.getMessage()));
        return null;
    }

    private static BaseQueueWatchEvent parseOTHS(AirlineMessage message, Reservation reservation) {
        int i;
        TicketTimelimitChangeEvent result;
        Matcher m;
        int i2;
        Matcher m2;
        if (serviceStatusChangeTypes.stream().anyMatch(type -> message.getMessage().startsWith((String)type))) {
            message.setMessage(message.getMessage().substring(5));
            return AirlineMessageParser.parseServiceStatusChange(message);
        }
        for (MiscUtil.Pair<Pattern, QueueWatchAgentNotificationType> pair : PS_AGENT_NOTIFICATION) {
            m2 = ((Pattern)pair.getFirst()).matcher(message.getMessage());
            if (!m2.matches()) continue;
            AgentNotificationEvent result2 = new AgentNotificationEvent();
            result2.setNotificationData(AirlineMessageParser.parseAgentNotificationData(m2, (QueueWatchAgentNotificationType)pair.getSecond(), reservation));
            return result2;
        }
        for (i2 = 0; i2 < PS_ADTK.size(); ++i2) {
            m = PS_ADTK.get(i2).matcher(message.getMessage());
            if (!m.matches()) continue;
            log.debug(String.format("PS_ADTK[%d]", i2));
            result = new TicketTimelimitChangeEvent();
            result.setNewTimelimit(AirlineMessageParser.parseNewTimelimit(m, message, reservation));
            return result;
        }
        for (i2 = 0; i2 < PS_SEGMENTS_CANCELED_NO_SHOW.size(); ++i2) {
            m = PS_SEGMENTS_CANCELED_NO_SHOW.get(i2).matcher(message.getMessage());
            if (!m.matches()) continue;
            log.debug(String.format("PS_SEGMENTS_CANCELED_NO_SHOW[%d]", i2));
            result = new SegmentsCancelledEvent();
            result.setReason(SegmentsCancelledEventReason.NO_SHOW);
            return result;
        }
        for (i2 = 0; i2 < PS_SEGMENTS_CANCELED.size(); ++i2) {
            m = PS_SEGMENTS_CANCELED.get(i2).matcher(message.getMessage());
            if (!m.matches()) continue;
            log.debug(String.format("PS_SEGMENTS_CANCELED[%d]", i2));
            result = new SegmentsCancelledEvent();
            return result;
        }
        for (i2 = 0; i2 < PS_DUPE.size(); ++i2) {
            m = PS_DUPE.get(i2).matcher(message.getMessage());
            if (!m.matches()) continue;
            log.debug(String.format("PS_DUPE[%d]", i2));
            result = new DupeWarningEvent();
            return result;
        }
        for (i2 = 0; i2 < PS_SCHEDULE_CHANGE.size(); ++i2) {
            m = PS_SCHEDULE_CHANGE.get(i2).matcher(message.getMessage());
            if (!m.matches()) continue;
            log.debug(String.format("PS_SCHEDULE_CHANGE[%d]", i2));
            result = new ScheduleChangeEvent();
            return result;
        }
        BaseQueueWatchEvent event = AirlineMessageParser.parseServiceStatusChange2(message);
        if (event != null) {
            return event;
        }
        for (i = 0; i < PS_MANUAL_HANDLING.size(); ++i) {
            m2 = PS_MANUAL_HANDLING.get(i).matcher(message.getMessage());
            if (!m2.matches()) continue;
            log.debug(String.format("PS_MANUAL_HANDLING[%d]", i));
            return new ManualHandlingEvent();
        }
        for (i = 0; i < PS_IGNORE.size(); ++i) {
            m2 = PS_IGNORE.get(i).matcher(message.getMessage());
            if (!m2.matches()) continue;
            log.debug(String.format("PS_IGNORE[%d]", i));
            return new IgnoreEvent();
        }
        log.error(String.format("unknown OTHS format: %s", message.getMessage()));
        return null;
    }

    private static TicketTimelimitChangeEvent parseCTKT(AirlineMessage message, Reservation reservation) {
        for (int i = 0; i < PS_ADTK.size(); ++i) {
            Matcher m = PS_ADTK.get(i).matcher(message.getMessage());
            if (!m.matches()) continue;
            log.debug(String.format("PS_ADTK[%d]", i));
            TicketTimelimitChangeEvent result = new TicketTimelimitChangeEvent();
            result.setNewTimelimit(AirlineMessageParser.parseNewTimelimit(m, message, reservation));
            return result;
        }
        log.error(String.format("unknown CTKT format: %s", message.getMessage()));
        return null;
    }

    private static TicketTimelimitChangeEvent parseTKTL(AirlineMessage message, Reservation reservation) {
        for (int i = 0; i < PS_TKTL.size(); ++i) {
            Matcher m = PS_TKTL.get(i).matcher(message.getMessage());
            if (!m.matches()) continue;
            log.debug(String.format("PS_TKTL[%d]", i));
            TicketTimelimitChangeEvent result = new TicketTimelimitChangeEvent();
            result.setNewTimelimit(AirlineMessageParser.parseNewTimelimit(m, message, reservation));
            return result;
        }
        log.error(String.format("unknown TKTL format: %s", message.getMessage()));
        return null;
    }

    private static Date parseNewTimelimit(Matcher matcher, AirlineMessage message, Reservation reservation) {
        Matcher m;
        Object data;
        Date tl = null;
        if (matcher.pattern().pattern().contains("(?<datetime>")) {
            String data2 = matcher.group(AS_DATETIME);
            for (Map.Entry<Pattern, DateTimeParser> entry : DATETIME_FORMATS.entrySet()) {
                Matcher m2 = entry.getKey().matcher(data2);
                if (!m2.matches()) continue;
                tl = entry.getValue().parse(data2, reservation);
                break;
            }
            if (tl == null) {
                throw Xeption.forDeveloper((String)"impossible (datetime)", (Object[])new Object[0]);
            }
            return tl;
        }
        LocalDate date = null;
        LocalTime time = null;
        ZoneId zone = null;
        if (matcher.pattern().pattern().contains("(?<date>")) {
            data = matcher.group(AS_DATE);
            for (Map.Entry<Pattern, DateParser> entry : DATE_FORMATS.entrySet()) {
                m = entry.getKey().matcher((CharSequence)data);
                if (!m.matches()) continue;
                date = entry.getValue().parse((String)data);
                break;
            }
            if (date == null) {
                throw Xeption.forDeveloper((String)"impossible (date)", (Object[])new Object[0]);
            }
        }
        if (matcher.pattern().pattern().contains("(?<time>") && (data = matcher.group(AS_TIME)) != null) {
            for (Map.Entry<Pattern, Object> entry : TIME_FORMATS.entrySet()) {
                m = entry.getKey().matcher((CharSequence)data);
                if (!m.matches()) continue;
                time = ((TimeParser)entry.getValue()).parse((String)data);
                break;
            }
            if (time == null) {
                throw Xeption.forDeveloper((String)"impossible (time)", (Object[])new Object[0]);
            }
        }
        data = PCC_TIME_ZONE_PATTERNS.iterator();
        while (data.hasNext()) {
            Pattern pattern = (Pattern)data.next();
            if (!pattern.matcher(message.getMessage()).matches()) continue;
            zone = AirlineMessageParser.getPccTimeZoneId(reservation);
            break;
        }
        if (zone == null && matcher.pattern().pattern().contains("(?<timezone>") && (data = matcher.group(AS_TIMEZONE)) != null) {
            for (Map.Entry<Pattern, Object> entry : TIMEZONE_FORMATS.entrySet()) {
                m = entry.getKey().matcher((CharSequence)data);
                if (!m.matches()) continue;
                zone = ((TimeZoneParser)entry.getValue()).parse((String)data, reservation);
                break;
            }
            if (zone == null) {
                throw Xeption.forDeveloper((String)"impossible (zone)", (Object[])new Object[0]);
            }
        }
        if (date != null) {
            if (time != null) {
                if (zone == null) {
                    zone = DictHelper.getZoneId(AirlineMessageParser.getDepartureLocation(reservation));
                }
            } else {
                time = LocalTime.of(23, 59, 59);
                if (!(message.getMessage().contains(" BY ") || message.getMessage().startsWith("BY ") || message.getMessage().contains(" ON ") || message.getMessage().startsWith("ON ") || message.getMessage().contains(" BEFORE ") || message.getMessage().startsWith("BEFORE "))) {
                    date = date.minusDays(1L);
                }
                if (zone == null) {
                    zone = DictHelper.getZoneId(AirlineMessageParser.getDepartureLocation(reservation));
                }
            }
        } else if (time != null) {
            date = message.getDate().toLocalDate();
            if (zone == null) {
                zone = DictHelper.getZoneId(AirlineMessageParser.getDepartureLocation(reservation));
            }
        }
        if (date == null || time == null || zone == null) {
            if (matcher.pattern().pattern().contains("(?<immediate>")) {
                return null;
            }
            throw Xeption.forDeveloper((String)("couldn't determine timelimit: " + message.getMessage()), (Object[])new Object[0]);
        }
        tl = Date.from(date.atTime(time).atZone(zone).toInstant());
        return tl;
    }

    private static Date parseNewTimelimitOP(Matcher matcher, AirlineMessage message, Reservation reservation) {
        Matcher m;
        String data;
        LocalDate date = null;
        LocalTime time = null;
        ZoneId zone = null;
        if (matcher.pattern().pattern().contains("(?<date>") && (data = matcher.group(AS_DATE)) != null) {
            for (Map.Entry<Pattern, DateParser> entry : DATE_FORMATS.entrySet()) {
                m = entry.getKey().matcher(data);
                if (!m.matches()) continue;
                date = entry.getValue().parse(data);
                break;
            }
            if (date == null) {
                throw Xeption.forDeveloper((String)"impossible (date)", (Object[])new Object[0]);
            }
        }
        if (matcher.pattern().pattern().contains("(?<time>") && (data = matcher.group(AS_TIME)) != null) {
            for (Map.Entry<Pattern, Object> entry : TIME_FORMATS.entrySet()) {
                m = entry.getKey().matcher(data);
                if (!m.matches()) continue;
                time = ((TimeParser)entry.getValue()).parse(data);
                break;
            }
            if (time == null) {
                throw Xeption.forDeveloper((String)"impossible (time)", (Object[])new Object[0]);
            }
        }
        if (matcher.pattern().pattern().contains("(?<timezone>") && (data = matcher.group(AS_TIMEZONE)) != null) {
            for (Map.Entry<Pattern, Object> entry : TIMEZONE_FORMATS.entrySet()) {
                m = entry.getKey().matcher(data);
                if (!m.matches()) continue;
                zone = ((TimeZoneParser)entry.getValue()).parse(data, reservation);
                break;
            }
            if (zone == null) {
                throw Xeption.forDeveloper((String)"impossible (zone)", (Object[])new Object[0]);
            }
        }
        if (date == null) {
            date = message.getDate().toLocalDate();
        }
        if (time == null) {
            time = LocalTime.of(23, 59, 59);
            if (!(message.getMessage().contains(" BY ") || message.getMessage().startsWith("BY ") || message.getMessage().contains(" ON ") || message.getMessage().startsWith("ON ") || message.getMessage().contains(" BEFORE ") || message.getMessage().startsWith("BEFORE "))) {
                date = date.minusDays(1L);
            }
        }
        if (zone == null) {
            zone = AirlineMessageParser.getPccTimeZoneId(reservation);
        }
        if (date == null || time == null || zone == null) {
            if (matcher.pattern().pattern().contains("(?<immediate>")) {
                return null;
            }
            throw Xeption.forDeveloper((String)("couldn't determine timelimit: " + message.getMessage()), (Object[])new Object[0]);
        }
        Date tl = Date.from(date.atTime(time).atZone(zone).toInstant());
        return tl;
    }

    private static ZoneId getPccTimeZoneId(Reservation reservation) {
        if ("FAKE_SALES_POINT_REF".equals(reservation.getSalesPoint().getUid())) {
            return ZoneId.of("Europe/Moscow");
        }
        String zoneId = (String)Streams.singleOrNull(reservation.getGdsNameInfo().getSystemInfos().stream().flatMap(si -> PccHelper.findPcc((EntityReference)reservation.getSalesPoint(), (String)si.getBookingPcc(), (GdsName)si.getGdsName()).getParameters().stream().filter(p -> PccParameterName.SABRE_TIME_ZONE.equals((Object)p.getName())).map(PccParameter::getValue)).distinct());
        return zoneId != null ? ZoneId.of(zoneId) : null;
    }

    private static QueueWatchAgentNotificationData parseAgentNotificationData(Matcher matcher, QueueWatchAgentNotificationType notificationType, Reservation reservation) {
        if (notificationType == QueueWatchAgentNotificationType.TERMINAL_CHANGE) {
            Segment segment;
            List segments;
            QueueWatchTerminalChangeAgentNotificationData data = new QueueWatchTerminalChangeAgentNotificationData();
            data.setNotificationType(notificationType);
            data.setFlightNumber(matcher.group(AS_FLTNO));
            String locationCode = matcher.group(AS_GEO);
            if (!matcher.pattern().pattern().contains("?<deparr>")) {
                segments = AirProductHelper.getProductSegmentsList((Product)((Product)AirProductHelper.getAirProductsList((Reservation)reservation).get(0)));
                segment = AirlineMessageParser.getSegmentWithFlightNumber(segments, data.getFlightNumber());
                if (locationCode.equals(DictHelper.getCodeVariant((DictionaryReference)segment.getDepartureLocation(), (CodeSystem[])new CodeSystem[]{CodeSystem.IATA}))) {
                    data.setIsDepartureAirport(Boolean.TRUE);
                } else {
                    data.setIsDepartureAirport(Boolean.FALSE);
                }
            } else {
                String departureOrArrival = matcher.group(AS_DEPARTURE_ARRIVAL);
                data.setIsDepartureAirport(departureOrArrival.equals("DEP") ? Boolean.TRUE : Boolean.FALSE);
            }
            if (StringUtils.isEmpty((String)locationCode)) {
                segments = AirProductHelper.getProductSegmentsList((Product)((Product)AirProductHelper.getAirProductsList((Reservation)reservation).get(0)));
                segment = AirlineMessageParser.getSegmentWithFlightNumber(segments, data.getFlightNumber());
                data.setAirport(data.getIsDepartureAirport() != false ? segment.getDepartureLocation() : segment.getArriveLocation());
            } else {
                data.setAirport((DictionaryReference)DictHelper.findAirportByCodeVariant((String)locationCode).toReference());
            }
            data.setTerminal(matcher.group(AS_TERMINAL));
            if (data.getIsDepartureAirport() == null || data.getFlightNumber() == null || data.getAirport() == null || data.getTerminal() == null) {
                throw Xeption.forDeveloper((String)("Terminal change notification incomplete data: " + matcher.group()), (Object[])new Object[0]);
            }
            return data;
        }
        if (notificationType == QueueWatchAgentNotificationType.EMIRATES_COVID19) {
            QueueWatchAgentNotificationData data = new QueueWatchAgentNotificationData();
            data.setNotificationType(notificationType);
            return data;
        }
        if (notificationType == QueueWatchAgentNotificationType.ALITALIA_COVID19) {
            QueueWatchAgentNotificationData data = new QueueWatchAgentNotificationData();
            data.setNotificationType(notificationType);
            return data;
        }
        return null;
    }

    private static Segment getSegmentWithFlightNumber(List<Segment> segments, String flightNumber) {
        List segs = segments.stream().filter(s -> s.getFlightNo().equals(flightNumber)).collect(Collectors.toList());
        if (segs.size() > 1) {
            throw Xeption.forEndUser((String)("Found multiple segments with flight number " + flightNumber), (Object[])new Object[0]);
        }
        return (Segment)segs.get(0);
    }

    private static String grab(String pattern, String name) {
        return String.format("(?<%s>%s)", name, pattern);
    }

    private static String opt(String pattern) {
        return String.format("(%s)?", pattern);
    }

    private static String many(String pattern) {
        return String.format("(%s)+", pattern);
    }

    private static String optmany(String pattern) {
        return String.format("(%s)*", pattern);
    }

    private static String or(String ... patterns) {
        return AirlineMessageParser.or(true, Arrays.asList(patterns));
    }

    private static String or(boolean sort, String ... patterns) {
        return AirlineMessageParser.or(sort, Arrays.asList(patterns));
    }

    private static String or(Collection<String> patterns) {
        return AirlineMessageParser.or(true, patterns);
    }

    private static String or(boolean sort, Collection<String> patterns) {
        ArrayList<String> sortedPatterns = new ArrayList<String>(patterns);
        if (sort) {
            sortedPatterns.sort((a, b) -> b.length() - a.length());
        }
        return String.format("(%s)", TextUtil.join((String)"|", sortedPatterns));
    }

    private static String optSpaces(String pattern) {
        return TextUtil.join((String)OS, Arrays.asList(pattern.split(S)));
    }

    private static Pattern clearGrab(Pattern pattern) {
        return Pattern.compile(pattern.pattern().replaceAll("\\?\\<[^\\>]+\\>", ""));
    }

    private static LocalDate ensureFutureDate(LocalDate date) {
        return date.isBefore(LocalDate.now()) ? date.plusYears(1L) : date;
    }

    private static DictionaryReference<GeoLocation> getDepartureLocation(Reservation reservation) {
        return AirProductHelper.getFirstSegment((Product)((Product)AirProductHelper.getAirProductsList((Reservation)reservation).get(0))).getDepartureLocation();
    }

    static {
        DATE_FORMATS.put(Pattern.compile("[0-3][0-9]" + MONTH_MMM + "[0-9]{4}"), data -> LocalDate.parse(data, DTF_DDMMMYYYY));
        DATE_FORMATS.put(Pattern.compile("[0-3][0-9]" + MONTH_MMM + "[0-9]{2}"), data -> LocalDate.parse(data, DTF_DDMMMYY));
        DATE_FORMATS.put(Pattern.compile("[0-3][0-9]" + MONTH_MMM), data -> AirlineMessageParser.ensureFutureDate(LocalDate.parse(data, DTF_DDMMM)));
        DATE_FORMATS.put(Pattern.compile("[0-9]" + MONTH_MMM), data -> AirlineMessageParser.ensureFutureDate(LocalDate.parse(data, DTF_DMMM)));
        DATE_FORMATS.put(Pattern.compile("[0-1][0-9]\\/[0-3][0-9]\\/[0-9]{2}"), data -> LocalDate.parse(data, DTF_MMDDYY));
        DATE_FORMATS.put(Pattern.compile("[0-3][0-9][0-1][0-9][0-9]{2}"), data -> LocalDate.parse(data, DTF_DDMMYY));
        DATE = AirlineMessageParser.or(false, DATE_FORMATS.keySet().stream().map(p -> p.pattern()).collect(Collectors.toList()));
        TIME_FORMATS = new LinkedHashMap<Pattern, TimeParser>();
        TIME_FORMATS.put(Pattern.compile("[0-2][0-9] [0-5][0-9]"), data -> LocalTime.parse(data, DateTimeFormatter.ofPattern("HH mm")));
        TIME_FORMATS.put(Pattern.compile("[0-2][0-9][0-5][0-9]"), data -> LocalTime.parse(data, DateTimeFormatter.ofPattern("HHmm")));
        TIME = AirlineMessageParser.or(false, TIME_FORMATS.keySet().stream().map(p -> p.pattern()).collect(Collectors.toList()));
        PS_GEO_LOCALTIME = new ArrayList<Pattern>();
        PS_GEO_LOCALTIME.add(Pattern.compile(AirlineMessageParser.grab(GEO, AS_GEO) + S + LOCALTIME));
        PS_GEO_LOCALTIME.add(Pattern.compile(LOCALTIME + S + AirlineMessageParser.grab(GEO, AS_GEO)));
        TIMEZONE_FORMATS = new LinkedHashMap<Pattern, TimeZoneParser>();
        TIMEZONE_FORMATS.put(Pattern.compile("LCLT AT BOARD POINT"), (data, res) -> DictHelper.getZoneId(AirlineMessageParser.getDepartureLocation(res)));
        TIMEZONE_FORMATS.put(Pattern.compile("LOCAL TIME"), (data, res) -> DictHelper.getZoneId(AirlineMessageParser.getDepartureLocation(res)));
        TIMEZONE_FORMATS.put(Pattern.compile("LT"), (data, res) -> DictHelper.getZoneId(AirlineMessageParser.getDepartureLocation(res)));
        for (Pattern p2 : PS_GEO_LOCALTIME) {
            TIMEZONE_FORMATS.put(AirlineMessageParser.clearGrab(p2), (data, res) -> {
                Matcher m = p2.matcher(data);
                if (!m.matches()) {
                    throw Xeption.forDeveloper((String)"impossible", (Object[])new Object[0]);
                }
                String code = m.group(AS_GEO);
                return Objects.requireNonNull(DictHelper.getZoneId((DictionaryReference)Objects.requireNonNull(DictHelper.findGeoLocationByCodeVariant((String)code), "location not found for " + code).toReference()), "no timezone for " + code);
            });
        }
        TIMEZONE_FORMATS.put(Pattern.compile("GMT[0-9]+"), (data, res) -> ZoneId.ofOffset("GMT", ZoneOffset.ofHours(Integer.parseInt(data.substring(3)))));
        Set tltzs = ZoneId.getAvailableZoneIds().stream().filter(s -> s.length() == 3).collect(Collectors.toSet());
        tltzs.addAll(ZoneId.SHORT_IDS.keySet());
        for (String tltz : tltzs) {
            GeoLocation loc = DictHelper.findGeoLocationByCodeVariant((String)tltz);
            if (loc == null) {
                TIMEZONE_FORMATS.put(Pattern.compile(tltz), (data, res) -> ZoneId.of(tltz, ZoneId.SHORT_IDS));
                continue;
            }
            TIMEZONE_FORMATS.put(Pattern.compile(tltz), (data, res) -> {
                GeoLocation dep = (GeoLocation)DictionaryCache.get().resolveReference(AirlineMessageParser.getDepartureLocation(res));
                if (tltz.equals(dep.getCodeVariants().get(CodeSystem.IATA.name()))) {
                    return ZoneId.of(dep.getTimeZoneId());
                }
                return ZoneId.of(tltz, ZoneId.SHORT_IDS);
            });
        }
        TIMEZONE_FORMATS.put(Pattern.compile("(?!IRC)[A-Z\u0410-\u042f]{3}"), (data, res) -> Objects.requireNonNull(DictHelper.getZoneId((DictionaryReference)Objects.requireNonNull(DictHelper.findGeoLocationByCodeVariant((String)data), "location not found for " + data).toReference()), "no timezone for " + data));
        TIMEZONE_FORMATS.put(Pattern.compile("Z"), (data, res) -> ZoneId.of("Z"));
        PCC_TIME_ZONE_PATTERNS = new ArrayList<Pattern>();
        PCC_TIME_ZONE_PATTERNS.add(Pattern.compile(".*[ \\/\\.\\-\\:]+IRC-2[ \\/\\.\\-\\:]+.*"));
        TIMEZONE = AirlineMessageParser.or(false, TIMEZONE_FORMATS.keySet().stream().map(p -> p.pattern()).collect(Collectors.toList()));
        HOURS = AirlineMessageParser.or("HOURS", "HRS", "H", "HOUR");
        P_DATETIME_HOURS_AFTER_RES = Pattern.compile(AirlineMessageParser.grab(AirlineMessageParser.or("[0-9]+", "ONE"), AS_COUNT) + OS + HOURS + S + "AFTER" + S + AirlineMessageParser.or("RESERVATION", "RES"));
        P_DATETIME_HOURS_AFTER_RES2 = Pattern.compile("WITHIN[ \\/\\.\\-\\:]+" + AirlineMessageParser.grab(AirlineMessageParser.or("[0-9]+"), AS_COUNT) + OS + HOURS);
        P_DATETIME_HOURS_BEFORE_DEP = Pattern.compile(AirlineMessageParser.grab("[0-9]+", AS_COUNT) + OS + HOURS + S + "BEFORE" + S + AirlineMessageParser.or("DEPARTURE", "DEP"));
        DATETIME_FORMATS = new LinkedHashMap<Pattern, DateTimeParser>();
        DATETIME_FORMATS.put(AirlineMessageParser.clearGrab(P_DATETIME_HOURS_AFTER_RES), (data, res) -> {
            Matcher m = P_DATETIME_HOURS_AFTER_RES.matcher(data);
            if (!m.matches()) {
                throw Xeption.forDeveloper((String)"impossible", (Object[])new Object[0]);
            }
            String count = m.group(AS_COUNT);
            if (count.equals("ONE")) {
                count = "1";
            }
            int hours = Integer.parseInt(count);
            return new DateTime((Object)res.getResDate()).plusHours(hours).toDate();
        });
        DATETIME_FORMATS.put(AirlineMessageParser.clearGrab(P_DATETIME_HOURS_AFTER_RES2), (data, res) -> {
            Matcher m = P_DATETIME_HOURS_AFTER_RES2.matcher(data);
            if (!m.matches()) {
                throw Xeption.forDeveloper((String)"impossible", (Object[])new Object[0]);
            }
            String count = m.group(AS_COUNT);
            int hours = Integer.parseInt(count);
            return new DateTime((Object)res.getResDate()).plusHours(hours).toDate();
        });
        DATETIME_FORMATS.put(AirlineMessageParser.clearGrab(P_DATETIME_HOURS_BEFORE_DEP), (data, res) -> {
            Matcher m = P_DATETIME_HOURS_BEFORE_DEP.matcher(data);
            if (!m.matches()) {
                throw Xeption.forDeveloper((String)"impossible", (Object[])new Object[0]);
            }
            int hours = Integer.parseInt(m.group(AS_COUNT));
            Date firstDepartureDate = null;
            for (Product prod : GDSHelper.getProducts(res)) {
                Date newDate = AirProductHelper.getFirstDepartureDate((Product)prod);
                if (firstDepartureDate != null && !newDate.before(firstDepartureDate)) continue;
                firstDepartureDate = newDate;
            }
            return new DateTime(firstDepartureDate).minusHours(hours).toDate();
        });
        DATETIME = AirlineMessageParser.or(false, DATETIME_FORMATS.keySet().stream().map(p -> p.pattern()).collect(Collectors.toList()));
        PS_SERVICE_STATUS_CHANGE = new ArrayList<Pattern>();
        PS_SERVICE_STATUS_CHANGE.add(Pattern.compile(AirlineMessageParser.grab(FLTNO, AS_FLTNO) + AirlineMessageParser.grab(BKGCLS, AS_BKGCLS) + AirlineMessageParser.grab(DATE, AS_DATE) + Pattern.quote("/") + AirlineMessageParser.grab(GEO, AS_FROM) + " " + AirlineMessageParser.grab("[A-Z]{2}", AS_STATUS) + AirlineMessageParser.grab("[0-9]+", AS_COUNT)));
        PS_SERVICE_STATUS_CHANGE.add(Pattern.compile(AirlineMessageParser.opt("([A-Z0-9]?)" + AirlineMessageParser.grab("[A-Z]{2}", AS_STATUS) + AirlineMessageParser.grab("[0-9]+", AS_COUNT)) + OS + AirlineMessageParser.opt(AirlineMessageParser.opt(AirlineMessageParser.grab(GEO, AS_FROM) + AirlineMessageParser.grab(GEO, AS_TO)) + AirlineMessageParser.grab(FLTNO, AS_FLTNO) + AirlineMessageParser.grab(BKGCLS, AS_BKGCLS) + AirlineMessageParser.grab(DATE, AS_DATE)) + AirlineMessageParser.opt(S + AirlineMessageParser.grab(ANYTHING, AS_DESCRIPTION))));
        PS_SERVICE_STATUS_CHANGE.add(Pattern.compile(AirlineMessageParser.opt(AIRLINE) + OS + AirlineMessageParser.grab("[\u0410-\u042fA-Z]{2}", AS_STATUS) + AirlineMessageParser.grab("[0-9]+", AS_COUNT) + OS + ANYTHING));
        PS_SERVICE_STATUS_CHANGE2 = new ArrayList<MiscUtil.Pair<String, Pattern>>();
        PS_SERVICE_STATUS_CHANGE2.add((MiscUtil.Pair<String, Pattern>)new MiscUtil.Pair((Object)"\u041f\u0420\u041e\u0427", (Object)Pattern.compile(AirlineMessageParser.grab("[\u0410-\u042fA-Z]{2}", AS_STATUS) + "[0-9]+" + S + ANYTHING + OS + "FQTVN" + S + ANYTHING)));
        P_SERVICE_STATUS_CHANGE_EXC1 = Pattern.compile("[A-Z]{2}[0-9]+\\d{1,4}[A-Z][0-9]{3}[A-Z]{2}");
        PS_OPW = new ArrayList<Pattern>();
        PS_OPW.add(Pattern.compile("[A-Z0-9]{2}[ \\/\\.\\-\\:]+REQUIRES TICKET ON OR BEFORE[ \\/\\.\\-\\:]+" + AirlineMessageParser.opt(AirlineMessageParser.grab(DATE, AS_DATE) + S) + AirlineMessageParser.opt(AirlineMessageParser.grab(TIME, AS_TIME) + S) + AirlineMessageParser.opt(AirlineMessageParser.grab(TIMEZONE, AS_TIMEZONE)) + ANYTHING));
        PS_OPW.add(Pattern.compile("[A-Z0-9]{2}[ \\/\\.\\-\\:]+REQUIRES DOCUMENT ON OR BEFORE[ \\/\\.\\-\\:]+" + AirlineMessageParser.opt(AirlineMessageParser.grab(DATE, AS_DATE) + S) + AirlineMessageParser.opt(AirlineMessageParser.grab(TIME, AS_TIME) + S) + AirlineMessageParser.opt(AirlineMessageParser.grab(TIMEZONE, AS_TIMEZONE)) + ANYTHING));
        PS_OPW.add(Pattern.compile("[ \\/\\.\\-\\:]+[A-Z0-9]{2}[ \\/\\.\\-\\:]+REQUIRES TICKET ON OR BEFORE[ \\/\\.\\-\\:]+" + AirlineMessageParser.opt(AirlineMessageParser.grab(DATE, AS_DATE) + S) + AirlineMessageParser.opt(AirlineMessageParser.grab(TIME, AS_TIME) + S) + AirlineMessageParser.opt(AirlineMessageParser.grab(TIMEZONE, AS_TIMEZONE)) + ANYTHING));
        PS_OPW.add(Pattern.compile("[ \\/\\.\\-\\:]+[A-Z0-9]{2}[ \\/\\.\\-\\:]+REQUIRES DOCUMENT ON OR BEFORE[ \\/\\.\\-\\:]+" + AirlineMessageParser.opt(AirlineMessageParser.grab(DATE, AS_DATE) + S) + AirlineMessageParser.opt(AirlineMessageParser.grab(TIME, AS_TIME) + S) + AirlineMessageParser.opt(AirlineMessageParser.grab(TIMEZONE, AS_TIMEZONE)) + ANYTHING));
        PS_OPC = new ArrayList<Pattern>();
        PS_OPC.add(Pattern.compile(AirlineMessageParser.grab(DATE, AS_DATE) + S + AirlineMessageParser.opt(AirlineMessageParser.grab(TIME, AS_TIME) + S) + ANYTHING + S + AIRLINE + S + "CANCELLATION DUE TO NO TICKET" + S + AirlineMessageParser.opt(AirlineMessageParser.grab(TIMEZONE, AS_TIMEZONE)) + ANYTHING));
        PS_OPC.add(Pattern.compile(AirlineMessageParser.grab(DATE, AS_DATE) + S + AirlineMessageParser.opt(AirlineMessageParser.grab(TIME, AS_TIME) + S) + ANYTHING + S + AIRLINE + S + "CANCELLATION DUE TO NO DOCUMENT" + S + AirlineMessageParser.opt(AirlineMessageParser.grab(TIMEZONE, AS_TIMEZONE)) + ANYTHING));
        PS_OPC.add(Pattern.compile(AirlineMessageParser.grab(DATE, AS_DATE) + S + AirlineMessageParser.opt(AirlineMessageParser.grab(TIME, AS_TIME) + S) + ANYTHING + S + AIRLINE + S + "CANCELLATION DUE TO NO DOCUMENT"));
        PS_ADMD = new ArrayList<Pattern>();
        PS_ADMD.add(Pattern.compile(".*[ \\/\\.\\-\\:]+" + CANCEL));
        PS_ADMD.add(Pattern.compile("ADV EMD[ \\/\\.\\-\\:]+.*[ \\/\\.\\-\\:]+" + UNTIL + S + DATE + S + ANYTHING));
        PS_ADTK = new ArrayList<Pattern>();
        PS_ADTK.add(Pattern.compile("[A-Z0-9]{2}[ \\/\\.\\-\\:]+\\d{1,4}[ \\/\\.\\-\\:]+" + DATE + S + UNTIL + S + AirlineMessageParser.grab(DATE, AS_DATE) + S + AirlineMessageParser.grab(TIME, AS_TIME) + OS + AirlineMessageParser.grab(TIMEZONE, AS_TIMEZONE) + S + OR + S + CANCEL));
        List<List> DTZ = Arrays.asList(Arrays.asList(AirlineMessageParser.grab(DATE, AS_DATE), AirlineMessageParser.grab(TIME, AS_TIME), AirlineMessageParser.grab(TIMEZONE, AS_TIMEZONE)), Arrays.asList(AirlineMessageParser.grab(DATE, AS_DATE), AirlineMessageParser.grab(TIMEZONE, AS_TIMEZONE), AirlineMessageParser.grab(TIME, AS_TIME)), Arrays.asList(AirlineMessageParser.grab(TIME, AS_TIME), AirlineMessageParser.grab(DATE, AS_DATE), AirlineMessageParser.grab(TIMEZONE, AS_TIMEZONE)), Arrays.asList(AirlineMessageParser.grab(TIME, AS_TIME), AirlineMessageParser.grab(TIMEZONE, AS_TIMEZONE), AirlineMessageParser.grab(DATE, AS_DATE)), Arrays.asList(AirlineMessageParser.grab(TIMEZONE, AS_TIMEZONE), AirlineMessageParser.grab(DATE, AS_DATE), AirlineMessageParser.grab(TIME, AS_TIME)), Arrays.asList(AirlineMessageParser.grab(TIMEZONE, AS_TIMEZONE), AirlineMessageParser.grab(TIME, AS_TIME), AirlineMessageParser.grab(DATE, AS_DATE)), Arrays.asList(AirlineMessageParser.grab(DATE, AS_DATE), AirlineMessageParser.grab(TIME, AS_TIME)), Arrays.asList(AirlineMessageParser.grab(TIME, AS_TIME), AirlineMessageParser.grab(DATE, AS_DATE)), Arrays.asList(AirlineMessageParser.grab(DATE, AS_DATE), AirlineMessageParser.grab(TIMEZONE, AS_TIMEZONE)), Arrays.asList(AirlineMessageParser.grab(TIMEZONE, AS_TIMEZONE), AirlineMessageParser.grab(DATE, AS_DATE)), Arrays.asList(AirlineMessageParser.grab(TIME, AS_TIME), AirlineMessageParser.grab(TIMEZONE, AS_TIMEZONE)), Arrays.asList(AirlineMessageParser.grab(TIMEZONE, AS_TIMEZONE), AirlineMessageParser.grab(TIME, AS_TIME)), Arrays.asList(AirlineMessageParser.grab(DATE, AS_DATE)), Arrays.asList(AirlineMessageParser.grab(TIME, AS_TIME)));
        DTZ.forEach(dtz -> PS_ADTK.add(Pattern.compile(AirlineMessageParser.opt(AirlineMessageParser.opt("[A-Z]{2}[0-9][ \\/\\.\\-\\:]+") + AirlineMessageParser.opt("[A-Z0-9]{2}[ \\/\\.\\-\\:]+") + AirlineMessageParser.opt(PLEASE + S) + AirlineMessageParser.many(AirlineMessageParser.opt(ADVISE + OS) + AirlineMessageParser.opt(TICKET + S)) + AirlineMessageParser.opt(TO + S + AirlineMessageParser.many("[A-Z0-9]{2}[ \\/\\.\\-\\:]+")) + AirlineMessageParser.opt("IN [A-Z] CLASS ")) + AirlineMessageParser.opt(OR + S + CANCEL + S) + UNTIL + S + TextUtil.join((String)OS, (Iterable)dtz) + AirlineMessageParser.opt(S + OR + S + CANCEL) + ANYTHING)));
        DTZ.forEach(dtz -> PS_ADTK.add(Pattern.compile(ANYTHING + TICKET + ANYTHING + S + AirlineMessageParser.or(UNTIL, "OSI/SSR") + S + TextUtil.join((String)OS, (Iterable)dtz) + ANYTHING)));
        DTZ.forEach(dtz -> PS_ADTK.add(Pattern.compile(ANYTHING + AirlineMessageParser.or(UNTIL, "OSI/SSR") + S + TextUtil.join((String)OS, (Iterable)dtz) + ANYTHING + CANCEL + ANYTHING)));
        DTZ.forEach(dtz -> PS_ADTK.add(Pattern.compile(ANYTHING + CANCEL + ANYTHING + AirlineMessageParser.or(UNTIL, "OSI/SSR") + S + TextUtil.join((String)OS, (Iterable)dtz) + ANYTHING)));
        PS_ADTK.add(Pattern.compile("[A-Z]{2}[0-9]+\\.REMINDER[ \\/\\.\\-\\:]+[A-Z0-9]{2}" + OS + "SEGS" + S + CANCEL + S + UNTIL + S + AirlineMessageParser.grab(DATE, AS_DATE)));
        PS_ADTK.add(Pattern.compile("[A-Z]{2}[0-9]+\\.TKT[ \\/\\.\\-\\:]+[A-Z0-9]{2}" + OS + "SEGS" + S + UNTIL + S + AirlineMessageParser.grab(DATE, AS_DATE) + S + CANCEL + ANYTHING));
        PS_ADTK.add(Pattern.compile("[A-Z0-9]{2}[ \\/\\.\\-\\:]+[A-Z][ \\/\\.\\-\\:]+CLS[ \\/\\.\\-\\:]+" + UNTIL + S + "XX" + S + AirlineMessageParser.grab(DATE, AS_DATE) + S + "XX" + S + "USING SSR" + S + OR + S + CANCEL));
        PS_ADTK.add(Pattern.compile("ATTN[ \\/\\.\\-\\:]+" + AirlineMessageParser.opt("CRI?T FLT[ \\/\\.\\-\\:]+") + "LAST DAY FOR TICKETING" + S + AirlineMessageParser.grab(DATE, AS_DATE) + AirlineMessageParser.opt(S + AirlineMessageParser.grab(TIME, AS_TIME)) + AirlineMessageParser.opt(S + AirlineMessageParser.grab(TIMEZONE, AS_TIMEZONE)) + AirlineMessageParser.opt(S + OR + S + CANCEL)));
        PS_ADTK.add(Pattern.compile("ATTN[ \\/\\.\\-\\:]+" + AirlineMessageParser.opt("CRT FLT[ \\/\\.\\-\\:]+") + "TKT MUST BE COMP?LETED WITHIN" + S + AirlineMessageParser.grab(DATETIME, AS_DATETIME)));
        PS_ADTK.add(Pattern.compile(ADVISE + S + TICKET + S + AirlineMessageParser.grab(DATETIME, AS_DATETIME) + S + "OR PNR" + S + CANCEL));
        PS_ADTK.add(Pattern.compile("CORRECT OR ISSUE ALL TICKETS BY[ \\/\\.\\-\\:]+" + AirlineMessageParser.grab(DATE, AS_DATE) + S + AirlineMessageParser.grab(TIME, AS_TIME) + S + AirlineMessageParser.grab(TIMEZONE, AS_TIMEZONE) + S + OR + S + CANCEL));
        Arrays.asList(Arrays.asList(AirlineMessageParser.grab(DATE, AS_DATE), AirlineMessageParser.opt(AirlineMessageParser.grab(TIME, AS_TIME)), AirlineMessageParser.opt(AirlineMessageParser.grab(TIMEZONE, AS_TIMEZONE))), Arrays.asList(AirlineMessageParser.opt(AirlineMessageParser.grab(TIME, AS_TIME)), AirlineMessageParser.grab(DATE, AS_DATE), AirlineMessageParser.opt(AirlineMessageParser.grab(TIMEZONE, AS_TIMEZONE)))).forEach(dtz -> PS_ADTK.add(Pattern.compile(CANCEL + S + "IF" + S + TICKET + S + "NOT RCVD" + S + AirlineMessageParser.opt("BY[ \\/\\.\\-\\:]+" + AirlineMessageParser.grab(AIRLINE, AS_AIRLINE) + S) + UNTIL + S + AirlineMessageParser.or(false, TextUtil.join((String)OS, (Iterable)dtz)))));
        PS_ADTK.add(Pattern.compile(AirlineMessageParser.grab(AIRLINE, AS_AIRLINE) + S + CANCEL + S + "OR SEND ADM IF NO" + S + TICKET + S + "IS ISSUED" + S + UNTIL + S + AirlineMessageParser.grab(TIME, AS_TIME) + AirlineMessageParser.grab(TIMEZONE, AS_TIMEZONE) + S + AirlineMessageParser.grab(DATE, AS_DATE)));
        PS_ADTK.add(Pattern.compile(AirlineMessageParser.grab(AIRLINE, AS_AIRLINE) + S + "CANCELS IF NO TKT ADVISED BY" + S + AirlineMessageParser.grab(DATE, AS_DATE) + S + AirlineMessageParser.grab(TIME, AS_TIME) + AirlineMessageParser.grab(TIMEZONE, AS_TIMEZONE)));
        PS_ADTK.add(Pattern.compile(AirlineMessageParser.grab(AIRLINE, AS_AIRLINE) + " RESERVES THE RIGHT TO AUTOCANCEL OR SEND ADM\nIF NO TKT IS ISSUED BY " + AirlineMessageParser.grab(DATE, AS_DATE) + S + AirlineMessageParser.grab(TIME, AS_TIME) + S + AirlineMessageParser.grab(TIMEZONE, AS_TIMEZONE) + " TIME\nTIMELIMIT FOR THIS PNR WILL NOT\nCHANGE IF REBOOKED. FARE RULES STILL APPLY"));
        PS_ADTK.add(Pattern.compile("[A-Z]{2}\\d\\.TKT " + AirlineMessageParser.grab(AIRLINE, AS_AIRLINE) + "SEGS BY " + AirlineMessageParser.grab(DATE, AS_DATE) + " TO AVOID AUTO CXL \\/EARLIER\n[A-Z]{2}\\d\\.TICKETING MAY BE REQUIRED BY FARE RULE"));
        PS_ADTK.add(Pattern.compile("[A-Z0-9]{2}[ \\/\\.\\-\\:]+REMINDS YOU TO ISSUE AND ADV E\\-TKT IN PNR BY[ \\/\\.\\-\\:]+" + AirlineMessageParser.grab(DATE, AS_DATE) + S + AirlineMessageParser.grab(TIME, AS_TIME) + S + AirlineMessageParser.grab(TIMEZONE, AS_TIMEZONE)));
        PS_ADTK.add(Pattern.compile("ATTN FROM[ \\/\\.\\-\\:]+[A-Z0-9]{2}[ \\/\\.\\-\\:]+ENTER VALID TICKET NBR BY[ \\/\\.\\-\\:]+" + AirlineMessageParser.grab(DATE, AS_DATE) + AirlineMessageParser.optmany("\n.*")));
        PS_ADTK.add(Pattern.compile("AGT[ \\/\\.\\-\\:]+[A-Z0-9]{2}[ \\/\\.\\-\\:]+PLS ENTER VALID TICKET NBR BY[ \\/\\.\\-\\:]+" + AirlineMessageParser.grab(DATE, AS_DATE) + S + OR + AirlineMessageParser.optmany("\n.*")));
        PS_ADTK.add(Pattern.compile("PLS ADV TKT NUMBER IN SSR TKNA\\/TKNE ELE SSR DOCS TO[ \\/\\.\\-\\:]+[A-Z0-9]{2}\n" + UNTIL + S + DATE + S + TIME + S + TIMEZONE + S + AirlineMessageParser.grab(DATE, AS_DATE) + S + AirlineMessageParser.grab(TIME, AS_TIME) + S + AirlineMessageParser.grab(TIMEZONE, AS_TIMEZONE) + S + OR + S + CANCEL));
        PS_ADTK.add(Pattern.compile("\\d+ ROBOTAUTO-PROCESS[ \\/\\.\\-\\:]+" + AirlineMessageParser.grab(DATE, AS_DATE) + S + AirlineMessageParser.grab(TIME, AS_TIME) + S + "SET" + S + DATE + S + TIME + "\nPLS ISSUE TKT IN TTL DEFINED - AIR SERBIA"));
        PS_ADTK.add(Pattern.compile("\\d+ ROBOTAUTO-PROCESS[ \\/\\.\\-\\:]+" + DATE + S + "SET" + S + DATE + S + TIME + "\nPLS ISSUE TKT BY" + S + AirlineMessageParser.grab(TIME, AS_TIME) + S + AirlineMessageParser.grab(DATE, AS_DATE) + S + "OR" + S + AIRLINE + S + "ITIN WILL BE CXLD"));
        PS_ADTK.add(Pattern.compile(ADVISE + S + UNTIL + S + AirlineMessageParser.grab(TIME, AS_TIME) + S + "LOCAL TIME" + S + AirlineMessageParser.grab(DATE, AS_DATE) + S + OR + S + CANCEL));
        PS_ADTK.add(Pattern.compile(CANCEL + S + "IF SSR TKNA/E OR FA NOT RCVD BY" + S + AIRLINE + S + UNTIL + S + AirlineMessageParser.grab(DATE, AS_DATE) + S + AirlineMessageParser.grab(TIME, AS_TIME) + S + AirlineMessageParser.grab(TIMEZONE, AS_TIMEZONE)));
        PS_ADTK.add(Pattern.compile("NN\\d\\. PLS TKT BY[ \\/\\.\\-\\:]+" + AirlineMessageParser.grab(TIME, AS_TIME) + S + AirlineMessageParser.grab(DATE, AS_DATE) + S + AirlineMessageParser.grab(TIMEZONE, AS_TIMEZONE) + "\nNN\\d\\. OR ITIN WILL BE CANCELED BY" + S + AIRLINE + "\nNN\\d\\. PLS NOTE FARE RULES MAY REQUIRE AN EARLIER TKT DTE\nNN\\d\\. FAILURE TO TKT BY EARLIER DTE MAY RESULT IN DEBITMEMO"));
        PS_ADTK.add(Pattern.compile("PLS ADTK OR CNL[ \\/\\.\\-\\:]+[A-Z0-9]{2}[ \\/\\.\\-\\:]+FLIGHT BY[ \\/\\.\\-\\:]+" + AirlineMessageParser.grab(DATE, AS_DATE) + S + AirlineMessageParser.grab(TIME, AS_TIME) + S + AirlineMessageParser.grab(TIMEZONE, AS_TIMEZONE)));
        PS_ADTK.add(Pattern.compile("PLS ADV TKNA[ \\/\\.\\-\\:]+TKNM BY[ \\/\\.\\-\\:]+" + AirlineMessageParser.grab(TIME, AS_TIME) + OS + AirlineMessageParser.grab(TIMEZONE, AS_TIMEZONE) + S + AirlineMessageParser.grab(DATE, AS_DATE) + S + OR + S + CANCEL));
        PS_ADTK.add(Pattern.compile("PLS ISSUE TIX FOR[ \\/\\.\\-\\:]+[A-Z0-9]{2}" + AirlineMessageParser.optmany("[ \\/\\.\\-\\:]+[A-Z0-9]{2}") + S + "SEGS UNTIL" + S + AirlineMessageParser.grab(DATE, AS_DATE) + S + AirlineMessageParser.grab(TIME, AS_TIME) + AirlineMessageParser.grab(TIMEZONE, AS_TIMEZONE) + S + "OR ALL THESE SEGS WILL BE CANX APPL FARE RULE APPLIES IF IT DEMANDS EARLIER TKTG" + ANYTHING));
        PS_ADTK.add(Pattern.compile("PLS REMEMBER TO ADTK BY[ \\/\\.\\-\\:]+" + AirlineMessageParser.grab(TIME, AS_TIME) + S + AirlineMessageParser.grab(DATE, AS_DATE) + S + "OR XX PNR" + ANYTHING));
        PS_ADTK.add(Pattern.compile("PLS TICKET BY[ \\/\\.\\-\\:]+" + AirlineMessageParser.grab(TIME, AS_TIME) + S + AirlineMessageParser.grab(DATE, AS_DATE) + S + AirlineMessageParser.grab(TIMEZONE, AS_TIMEZONE) + S + OR + S + AIRLINE + S + CANCEL + "\nTKNA/TKNM/FA PT/FH TKT ENTRY PROHIBITED FOR BSP/ARC/EDIRECT MRKT\nTICKETING DEADLINE IN FARE RULE MUST BE OBSERVED IF MORE RESTRICTIVE"));
        for (String msg : Arrays.asList("(?<immediate>RITK\\/IMMEDIATE TICKETING REQD\\.)", "(?<immediate>TICKET IMMEDIATELY OR RISK CANCELLATION)")) {
            PS_ADTK.add(Pattern.compile(msg));
        }
        PS_DUPE = new ArrayList<Pattern>();
        PS_DUPE.add(Pattern.compile(AirlineMessageParser.opt(".*[ \\/\\.\\-\\:]+") + AirlineMessageParser.or("DUPE?D?", "DUPLICATED?") + OS + AirlineMessageParser.opt("WITH") + AirlineMessageParser.opt("[ \\/\\.\\-\\:]+.*")));
        PS_IGNORE = new ArrayList<Pattern>();
        PS_IGNORE.add(Pattern.compile("NO SHOW"));
        PS_IGNORE.add(Pattern.compile("[A-Z0-9]{2}[ \\/\\.\\-\\:]+ISSUANCE TIME LIMIT WILL BE GIVEN LATER"));
        PS_IGNORE.add(Pattern.compile(PLEASE + S + ADVISE + S + "FQTV NUMBER IF AVAILABLE" + AirlineMessageParser.opt(" WITH SSR FORMAT")));
        PS_IGNORE.add(Pattern.compile(PLEASE + S + ADVISE + S + "PSGR MOBILE AND\\/OR EMAIL AS SSR CTCM\\/CTCE"));
        PS_IGNORE.add(Pattern.compile("DOCS INFO IS REQUIRED FOR [A-Z0-9]{2} FLT"));
        PS_IGNORE.add(Pattern.compile("PLS ADD CUSTOMER CONTACT DETAILS"));
        PS_IGNORE.add(Pattern.compile("AD PSGR  MOBILE NUMBER"));
        PS_IGNORE.add(Pattern.compile("DOCS INFO REQUIRED TO AVOID INCONVENIENCE AT THE APT"));
        PS_IGNORE.add(Pattern.compile("MOBILE NBR REQD IN SSR CTCM FIELD TO INFM SKED CHNG"));
        PS_IGNORE.add(Pattern.compile("EMAIL ID REQD IN SSR CTCE FIELD TO INFM SKED CHNG"));
        PS_IGNORE.add(Pattern.compile("MOBILE AND EMAIL CONTACT USING SSR REQUIRED X PLS PROVIDE"));
        PS_IGNORE.add(Pattern.compile(AirlineMessageParser.opt(HK + S) + DATE + FLTNO + " RLOC " + RLOC));
        PS_IGNORE.add(Pattern.compile("VUELING RECORD LOCATOR [A-Z0-9]{6}"));
        PS_IGNORE.add(Pattern.compile("[A-Z0-9]{2} CONFO NBR [A-Z0-9]{6}"));
        PS_IGNORE.add(Pattern.compile("[A-Z0-9]{2} RSVN IS [0-9\\-]+"));
        PS_IGNORE.add(Pattern.compile("ECONOMY CLS ASP AVBL WITHIN 361DAYS FOR TKTD PAX"));
        PS_IGNORE.add(Pattern.compile("PLEASE UPDATE TO SYNCHRONIZE PNR"));
        PS_IGNORE.add(Pattern.compile("PLS REISSUE/REVALIDATE TKTS WHEREVER APPLICABLE"));
        PS_IGNORE.add(Pattern.compile("CHECK SPECIAL MEAL AND ADVANCE SEATING"));
        PS_IGNORE.add(Pattern.compile("PLS ADVISE SSR DOCO ACCORDING EMIGRATION LAW"));
        PS_IGNORE.add(Pattern.compile("PLS ADV SSR DOCO OTHERWISE ADM WILL BE ISSUED"));
        PS_IGNORE.add(Pattern.compile("PLS ADVISE SSR DOCA WITH RESIDENCE ADDRESS"));
        PS_IGNORE.add(Pattern.compile("PLS ADVISE SSR DOCS ACCORDING EMIGRATION LAW"));
        PS_IGNORE.add(Pattern.compile("PLS NOTE VISA REQUIRED FOR TRANSIT BETWEEN[ \\/\\.\\-\\:]+[A-Z\u0410-\u042f]{3}[ \\/\\.\\-\\:]+AND[ \\/\\.\\-\\:]+[A-Z\u0410-\u042f]{3}"));
        PS_IGNORE.add(Pattern.compile("EFFECTIVE[ \\/\\.\\-\\:]+" + DATE + S + GEO + S + "RESIDENTS NEED TO OBTAIN E-VISABEFORE THEY TRAVEL TO" + S + GEO));
        PS_IGNORE.add(Pattern.compile("UMRAH PAX TO AND FROM JED WILL ARRIVE AND DEPART FROM HAJTERMINAL"));
        PS_IGNORE.add(Pattern.compile("API DATA MANDATORY FOR TRVL TO AND FROM RU PLS PROVIDESSR DOCS INFO FOR ALL PAX"));
        PS_IGNORE.add(Pattern.compile(AIRLINE + AirlineMessageParser.optmany("[ \\/\\.\\-\\:]+[A-Z0-9]{2}") + " RESERVE THE RIGHT TO AUTOCANCEL SEGMENTS OR SEND ADM IF NO TIX ISSUED"));
        PS_IGNORE.add(Pattern.compile("OR AA WILL CANCEL FARE RULES STILL APPLY"));
        PS_IGNORE.add(Pattern.compile("ROBOT AUTO PROCESS[ \\/\\.\\-\\:]+" + TIME + S + DATE + S + "RULE \\d+ SET" + S + DATE));
        PS_IGNORE.add(Pattern.compile("APPLICABLE FARE RULE APPLIES IF IT DEMANDS EARLIER TKTG [A-Z0-9]{2}"));
        PS_IGNORE.add(Pattern.compile(PLEASE + S + "PRVDE?" + S + AirlineMessageParser.opt("LCL CTC\\/") + AirlineMessageParser.or("ST\\/ML", "ML\\/ST") + "\\/FFP DTLS TO CHE?C?K" + S + "FI?RMNESS" + S + "RE?GA?R?D?S?" + S + "BOM121"));
        PS_IGNORE.add(Pattern.compile("ATTN AGT\\/AB APPLIES MOST RESTRICTIVE TTL"));
        PS_IGNORE.add(Pattern.compile("[A-Z0-9]{2}[ \\/\\.\\-\\:]+FLT[ \\/\\.\\-\\:]+\\d{1,4}[ \\/\\.\\-\\:]+OP BY[ \\/\\.\\-\\:]+[A-Z0-9]{2}[ \\/\\.\\-\\:]+CKIN WITH[ \\/\\.\\-\\:]+[A-Z0-9]{2}"));
        PS_IGNORE.add(Pattern.compile("HN\\d[ \\/\\.\\-\\:]+" + AirlineMessageParser.opt("[A-Z\u0410-\u042f]{3}[A-Z\u0410-\u042f]{3}") + FLTNO + BKGCLS + DATE + S + "[A-Z]+ [A-Z]+" + S + "FARE RULES APPLY" + ANYTHING));
        PS_IGNORE.add(Pattern.compile("REMINDER ISSUE TICKET BEFORE TTL EXPIRY OR PNR WILL BE CNLD"));
        PS_IGNORE.add(Pattern.compile("HK\\d IGNORE INVALID CONTACT[ \\/\\.\\-\\:]+.*"));
        PS_IGNORE.add(Pattern.compile(ANYTHING + AirlineMessageParser.opt(PLEASE + S) + ADVISE + S + AirlineMessageParser.or("PSGR MOBILE", "PAX CONTACTS", "PAX", "PAX EMAIL", "SSR DOCS", "DOCS INFO", "TKT NUMBER", "SSR CTCR") + S + ANYTHING));
        PS_IGNORE.add(Pattern.compile("MOBILE AND EMAIL CONTACT.*" + PLEASE + S + ADVISE));
        PS_IGNORE.add(Pattern.compile(".*CHURNED FROM"));
        PS_IGNORE.add(Pattern.compile(AirlineMessageParser.or("CTCR", "CTCE", "CTCM") + S + "NOT UPDATED" + S + ANYTHING + S + "EXIST"));
        PS_IGNORE.add(Pattern.compile(".*[ \\/\\.\\-\\:]+PAX INFO[ \\/\\.\\-\\:]+.*"));
        PS_IGNORE.add(Pattern.compile("PLEASE ADV CUSTOMER AND REFER EMIRATES.COM FOR"));
        PS_IGNORE.add(Pattern.compile("PRE SEATING FEES AND/OR FREE BAGGAGE ALLOWANCE"));
        PS_IGNORE.add(Pattern.compile(AirlineMessageParser.or("KK\\d", "HK\\d") + S + "MU" + OS + ANYTHING + S + GEO + GEO + ANYTHING));
        PS_IGNORE.add(Pattern.compile("AIRBALTIC ANCILLARIES - NOW AVAILABLE IN AMADEUS - PLEASE USE FXK TO DISPLAY CATALOGUE"));
        PS_IGNORE.add(Pattern.compile("PNR TRANSFERRED TO TK PLS FOLLOW UP BY TK"));
        PS_IGNORE.add(Pattern.compile("ITIN CONFIRMED - MUST PROVIDE PAYMENT"));
        PS_IGNORE.add(Pattern.compile(".*PFS APIPX[ \\/\\.\\-\\:]+.*"));
        PS_IGNORE.add(Pattern.compile(".*AIRLINE [A-Z0-9]{2} DISSOCIATED PNR [A-Z0-9]{6} FROM MUC1A TO MANUAL MODE"));
        PS_IGNORE.add(Pattern.compile(".*PLS REMOVE CANX SEG OR TVL AGNT MAY RECEIVE AGENCY DEBI"));
        PS_IGNORE.add(Pattern.compile(".* TOT COST .*"));
        PS_IGNORE.add(Pattern.compile(".* FARE .* PFC .* TTL .*"));
        PS_IGNORE.add(Pattern.compile(".* EARLIER TKTG"));
        PS_IGNORE.add(Pattern.compile(".* INPUT PAX CONTACT INFO .*"));
        PS_IGNORE.add(Pattern.compile("KK\\d .*[ \\/\\.\\-\\:]+OPERATED BY DP \\d+"));
        PS_IGNORE.add(Pattern.compile(".* CORRECT FORMAT TO OSI SPACE .*"));
        PS_IGNORE.add(Pattern.compile("AIRBALTIC ANCILLARIES AVAILABLE-SEE AGENCYESERVICES.SABRE.COM[ \\/\\.\\-\\:]+.*"));
        PS_IGNORE.add(Pattern.compile("PAX NE OTV[ \\/\\.\\-\\:]+.*"));
        PS_IGNORE.add(Pattern.compile("TERMS AND CONDITIONS ON WWW.TURKISHAIRLINES.COM.*"));
        PS_IGNORE.add(Pattern.compile("TERMS AND CONDITIONS ON WWW.TURKISHAIRLINES.COM*"));
        PS_IGNORE.add(Pattern.compile("1S ATT AGENT NEW TTL APPLICABLE DUE TO FLIGHT CRITICAL/BOMAY"));
        PS_SEGMENTS_CANCELED = new ArrayList<Pattern>();
        PS_SEGMENTS_CANCELED.add(Pattern.compile("PLS REMOVE[ \\/\\.\\-\\:]+[A-Z0-9]{2}[ \\/\\.\\-\\:]+HX SEGS[ \\/\\.\\-\\:]+" + AirlineMessageParser.grab(DATETIME, AS_DATETIME) + S + "TO AVOID" + AirlineMessageParser.opt(" ADM")));
        PS_SEGMENTS_CANCELED.add(Pattern.compile("TTL EXPIRED \\- AUTOCXLD BY [A-Z0-9]{2}"));
        PS_SEGMENTS_CANCELED.add(Pattern.compile("PLZ UPDATE ITIN BY XXL ALL HX SEGMENTS"));
        PS_SEGMENTS_CANCELED.add(Pattern.compile("HX[ \\/\\.\\-\\:]+CANCELL?ED DUE TO SYSTEM OR PASSENGER ACTION\\.?" + AirlineMessageParser.opt("\nHX[ \\/\\.\\-\\:]+" + AirlineMessageParser.or("DELETE", "CANCEL") + " HX" + AirlineMessageParser.opt(" SEGS") + " FROM PNR TO KEEP RES IN SYNCH\\.?" + AirlineMessageParser.optmany("\n.*"))));
        PS_SEGMENTS_CANCELED.add(Pattern.compile("PLS REMOVE HX\\/NO SEGMENTS OR TVL AGTS MAY RCV ADM\nCA BKG CXLD DUE TO TKT TIME EXPIRED"));
        PS_SEGMENTS_CANCELED.add(Pattern.compile("PLS REMOVE S7 HX SEGS 24 HOURS BEFORE DEPARTURE TO AVOID  ADM"));
        PS_SEGMENTS_CANCELED.add(Pattern.compile("PLS REMOVING HU HX SEGMENTS 24 HOURS BEFORE DEPARTURETO AVOID ADM PENALTY"));
        PS_SEGMENTS_CANCELED.add(Pattern.compile("SEGS CANX AS NO VALID TICKET"));
        PS_SEGMENTS_CANCELED.add(Pattern.compile("REV INT - SEGS CANX AS NO TICKET\nPLS REMOVE CANX SEG OR TVL AGT MAY RECEIVE ADM"));
        PS_SEGMENTS_CANCELED.add(Pattern.compile("[A-Z0-9]{2}\\d{1,4}[ \\/\\.\\-\\:]+[A-Z][ \\/\\.\\-\\:]+" + DATE + S + RLOC + S + "CANCELED DUE TO ATTL EXPIRED"));
        PS_SEGMENTS_CANCELED.add(Pattern.compile(AirlineMessageParser.opt("[A-Z0-9]{2}[ \\/\\.\\-\\:]+FLTS[ \\/\\.\\-\\:]+") + CANCEL + " DUE " + ANYTHING));
        PS_SEGMENTS_CANCELED.add(Pattern.compile("[A-Z0-9]{2} BKG " + CANCEL + " DUE ATTL EXPIRED WITHOUT TKNE"));
        PS_SEGMENTS_CANCELED.add(Pattern.compile("[A-Z0-9]{2} CANCELLATION DUE TO .*"));
        PS_SEGMENTS_CANCELED.add(Pattern.compile("CNLD DUE TO TIME LIMIT EXPIRED\nPLS CANCEL HX\\/NO\\/UC\\/UN AIR SEGMENTS TO AVOID ADM"));
        PS_SEGMENTS_CANCELED.add(Pattern.compile("KK\\d\\.UNTICKETED [A-Z0-9]{2} SEGMENTS CANCELLED"));
        PS_SEGMENTS_CANCELED.add(Pattern.compile("XX SEG DUE TO NO E-TKT NR\\. PLS CANCEL HX SEG IN YOUR SYS"));
        PS_SEGMENTS_CANCELED.add(Pattern.compile("[\u0410-\u042fA-Z]{2}\\d+[ \\/\\.\\-\\:]+" + AirlineMessageParser.opt("SERVICE[ \\/\\.\\-\\:]+") + "XLD DUE TO TIMELIMIT"));
        PS_SEGMENTS_CANCELED.add(Pattern.compile("[\u0410-\u042fA-Z]{2}\\d+[ \\/\\.\\-\\:]+[A-Z0-9]{2}\\d{1,4}[ \\/\\.\\-\\:]+[A-Z\u0410-\u042f]{3}[A-Z\u0410-\u042f]{3}[ \\/\\.\\-\\:]+" + DATE + S + "SEGMENT CANCEL"));
        PS_SEGMENTS_CANCELED_NO_SHOW = new ArrayList<Pattern>();
        PS_SEGMENTS_CANCELED_NO_SHOW.add(Pattern.compile(".*PFS NOSHO.*"));
        PS_SEGMENTS_CANCELED_NO_SHOW.add(Pattern.compile(".*CANCELED DUE TO SYSTEM OR PASSENGER ACTION"));
        PS_SEGMENTS_CANCELED_NO_SHOW.add(Pattern.compile("ETKT SUSPENDED BY LO DUE TO NOSHOW"));
        PS_SEGMENTS_CANCELED_NO_SHOW.add(Pattern.compile("NOSHOW ON[ \\/\\.\\-\\:]+[A-Z0-9]{2}[ \\/\\.\\-\\:]+\\d{1,4}[ \\/\\.\\-\\:]+" + DATE));
        PS_TKTL = new ArrayList<Pattern>();
        PS_TKTL.add(Pattern.compile("SS[ \\/\\.\\-\\:]+" + AirlineMessageParser.grab(TIMEZONE, AS_TIMEZONE) + S + AirlineMessageParser.grab(TIME, AS_TIME) + S + AirlineMessageParser.grab(DATE, AS_DATE) + AirlineMessageParser.opt("[ \\/\\.\\-\\:]+.*")));
        PS_SCHEDULE_CHANGE = new ArrayList<Pattern>();
        PS_SCHEDULE_CHANGE.add(Pattern.compile("HK\\d[ \\/\\.\\-\\:]+[A-Z\u0410-\u042f]{3}[A-Z\u0410-\u042f]{3}\\d{1,4}[A-Z]" + DATE + S + AIRLINE + OS + FLTNO + S + GEO + GEO + S + DATE + S + AirlineMessageParser.or("DELAY", "TIME CHANGE", "SEGMENT CANCEL")));
        PS_SCHEDULE_CHANGE.add(Pattern.compile("\\*FLT[ \\/\\.\\-\\:]+[A-Z0-9]{2}" + OS + FLTNO + S + DATE + S + TIME + S + "CHG TO" + S + DATE + S + TIME + S + "PLS ADV PAX"));
        PS_SCHEDULE_CHANGE.add(Pattern.compile(AirlineMessageParser.opt(AirlineMessageParser.opt("PAX[ \\/\\.\\-\\:]+") + "OTPRAVLENO SMS" + S + AirlineMessageParser.opt("OB?[ \\/\\.\\-\\:]+")) + "IZM(EN(EN(IE)?)?)?" + S + AirlineMessageParser.or("RASP(ISANI(Y|I)A)?", "VV" + AirlineMessageParser.opt("[ \\/\\.\\-\\:]+VP")) + S + ANYTHING));
        PS_MANUAL_HANDLING = new ArrayList<Pattern>();
        PS_MANUAL_HANDLING.add(Pattern.compile(HK + S + AIRLINE + FLTNO + ANYTHING + S + GEO + GEO + S + DATE + S + AirlineMessageParser.or("DELAY", "TIME CHANGE") + ANYTHING));
        PS_MANUAL_HANDLING.add(Pattern.compile(AirlineMessageParser.opt(HK + S) + "ISSUE ASAP"));
        PS_MANUAL_HANDLING.add(Pattern.compile(".*[ \\/\\.\\-\\:]+SEGS[ \\/\\.\\-\\:]+" + AirlineMessageParser.or("CANX", "CXL", "XX", "CXLD", "XLD", "XXLD", "CNLD", "CANCELED")));
        PS_MANUAL_HANDLING.add(Pattern.compile(AirlineMessageParser.optSpaces("API DATA MANDATORY FOR TRAVEL TO AND FROM RU PLS PROVIDE SSR DOCS INFO FOR ALL PAX")));
        PS_MANUAL_HANDLING.add(Pattern.compile(".*PLS ADV CORRECT PAX MOBILE PHONE.*"));
        PS_MANUAL_HANDLING.add(Pattern.compile(".*WITHIN FARE RULE TTL.*WILL AUTO XXL"));
        PS_AGENT_NOTIFICATION = new ArrayList<MiscUtil.Pair<Pattern, QueueWatchAgentNotificationType>>();
        PS_AGENT_NOTIFICATION.add((MiscUtil.Pair<Pattern, QueueWatchAgentNotificationType>)new MiscUtil.Pair((Object)Pattern.compile(AirlineMessageParser.grab(FLTNO, AS_FLTNO) + AirlineMessageParser.or("/", BKGCLS, "[A-Z]/") + "[0-3]?[0-9]" + MONTH_MMM + OS + AirlineMessageParser.grab(AirlineMessageParser.or("DEP", "ARR"), AS_DEPARTURE_ARRIVAL) + OS + AirlineMessageParser.grab(AirlineMessageParser.opt(GEO), AS_GEO) + OS + "TERM" + OS + AirlineMessageParser.grab("[A-Z0-9]{1}", AS_TERMINAL) + AirlineMessageParser.opt(" ISO") + OS + AirlineMessageParser.opt(GEO) + OS + AirlineMessageParser.opt("TERM") + OS + AirlineMessageParser.opt("[A-Z0-9]{1}")), (Object)QueueWatchAgentNotificationType.TERMINAL_CHANGE));
        PS_AGENT_NOTIFICATION.add((MiscUtil.Pair<Pattern, QueueWatchAgentNotificationType>)new MiscUtil.Pair((Object)Pattern.compile(AirlineMessageParser.grab(FLTNO, AS_FLTNO) + AirlineMessageParser.or("/", BKGCLS, "[A-Z]/") + "[0-3]?[0-9]" + MONTH_MMM + OS + AirlineMessageParser.grab(GEO, AS_GEO) + OS + "TERM" + OS + AirlineMessageParser.grab("[A-Z0-9]{1}", AS_TERMINAL) + AirlineMessageParser.opt(" ISO ") + AirlineMessageParser.opt(GEO) + OS + AirlineMessageParser.opt("TERM") + OS + AirlineMessageParser.opt("[A-Z0-9]{1}")), (Object)QueueWatchAgentNotificationType.TERMINAL_CHANGE));
        PS_AGENT_NOTIFICATION.add((MiscUtil.Pair<Pattern, QueueWatchAgentNotificationType>)new MiscUtil.Pair((Object)Pattern.compile(".*PLS VRFY IF PAX DEF TRVL.*AND UPDATE - OSI EK DFNT.*", 32), (Object)QueueWatchAgentNotificationType.EMIRATES_COVID19));
        PS_AGENT_NOTIFICATION.add((MiscUtil.Pair<Pattern, QueueWatchAgentNotificationType>)new MiscUtil.Pair((Object)Pattern.compile("RR RQST ON AZ (FLT|ITN) BY " + DATE + S + TIME + OS + "UTC OR (ITN|FLT) WILL BE CNLD"), (Object)QueueWatchAgentNotificationType.ALITALIA_COVID19));
    }

    public static interface DateTimeParser {
        public Date parse(String var1, Reservation var2);
    }

    public static interface TimeZoneParser {
        public ZoneId parse(String var1, Reservation var2);
    }

    public static interface TimeParser {
        public LocalTime parse(String var1);
    }

    public static interface DateParser {
        public LocalDate parse(String var1);
    }
}

