/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus.queue;

import com.gridnine.xtrip.common.gds.model.AgentNotificationEvent;
import com.gridnine.xtrip.common.gds.model.AirlineMessage;
import com.gridnine.xtrip.common.gds.model.BaseQueueWatchEvent;
import com.gridnine.xtrip.common.gds.model.QueueWatchAgentNotificationType;
import com.gridnine.xtrip.common.gds.model.QueueWatchEventType;
import com.gridnine.xtrip.common.gds.model.QueueWatchTerminalChangeAgentNotificationData;
import com.gridnine.xtrip.common.gds.model.SegmentsCancelledEvent;
import com.gridnine.xtrip.common.gds.model.SegmentsCancelledEventReason;
import com.gridnine.xtrip.common.gds.model.ServiceStatusChangeEvent;
import com.gridnine.xtrip.common.gds.model.TicketTimelimitChangeEvent;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.profile.Pcc;
import com.gridnine.xtrip.common.model.profile.PccParameter;
import com.gridnine.xtrip.common.model.profile.PccParameterName;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.gds.ibus.queue.AirlineMessageParser;
import com.gridnine.xtrip.server.model.test.ModelTestBase;
import com.gridnine.xtrip.server.storage.DictionaryStorage;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.junit.Assert;
import org.junit.Test;

public class AirlineMessageParserTest
extends ModelTestBase {
    @Test
    public void testServiceStatusChange() throws Exception {
        HashMap<String, MiscUtil.Pair> airlineMessages = new HashMap<String, MiscUtil.Pair>();
        airlineMessages.put("KK1 AERDME0278A26JAN/PREPAID", new MiscUtil.Pair((Object)"ABAG", (Object)"KK"));
        airlineMessages.put("KK1 C/0CU//NO BAGGAGE/N4 293 P 01JUN SVOKJA/USACHEVA/ANASTASIIA(ADT)", new MiscUtil.Pair((Object)"ASVC", (Object)"KK"));
        airlineMessages.put("KK1/EK 132 B 05JAN DMEDXB/ANTIPOVA/MILANA(CHD/29AUG11)(ID4)", new MiscUtil.Pair((Object)"CHML", (Object)"KK"));
        airlineMessages.put("HN1 5KG CARRIER 30X20X20 1P CAT/SU6441 N 11DEC LEDSGC", new MiscUtil.Pair((Object)"PETC", (Object)"HN"));
        airlineMessages.put("XBAG PC KK1 SAWDME 0386V25JUN.10", new MiscUtil.Pair((Object)"OTHS", (Object)"KK"));
        airlineMessages.put("4KK1 C/0CU//NO BAGGAGE/N4 563 X 23JUL SVOOSW/PARAMONOV/IGOR ALEKSANDROVICH(ADT)", new MiscUtil.Pair((Object)"ASVC", (Object)"KK"));
        airlineMessages.put("KKK1/EK 652 K 30APR DXBMLE/BEIRIT/ANASTASIIA(CHD/23JUN09)(ID4)", new MiscUtil.Pair((Object)"CHML", (Object)"KK"));
        airlineMessages.put("KKK1/EK 132 B 05JAN DMEDXB/ANTIPOVA/MILANA(CHD/29AUG11)(ID4)", new MiscUtil.Pair((Object)"CHML", (Object)"KK"));
        airlineMessages.put("4KK1 C/0CU//NO BAGGAGE/N4 293 P 01JUN SVOKJA/USACHEVA/ANASTASIIA(ADT)", new MiscUtil.Pair((Object)"ASVC", (Object)"KK"));
        airlineMessages.put("4KK1 C/0E9//BAGGAGE 1PC UT TO 20KG/N4 232 F 09JUN NUXSVO/ODINAEV/NEMATULLO(ADT)", new MiscUtil.Pair((Object)"ASVC", (Object)"KK"));
        airlineMessages.put("XBAG PC KK1 SAWSSH 0628G23JAN 1KOMOLOV/SERGEI.8", new MiscUtil.Pair((Object)"OTHS", (Object)"KK"));
        airlineMessages.put("UHN1 5KG KENNEL 43X27X26 1P DOG YORKSHIRE TERRIER/SU1730 B 24OCT SVOPKC", new MiscUtil.Pair((Object)"PETC", (Object)"HN"));
        airlineMessages.put("HK1 TLVDME0613K05DEC", new MiscUtil.Pair((Object)"XBAF", (Object)"HK"));
        airlineMessages.put("HK1 DUSATH0841T07DEC", new MiscUtil.Pair((Object)"XBGS", (Object)"HK"));
        airlineMessages.put("HK1 MLEBOM0272D07DEC/TTL13KG0PC", new MiscUtil.Pair((Object)"EBAG", (Object)"HK"));
        airlineMessages.put("KK1 GDNFRA1377H17DEC.ADDITIONAL BAG UP TO 50LB 23KG 62LI 158CM", new MiscUtil.Pair((Object)"MBAG", (Object)"KK"));
        for (Map.Entry entry : airlineMessages.entrySet()) {
            AirlineMessage message = new AirlineMessage();
            message.setMessage((String)entry.getKey());
            message.setType((String)((MiscUtil.Pair)entry.getValue()).getFirst());
            List<BaseQueueWatchEvent> result = AirlineMessageParser.parse(message, null);
            Assert.assertEquals((long)1L, (long)result.size());
            ServiceStatusChangeEvent event = (ServiceStatusChangeEvent)result.get(0);
            Assert.assertEquals((Object)event.getStatus(), (Object)((MiscUtil.Pair)entry.getValue()).getSecond());
        }
    }

    @Test
    public void testFoo() throws Exception {
        AirlineMessage message = new AirlineMessage();
        message.setType("ADTK");
        message.setMessage("UT-0334/12JUL16 BY 13JUN/0720Z OR CNL\nUT-0579/12JUL16 BY 13JUN/0720Z OR CNL");
        List<BaseQueueWatchEvent> result = AirlineMessageParser.parse(message, null);
        Assert.assertEquals((long)2L, (long)result.size());
    }

    @Test
    public void testNullMessage() throws Exception {
        List<BaseQueueWatchEvent> result = AirlineMessageParser.parse(null, null);
        Assert.assertEquals((long)0L, (long)result.size());
    }

    @Test
    public void testIgnore() throws Exception {
        List<String> messageText = Arrays.asList("TERMS AND CONDITIONS ON WWW.TURKISHAIRLINES.COM/EN-INT/BAGGAGE", "1S ATT AGENT NEW TTL APPLICABLE DUE TO FLIGHT CRITICAL/BOMAY");
        for (String text : messageText) {
            AirlineMessage message = new AirlineMessage();
            message.setType("OTHS");
            message.setMessage(text);
            List<BaseQueueWatchEvent> result = AirlineMessageParser.parse(message, null);
            Assert.assertEquals((long)1L, (long)result.size());
            Assert.assertEquals((Object)result.get(0).getType(), (Object)QueueWatchEventType.IGNORE);
        }
    }

    @Test
    public void testADTK() throws Exception {
        AirlineMessage message = new AirlineMessage();
        message.setType("ADTK");
        message.setMessage("5N-0115/26JAN17 BY 19JAN/1256Z OR CNL");
        List<BaseQueueWatchEvent> result = AirlineMessageParser.parse(message, null);
        Assert.assertEquals((long)1L, (long)result.size());
        TicketTimelimitChangeEvent event = (TicketTimelimitChangeEvent)result.get(0);
    }

    private static void fillTimezone(String locationCode, String zoneId) throws Exception {
        GeoLocation loc = DictHelper.findGeoLocationByCodeVariant((String)locationCode);
        if (loc == null) {
            loc = new GeoLocation();
            loc.setCode(locationCode);
            loc.getCodeVariants().put("IATA", locationCode);
            DictionaryStorage.get().save((BaseDictionary)loc);
        }
        loc.setTimeZoneId(zoneId);
    }

    @Test
    public void testRealData() throws Exception {
        int ttl = 0;
        int err = 0;
        int exc = 0;
        HashMap<QueueWatchEventType, Integer> stats = new HashMap<QueueWatchEventType, Integer>();
        try (InputStreamReader isr = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("AirlineMessageParserTest-data.txt"));
             BufferedReader br = new BufferedReader(isr);
             FileOutputStream fos = new FileOutputStream("/tmp/queue-errors.dat");){
            String line;
            EntityReference<SalesPoint> spRef = this.createSalesPoint();
            while ((line = br.readLine()) != null) {
                if ((line = line.trim().replace("\u044a", "\n")).startsWith("#")) {
                    ++exc;
                    continue;
                }
                AirlineMessage message = new AirlineMessage();
                message.setType(line.substring(0, 4));
                message.setMessage(line.substring(8).trim());
                Reservation res = new Reservation();
                Product prod = new Product();
                prod.setProductCategory(ProductCategory.AIR);
                SegmentTariff st = new SegmentTariff();
                prod.getSegmentTariffs().add(st);
                Segment s = new Segment();
                s.setDepartureLocation((DictionaryReference)DictHelper.findGeoLocationByCodeVariant((String)"SVO").toReference());
                s.setStartDate(new Date());
                st.getSegments().add(s);
                res.getProducts().add(prod);
                CommonReservationGdsNameInfoHelper.setBookingPcc((Reservation)res, (GdsName)GdsName.AMADEUS, (String)"MOWR221QV");
                res.setSalesPoint(spRef);
                List<BaseQueueWatchEvent> result = null;
                try {
                    result = AirlineMessageParser.parse(message, res);
                }
                catch (NullPointerException ex) {
                    if (ex.getMessage() != null) {
                        if (ex.getMessage().startsWith("no timezone for ")) {
                            AirlineMessageParserTest.fillTimezone(ex.getMessage().substring("no timezone for ".length()), "Europe/Moscow");
                            result = AirlineMessageParser.parse(message, res);
                        }
                        if (ex.getMessage().startsWith("location not found for ")) {
                            AirlineMessageParserTest.fillTimezone(ex.getMessage().substring("location not found for ".length()), "Europe/Moscow");
                            result = AirlineMessageParser.parse(message, res);
                        }
                        System.out.println(message.getMessage());
                        throw ex;
                    }
                    System.out.println(message.getMessage());
                    throw ex;
                }
                catch (Xeption xe) {
                    if (xe.getMessage() == null || !xe.getMessage().startsWith("developer: couldn't determine timelimit: ")) {
                        System.out.println(message.getMessage());
                        throw xe;
                    }
                }
                catch (Exception ex) {
                    System.out.println(message.getMessage());
                    throw ex;
                }
                if (result != null) {
                    for (BaseQueueWatchEvent event : result) {
                        if (!stats.containsKey(event.getType())) {
                            stats.put(event.getType(), 0);
                        }
                        stats.put(event.getType(), (Integer)stats.get(event.getType()) + 1);
                    }
                } else {
                    fos.write(line.replace("\n", "\u044a").getBytes());
                    fos.write("\n".getBytes());
                    ++err;
                }
                ++ttl;
            }
        }
        Thread.sleep(1000L);
        System.out.println(stats);
        System.out.println(ttl);
        System.out.println(err);
        System.out.println((ttl - err) * 100 / ttl);
        System.out.println(exc);
        Thread.sleep(1000L);
    }

    @Test
    public void testVip46661() throws Exception {
        AirlineMessageParserTest.fillTimezone("MOW", "Europe/Moscow");
        try (InputStreamReader isr = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("AirlineMessageParserTest-vip46661.txt"));
             BufferedReader br = new BufferedReader(isr);){
            String line;
            while ((line = br.readLine()) != null) {
                if ((line = line.trim().replace("\u044a", "\n")).startsWith("#")) continue;
                AirlineMessage message = new AirlineMessage();
                message.setType(line.substring(0, 4));
                message.setMessage(line.substring(8).trim());
                List<BaseQueueWatchEvent> result = AirlineMessageParser.parse(message, null);
                if (result != null) continue;
                throw Xeption.forDeveloper((String)("unsupported: " + line), (Object[])new Object[0]);
            }
        }
    }

    @Test
    public void testPrint() throws Exception {
        for (Pattern pattern : AirlineMessageParser.PS_ADTK) {
            System.out.println(pattern);
        }
    }

    @Test
    public void testOPW() throws Exception {
        AirlineMessageParserTest.fillTimezone("MOW", "Europe/Moscow");
        Reservation res = new Reservation();
        Product prod = new Product();
        SegmentTariff st = new SegmentTariff();
        prod.getSegmentTariffs().add(st);
        Segment s = new Segment();
        s.setDepartureLocation((DictionaryReference)DictHelper.findGeoLocationByCodeVariant((String)"SVO").toReference());
        s.setStartDate(new Date());
        st.getSegments().add(s);
        res.getProducts().add(prod);
        EntityReference<SalesPoint> spRef = this.createSalesPoint();
        CommonReservationGdsNameInfoHelper.setBookingPcc((Reservation)res, (GdsName)GdsName.AMADEUS, (String)"MOWR221QV");
        res.setSalesPoint(spRef);
        for (String s2 : new String[]{"AF REQUIRES TICKET ON OR BEFORE 09AUG:1600/S2", "AF REQUIRES TICKET ON OR BEFORE 02DEC/S2-5", "OK REQUIRES TICKET ON OR BEFORE 12SEP:2300 MOW TIME ZONE/TKT/S2", "AF REQUIRES TICKET ON OR BEFORE 12SEP:1000/S2", "/U6 REQUIRES DOCUMENT ON OR BEFORE 23JUN:2000", "/U6 REQUIRES DOCUMENT ON OR BEFORE 22SEP:2118", "/U6 REQUIRES DOCUMENT ON OR BEFORE 23NOV:0019"}) {
            AirlineMessage am = new AirlineMessage();
            am.setMessage(s2);
            am.setType("OPW");
            List<BaseQueueWatchEvent> events = AirlineMessageParser.parse(am, res);
            Assert.assertEquals((long)1L, (long)events.size());
            Assert.assertEquals((Object)QueueWatchEventType.TICKET_TIMELIMIT_CHANGE, (Object)events.get(0).getType());
        }
    }

    @Test
    public void testOPC() throws Exception {
        AirlineMessageParserTest.fillTimezone("MOW", "Europe/Moscow");
        Reservation res = new Reservation();
        EntityReference<SalesPoint> spRef = this.createSalesPoint();
        CommonReservationGdsNameInfoHelper.setBookingPcc((Reservation)res, (GdsName)GdsName.AMADEUS, (String)"MOWR221QV");
        res.setSalesPoint(spRef);
        for (String s : new String[]{"03DEC/1C8/AF CANCELLATION DUE TO NO TICKET/S2-5", "09AUG:1600/1C8/AF CANCELLATION DUE TO NO TICKET/S2", "12SEP:2300/1C8/OK CANCELLATION DUE TO NO TICKET MOW TIME ZONE/TKT/S2", "02FEB:0210/1C16/LO CANCELLATION DUE TO NO DOCUMENT"}) {
            AirlineMessage am = new AirlineMessage();
            am.setMessage(s);
            am.setType("OPC");
            am.setDate(LocalDateTime.now());
            List<BaseQueueWatchEvent> events = AirlineMessageParser.parse(am, res);
            Assert.assertEquals((long)1L, (long)events.size());
            Assert.assertEquals((Object)QueueWatchEventType.TICKET_TIMELIMIT_CHANGE, (Object)events.get(0).getType());
        }
    }

    @Test
    public void testManualHandling() {
        Reservation res = new Reservation();
        for (String s : new String[]{"\u041d\u041a1   N4524 SIPSVO 170919 DELAY 17\u0421\u0415\u041d19 08:30:50", "\u041d\u041a1   N4167 SVOLED 061019 TIME CHANGE 19\u0421\u0415\u041d19 16:26:16", "\u041d\u041a1   WZ310 SIPDME 011119 TIME CHANGE", "\u041d\u041a0   ISSUE ASAP", "UNABLE TO CONFIRM - SEGS CANX", "ISSUE ASAP", "API DATA MANDATORY FOR TRAVEL TO AND FROM  RU PLS PROVIDESSR DOCS INFO FOR ALL PAX", "\u041d\u041a1   HZ2654 \u0421\u041a\u0420PKC 231122 TIME CHANGE", "\u041d\u041a1   HZ3633P OHHUUS 140323 DELAY"}) {
            AirlineMessage am = new AirlineMessage();
            am.setMessage(s);
            am.setType("OTHS");
            am.setDate(LocalDateTime.now());
            List<BaseQueueWatchEvent> events = AirlineMessageParser.parse(am, res);
            Assert.assertEquals((long)1L, (long)events.size());
            Assert.assertEquals((Object)QueueWatchEventType.MANUAL_HANDLING, (Object)events.get(0).getType());
        }
    }

    @Test
    public void testNoShowSegmentsCancel() {
        Reservation res = new Reservation();
        for (String s : new String[]{"HX CANCELED DUE TO SYSTEM OR PASSENGER ACTION", "ETKT SUSPENDED BY LO DUE TO NOSHOW", "NOSHOW ON LO 233/12DEC19"}) {
            AirlineMessage am = new AirlineMessage();
            am.setMessage(s);
            am.setType("OTHS");
            am.setDate(LocalDateTime.now());
            List<BaseQueueWatchEvent> events = AirlineMessageParser.parse(am, res);
            Assert.assertEquals((long)1L, (long)events.size());
            Assert.assertEquals((Object)QueueWatchEventType.SEGMENTS_CANCELED, (Object)events.get(0).getType());
            SegmentsCancelledEvent event = (SegmentsCancelledEvent)events.get(0);
            Assert.assertEquals((Object)SegmentsCancelledEventReason.NO_SHOW, (Object)event.getReason());
        }
    }

    @Test
    public void testTimeLimitSegmentsCancel() {
        Reservation res = new Reservation();
        for (String s : new String[]{"\u041d\u041a1   SERVICE XLD DUE TO TIMELIMIT", "\u041d\u041a1 SU1958 SVOGUW 200423 SEGMENT CANCEL"}) {
            AirlineMessage am = new AirlineMessage();
            am.setMessage(s);
            am.setType("\u041f\u0420\u041e\u0427");
            am.setDate(LocalDateTime.now());
            List<BaseQueueWatchEvent> events = AirlineMessageParser.parse(am, res);
            Assert.assertEquals((long)1L, (long)events.size());
            Assert.assertEquals((Object)QueueWatchEventType.SEGMENTS_CANCELED, (Object)events.get(0).getType());
        }
    }

    private EntityReference<SalesPoint> createSalesPoint() {
        SalesPoint sp = new SalesPoint();
        Pcc pcc = new Pcc();
        pcc.setCode("MOWR221QV");
        pcc.setGdsName(GdsName.AMADEUS);
        PccParameter param = new PccParameter();
        param.setName(PccParameterName.SABRE_TIME_ZONE);
        param.setValue("Europe/Moscow");
        pcc.getParameters().add(param);
        sp.getPccs().add(pcc);
        EntityContainer spCtr = EntityContainer.create((BaseEntity)sp);
        EntityStorage.get().save(spCtr, false);
        return spCtr.toReference();
    }

    @Test
    public void testTerminalChangeAgentNotifications() {
        Reservation reservation = new Reservation();
        Segment segment = new Segment();
        segment.setFlightNo("2606");
        segment.setDepartureLocation((DictionaryReference)DictHelper.findAirportByCodeVariant((String)"SVO").toReference());
        segment.setArriveLocation((DictionaryReference)DictHelper.findAirportByCodeVariant((String)"LED").toReference());
        SegmentTariff st = new SegmentTariff();
        st.getSegments().add(segment);
        Product product = new Product();
        product.setProductCategory(ProductCategory.AIR);
        product.getSegmentTariffs().add(st);
        reservation.getProducts().add(product);
        HashMap<String, QueueWatchTerminalChangeAgentNotificationData> data = new HashMap<String, QueueWatchTerminalChangeAgentNotificationData>();
        QueueWatchTerminalChangeAgentNotificationData expectedNotificationData = new QueueWatchTerminalChangeAgentNotificationData();
        expectedNotificationData.setFlightNumber("2606");
        expectedNotificationData.setAirport((DictionaryReference)DictHelper.findAirportByCodeVariant((String)"SVO").toReference());
        expectedNotificationData.setTerminal("E");
        expectedNotificationData.setIsDepartureAirport(Boolean.TRUE);
        for (String message : new String[]{"2606/16MARDEP SVO TERM E", "2606/16MARDEP TERM E", "2606/16MARSVO TERM E", "2606/27JUL DEP SVOTERM E", "2606/06JULDEP TERME", "2606/6JUL DEP SVO TERM E", "2606B/6JUL DEP SVO TERM E", "2606/04AUGDEP SVO TERM E ISO D", "2606/04AUGDEP SVO TERM E ISO TERM D", "2606/04AUGDEP SVO TERM E ISO SVO TERM D"}) {
            data.put(message, expectedNotificationData);
        }
        String message = "2606/01AUGDEP SVO TERM 2";
        expectedNotificationData = new QueueWatchTerminalChangeAgentNotificationData();
        expectedNotificationData.setFlightNumber("2606");
        expectedNotificationData.setAirport((DictionaryReference)DictHelper.findAirportByCodeVariant((String)"SVO").toReference());
        expectedNotificationData.setTerminal("2");
        expectedNotificationData.setIsDepartureAirport(Boolean.TRUE);
        data.put(message, expectedNotificationData);
        for (Map.Entry dataEntry : data.entrySet()) {
            AirlineMessage am = new AirlineMessage();
            am.setType("OTHS");
            am.setMessage((String)dataEntry.getKey());
            am.setDate(LocalDateTime.now());
            List<BaseQueueWatchEvent> events = AirlineMessageParser.parse(am, reservation);
            Assert.assertEquals((long)1L, (long)events.size());
            Assert.assertEquals((Object)QueueWatchEventType.AGENT_NOTIFICATION, (Object)events.get(0).getType());
            AgentNotificationEvent event = (AgentNotificationEvent)events.get(0);
            QueueWatchTerminalChangeAgentNotificationData notificationData = (QueueWatchTerminalChangeAgentNotificationData)event.getNotificationData();
            expectedNotificationData = (QueueWatchTerminalChangeAgentNotificationData)dataEntry.getValue();
            Assert.assertEquals((Object)expectedNotificationData.getFlightNumber(), (Object)notificationData.getFlightNumber());
            Assert.assertEquals((Object)expectedNotificationData.getAirport(), (Object)notificationData.getAirport());
            Assert.assertEquals((Object)expectedNotificationData.getTerminal(), (Object)notificationData.getTerminal());
            Assert.assertEquals((Object)expectedNotificationData.getIsDepartureAirport(), (Object)notificationData.getIsDepartureAirport());
        }
    }

    @Test
    public void testEmiratesCovid19AgentNotifications() {
        Reservation reservation = new Reservation();
        AirlineMessage am = new AirlineMessage();
        am.setType("OTHS");
        am.setMessage("RRRI/ PLS VRFY IF PAX DEF TRVL BY 26JUL 1805 MO\nRRRI/ W AND UPDATE - OSI EK DFNT ELSE BKG WILL B\nRRRI/ E XXLD");
        am.setDate(LocalDateTime.now());
        List<BaseQueueWatchEvent> events = AirlineMessageParser.parse(am, reservation);
        Assert.assertEquals((long)1L, (long)events.size());
        Assert.assertEquals((Object)QueueWatchEventType.AGENT_NOTIFICATION, (Object)events.get(0).getType());
        AgentNotificationEvent event = (AgentNotificationEvent)events.get(0);
        Assert.assertEquals((Object)QueueWatchAgentNotificationType.EMIRATES_COVID19, (Object)event.getNotificationData().getNotificationType());
    }

    @Test
    public void testAlitaliaCovid19AgentNotifications() {
        Reservation reservation = new Reservation();
        AirlineMessage am = new AirlineMessage();
        am.setType("OTHS");
        am.setMessage("RR RQST ON AZ FLT BY 17JUN 2359UTC OR ITN WILL BE CNLD");
        am.setDate(LocalDateTime.now());
        List<BaseQueueWatchEvent> events = AirlineMessageParser.parse(am, reservation);
        Assert.assertEquals((long)1L, (long)events.size());
        Assert.assertEquals((Object)QueueWatchEventType.AGENT_NOTIFICATION, (Object)events.get(0).getType());
        AgentNotificationEvent event = (AgentNotificationEvent)events.get(0);
        Assert.assertEquals((Object)QueueWatchAgentNotificationType.ALITALIA_COVID19, (Object)event.getNotificationData().getNotificationType());
    }

    @Test
    public void testTimeLimitChange() {
        AirlineMessage message = new AirlineMessage();
        Reservation reservation = new Reservation();
        Date resDate = new Date();
        reservation.setResDate(resDate);
        message.setType("OTHS");
        message.setMessage("ATTN TKT MUST BE COMLETED WITHIN ONE HOUR AFTER RES");
        List<BaseQueueWatchEvent> result = AirlineMessageParser.parse(message, reservation);
        Assert.assertEquals((long)1L, (long)result.size());
        TicketTimelimitChangeEvent event = (TicketTimelimitChangeEvent)result.get(0);
        Assert.assertEquals((Object)event.getNewTimelimit(), (Object)new Date(resDate.getTime() + 3600000L));
    }

    @Test
    public void testTimeLimitChange2() {
        AirlineMessage message = new AirlineMessage();
        Reservation reservation = new Reservation();
        Date resDate = new Date();
        reservation.setResDate(resDate);
        message.setType("OTHS");
        message.setMessage("ADVISE TKTS WITHIN 48 HRS OR PNR WILL BE CNLD");
        List<BaseQueueWatchEvent> result = AirlineMessageParser.parse(message, reservation);
        Assert.assertEquals((long)1L, (long)result.size());
        TicketTimelimitChangeEvent event = (TicketTimelimitChangeEvent)result.get(0);
        Assert.assertEquals((Object)event.getNewTimelimit(), (Object)new Date(resDate.getTime() + 172800000L));
    }
}

