/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus.queue;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.AgentTouchEvent;
import com.gridnine.xtrip.common.gds.model.AirlineMessage;
import com.gridnine.xtrip.common.gds.model.BaseQueueWatchEvent;
import com.gridnine.xtrip.common.gds.model.BaseQueueWatchSettings;
import com.gridnine.xtrip.common.gds.model.DupeWarningEvent;
import com.gridnine.xtrip.common.gds.model.IgnoreEvent;
import com.gridnine.xtrip.common.gds.model.QueueWatchEventType;
import com.gridnine.xtrip.common.gds.model.ScheduleChangeEvent;
import com.gridnine.xtrip.common.gds.model.SegmentsCancelledEvent;
import com.gridnine.xtrip.common.gds.model.ServiceStatusChangeEvent;
import com.gridnine.xtrip.common.gds.model.TicketTimelimitChangeEvent;
import com.gridnine.xtrip.common.gds.model.TicketingEvent;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.server.gds.ibus.queue.AirlineMessageParseException;
import com.gridnine.xtrip.server.gds.ibus.queue.AirlineMessageParser;
import com.gridnine.xtrip.server.gds.ibus.queue.IBusGdsQueueContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class BuildQueueWatchEventsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        BaseQueueWatchSettings settings = (BaseQueueWatchSettings)ctx.getMandatoryObject((Enum)IBusGdsQueueContextKeys.QUEUE_WATCH_SETTINGS);
        ArrayList<Object> events = new ArrayList<Object>();
        switch (settings.getEventType()) {
            case SCHEDULE_CHANGE: {
                ScheduleChangeEvent event = new ScheduleChangeEvent();
                events.add(event);
                break;
            }
            case DUPE_WARNING: {
                Boolean dupeFalsePositive = (Boolean)ctx.getObject((Enum)IBusGdsQueueContextKeys.DUPE_FALSE_POSITIVE);
                if (dupeFalsePositive != null && dupeFalsePositive.booleanValue()) {
                    events.add(new IgnoreEvent());
                    break;
                }
                events.add(new DupeWarningEvent());
                break;
            }
            case TEXT_ANALYSIS_REQUIRED: {
                Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
                List airlineMessages = (List)ctx.getMandatoryObject((Enum)IBusGdsQueueContextKeys.AIRLINE_MESSAGES);
                Map handledEvents = (Map)ctx.getMandatoryObject((Enum)IBusGdsQueueContextKeys.QUEUE_WATCH_HANDLED_EVENTS);
                ArrayList<BaseQueueWatchEvent> parsedEvents = new ArrayList<BaseQueueWatchEvent>();
                for (AirlineMessage airlineMessage : airlineMessages) {
                    List<BaseQueueWatchEvent> result = AirlineMessageParser.parse(airlineMessage, reservation);
                    if (result == null) {
                        throw new AirlineMessageParseException("unable to parse airline message: type='{0}', message='{1}', pnr='{2}'", airlineMessage.getType(), airlineMessage.getMessage(), CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)reservation));
                    }
                    parsedEvents.addAll(result);
                }
                Iterator iter = parsedEvents.iterator();
                while (iter.hasNext()) {
                    BaseQueueWatchEvent event = (BaseQueueWatchEvent)iter.next();
                    LocalDateTime lastHandleDate = (LocalDateTime)handledEvents.get(event.getType());
                    if (lastHandleDate == null || !event.getDateTime().isBefore(lastHandleDate)) continue;
                    iter.remove();
                }
                Map<QueueWatchEventType, List<BaseQueueWatchEvent>> parsedEventsByType = parsedEvents.stream().collect(Collectors.groupingBy(BaseQueueWatchEvent::getType));
                block16: for (Map.Entry<QueueWatchEventType, List<BaseQueueWatchEvent>> entry : parsedEventsByType.entrySet()) {
                    if (entry.getValue().size() <= 1) continue;
                    switch (entry.getKey()) {
                        case DUPE_WARNING: 
                        case SCHEDULE_CHANGE: 
                        case TICKET_TIMELIMIT_CHANGE: 
                        case IGNORE: 
                        case SEGMENTS_CANCELED: 
                        case EMD_TIMELIMIT_CHANGE: 
                        case MANUAL_HANDLING: {
                            entry.getValue().sort(Comparator.comparing(BaseQueueWatchEvent::getDateTime).reversed());
                            parsedEvents.removeAll(entry.getValue().subList(1, entry.getValue().size()));
                            continue block16;
                        }
                        case SERVICE_STATUS_CHANGE: 
                        case AGENT_NOTIFICATION: {
                            continue block16;
                        }
                    }
                    throw Xeption.forDeveloper((String)("unexpected event type " + entry.getKey()), (Object[])new Object[0]);
                }
                events.addAll(parsedEvents);
                break;
            }
            case SEGMENTS_CANCELED: {
                SegmentsCancelledEvent event = new SegmentsCancelledEvent();
                events.add(event);
                break;
            }
            case AGENT_TOUCH: {
                AgentTouchEvent event = new AgentTouchEvent();
                events.add(event);
                break;
            }
            case TICKETING: {
                TicketingEvent event = new TicketingEvent();
                events.add(event);
                break;
            }
            case TICKET_TIMELIMIT_CHANGE: {
                TicketTimelimitChangeEvent event = new TicketTimelimitChangeEvent();
                events.add(event);
                break;
            }
            case SERVICE_STATUS_CHANGE: {
                ServiceStatusChangeEvent event = new ServiceStatusChangeEvent();
                events.add(event);
                break;
            }
            default: {
                throw Xeption.forDeveloper((String)"unexpected event type {0}", (Object[])new Object[]{settings.getEventType()});
            }
        }
        ctx.putObject((Enum)IBusGdsQueueContextKeys.QUEUE_WATCH_EVENTS, events);
    }
}

