/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus.queue;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.AirlineMessage;
import com.gridnine.xtrip.common.gds.model.BaseQueueWatchSettings;
import com.gridnine.xtrip.common.gds.model.QueueWatchEventType;
import com.gridnine.xtrip.common.gds.model.TicketTimelimitChangeEvent;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.server.gds.ibus.queue.BuildQueueWatchEventsProcessor;
import com.gridnine.xtrip.server.gds.ibus.queue.IBusGdsQueueContextKeys;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.test.ModelTestBase;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class BuildQueueWatchEventsProcessorTest
extends ModelTestBase {
    @Test
    public void test() throws Exception {
        MessageContext ctx = new MessageContext();
        FakeQueueWatchSettings settings = new FakeQueueWatchSettings();
        settings.setEventType(QueueWatchEventType.TEXT_ANALYSIS_REQUIRED);
        ctx.putObject((Enum)IBusGdsQueueContextKeys.QUEUE_WATCH_SETTINGS, (Object)settings);
        ArrayList<AirlineMessage> msgs = new ArrayList<AirlineMessage>();
        AirlineMessage msg = new AirlineMessage();
        msg.setType("ADTK");
        msg.setMessage("KK1 1A TO N4 BY 10OCT 1205Z OTHERWISE WILL BE XLD");
        msg.setDate(LocalDateTime.now());
        msgs.add(msg);
        msg = new AirlineMessage();
        msg.setType("ADTK");
        msg.setMessage("TO N4 BY 10OCT 1206Z OTHERWISE WILL BE CANCELLED");
        msg.setDate(LocalDateTime.now().plusHours(1L));
        msgs.add(msg);
        msg = null;
        msgs.add(msg);
        ctx.putObject((Enum)IBusGdsQueueContextKeys.AIRLINE_MESSAGES, msgs);
        ctx.putObject((Enum)IBusGdsQueueContextKeys.QUEUE_WATCH_HANDLED_EVENTS, Collections.emptyMap());
        ctx.putObject((Enum)IBusMidofficeContextKeys.RESERVATION, (Object)new Reservation());
        new BuildQueueWatchEventsProcessor().process(ctx);
        List events = (List)ctx.getMandatoryObject((Enum)IBusGdsQueueContextKeys.QUEUE_WATCH_EVENTS);
        Assert.assertEquals((long)1L, (long)events.size());
        TicketTimelimitChangeEvent event = (TicketTimelimitChangeEvent)events.get(0);
        Assert.assertEquals((long)6L, (long)event.getNewTimelimit().toInstant().atZone(ZoneId.systemDefault()).getMinute());
    }

    static class FakeQueueWatchSettings
    extends BaseQueueWatchSettings {
        FakeQueueWatchSettings() {
        }

        public BaseEntity newInstance(String uid) {
            return new FakeQueueWatchSettings();
        }
    }
}

