/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus.queue;

import com.gridnine.xtrip.common.gds.model.BaseAirGdsAccount;
import com.gridnine.xtrip.common.gds.model.BaseQueueReservationReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.server.gds.ibus.queue.IBusGdsQueueContextKeys;
import com.gridnine.xtrip.server.ibus.components.AdviceOnExceptionCallback;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;

public class QueueLogProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        BaseQueueReservationReference ref = (BaseQueueReservationReference)ctx.getMandatoryObject((Enum)IBusGdsQueueContextKeys.QUEUE_RESERVATION_REFERENCE);
        Boolean error = (Boolean)ctx.getMandatoryObject((Enum)IBusGdsQueueContextKeys.QUEUE_PROCESSING_ERROR);
        if (Boolean.TRUE.equals(error)) {
            AdviceOnExceptionCallback callback = (AdviceOnExceptionCallback)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.ADVICE_ON_EXCEPTION_CALLBACK);
            String message = callback.getException().getMessage();
            this.log.error(String.format("queue processing failed for PNR %s, reservation system %s, reason: %s", ref.getRecordLocator(), ((BaseAirGdsAccount)EntityStorage.get().resolve(ref.getGdsAccount()).getEntity()).getGds().name(), message != null ? message : callback.getException().getClass().getName()));
        } else {
            this.log.info(String.format("queue processing succeeded for PNR %s, reservation system %s", ref.getRecordLocator(), ((BaseAirGdsAccount)EntityStorage.get().resolve(ref.getGdsAccount()).getEntity()).getGds().name()));
        }
    }
}

