/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus.queue;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.BaseQueueWatchSettings;
import com.gridnine.xtrip.common.gds.model.GdsTracingDocument;
import com.gridnine.xtrip.common.gds.model.GdsTracingSettings;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.system.BaseSystemSettings;
import com.gridnine.xtrip.common.model.system.BasicSystemSettingsIndex;
import com.gridnine.xtrip.server.gds.ibus.queue.IBusGdsQueueContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Date;

public class QueueWatchSettingsDecomposer
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        BasicSystemSettingsIndex idx = (BasicSystemSettingsIndex)ctx.getMandatoryObject((Enum)IBusGdsQueueContextKeys.QUEUE_WATCH_SETTINGS_INDEX);
        EntityContainer ctr = EntityStorage.get().resolve(idx.getSource());
        BaseQueueWatchSettings settings = (BaseQueueWatchSettings)ctr.getEntity();
        Integer settingsCount = (Integer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.ITERATION_COUNT);
        ctx.addMessage(MessageHelper.createMessage((String)"analyzing {0} settings", (Object[])new Object[]{settingsCount}));
        ctx.addMessage(MessageHelper.createMessage((String)"analyzing settings {0}", (Object[])new Object[]{settings.getName()}));
        ctx.putObject((Enum)IBusGdsQueueContextKeys.QUEUE_WATCH_SETTINGS, (Object)settings);
        EntityContainer accountCtr = EntityStorage.get().resolve(settings.getGdsAccount());
        ctx.putObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT, (Object)accountCtr);
        if (settings.isTrace()) {
            GdsTracingDocument document = new GdsTracingDocument();
            String documentName = "queue-watch-" + ((BaseSystemSettings)ctr.getEntity()).getName();
            document.setName(documentName);
            document.setCreated(new Date());
            GdsTracingSettings gdsTracingSettings = new GdsTracingSettings();
            gdsTracingSettings.setActive(true);
            gdsTracingSettings.setSaveSearchTraces(true);
            ctx.putObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_SETTINGS, (Object)gdsTracingSettings);
            ctx.putObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_DOCUMENT, (Object)document);
        }
    }
}

