/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus.queue;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.SegmentsCancelledEvent;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.gds.ibus.queue.IBusGdsQueueContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;

public class RemoveCancelledSegmentsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        SegmentsCancelledEvent event = (SegmentsCancelledEvent)ctx.getMandatoryObject((Enum)IBusGdsQueueContextKeys.QUEUE_WATCH_EVENT);
        Set cancelledRecordNumbers = event.getGdsSegments().stream().filter(s -> s.isCancelled()).map(s -> s.getRecordNumber()).collect(Collectors.toSet());
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        for (Product prod : GDSHelper.getProducts(reservation)) {
            Iterator stIter = prod.getSegmentTariffs().iterator();
            while (stIter.hasNext()) {
                SegmentTariff st = (SegmentTariff)stIter.next();
                Iterator sIter = st.getSegments().iterator();
                while (sIter.hasNext()) {
                    Segment s2 = (Segment)sIter.next();
                    if (!cancelledRecordNumbers.contains(s2.getRecordNumber())) continue;
                    sIter.remove();
                }
                if (!st.getSegments().isEmpty()) continue;
                stIter.remove();
            }
            AirProductHelper.updateRecordNumbers((Product)prod);
        }
    }
}

