/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus.queue;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.GDSParameters;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TimeLimitType;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.ibus.queue.IBusGdsQueueContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;

public class UpdateTimelimitInReservationProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        ctx.putObject((Enum)IBusGdsQueueContextKeys.TIMELIMIT_UPDATED, (Object)Boolean.FALSE);
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        if (AirProductHelper.getProducts((Reservation)reservation).stream().anyMatch(p -> p.getStatus() != ProductStatus.BOOKING)) {
            ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u0422\u0430\u0439\u043c-\u043b\u0438\u043c\u0438\u0442 \u043d\u0435 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d, \u0442\u0430\u043a \u043a\u0430\u043a \u0435\u0441\u0442\u044c \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u044b \u0441\u043e \u0441\u0442\u0430\u0442\u0443\u0441\u043e\u043c != \u0411\u0440\u043e\u043d\u044c", (Object[])new Object[0]));
            return;
        }
        GDSParameters params = (GDSParameters)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.GDS_PARAMETERS);
        Product product = (Product)AirProductHelper.getAirProductsList((Reservation)reservation).get(0);
        Segment seg0 = (Segment)((SegmentTariff)product.getSegmentTariffs().get(0)).getSegments().get(0);
        Date newCalculatedTimeLimit = FlightHelper.calculateTimeLimit((TimeLimitType)params.getTimeLimitType(), (int)params.getTimeForTimeLimit(), (Date)reservation.getPqTimeLimit(), (DictionaryReference)seg0.getDepartureLocation(), (Date)seg0.getStartDate(), (Date)Optional.ofNullable(reservation.getResDate()).orElse(new Date()));
        Date previousTimeLimit = reservation.getTimeLimit();
        if (!reservation.isManualTimeLimit() && (previousTimeLimit == null || newCalculatedTimeLimit.before(previousTimeLimit))) {
            reservation.setTimeLimit(newCalculatedTimeLimit);
            reservation.getTimeLimitExpiryWarningTime().clear();
            params.getWarningAboutExpiringTime().stream().map(minutes -> FlightHelper.calculateDate((Date)reservation.getTimeLimit(), (int)minutes, (boolean)false)).filter(Objects::nonNull).forEach(date -> reservation.getTimeLimitExpiryWarningTime().add(FlightHelper.buildExpiryWarningTime((Date)date)));
            ctx.putObject((Enum)IBusGdsQueueContextKeys.TIMELIMIT_UPDATED, (Object)Boolean.TRUE);
        } else {
            ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u0422\u0430\u0439\u043c-\u043b\u0438\u043c\u0438\u0442 \u043d\u0435 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d, \u0442\u0430\u043a \u043a\u0430\u043a \u043d\u043e\u0432\u044b\u0439 \u0440\u0430\u0441\u0441\u0447\u0438\u0442\u0430\u043d\u043d\u044b\u0439 \u0442\u0430\u0439\u043c-\u043b\u0438\u043c\u0438\u0442 {0} (\u0422\u041b \u043e\u0442 \u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a\u0430 {1}) \u043f\u043e\u0437\u0436\u0435 \u0442\u0435\u043a\u0443\u0449\u0435\u0433\u043e \u0440\u0430\u0441\u0441\u0447\u0438\u0442\u0430\u043d\u043d\u043e\u0433\u043e {2} (\u0422\u041b \u043e\u0442 \u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a\u0430 {3})", (Object[])new Object[]{newCalculatedTimeLimit, reservation.getPqTimeLimit(), previousTimeLimit, reservation.getPqTimeLimit()}));
        }
    }
}

