/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus.searchFlights;

import com.gridnine.xtrip.common.gds.model.FlightSearchParameters;
import com.gridnine.xtrip.common.gds.model.GdsCapabilities;
import com.gridnine.xtrip.common.gds.model.SeatPreferences;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ReplacePassengerTypesInFlightSearchParameters
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        GdsCapabilities capabilities = (GdsCapabilities)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.GDS_CAPABILITIES);
        FlightSearchParameters parameters = (FlightSearchParameters)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT_SEARCH_PARAMETERS);
        parameters = (FlightSearchParameters)XCloneHelper.clone((XCloneable)parameters, (boolean)true);
        Map<DictionaryReference<PassengerType>, SeatPreferences> seatPreferences = parameters.getSeats().stream().collect(Collectors.toMap(SeatPreferences::getPassengerType, Function.identity()));
        if (!capabilities.isYouthPassengerTypeSupported()) {
            ReplacePassengerTypesInFlightSearchParameters.replacePassengerType(parameters, (DictionaryReference<PassengerType>)DictHelper.getYouthPassengerType(), (DictionaryReference<PassengerType>)DictHelper.getAdultPassengerType(), seatPreferences);
        }
        if (!capabilities.isSeniorPassengerTypeSupported()) {
            ReplacePassengerTypesInFlightSearchParameters.replacePassengerType(parameters, (DictionaryReference<PassengerType>)DictHelper.getSeniorPassengerType(), (DictionaryReference<PassengerType>)DictHelper.getAdultPassengerType(), seatPreferences);
        }
        if (!capabilities.isInfantWithSitePassengerTypeSupported()) {
            ReplacePassengerTypesInFlightSearchParameters.replacePassengerType(parameters, (DictionaryReference<PassengerType>)DictHelper.getInfantWithSeatPassengerType(), (DictionaryReference<PassengerType>)DictHelper.getChildPassengerType(), seatPreferences);
        }
        if (!capabilities.isAgedChildrenPassengerTypesSupported()) {
            for (int age = 2; age <= 13; ++age) {
                ReplacePassengerTypesInFlightSearchParameters.replacePassengerType(parameters, (DictionaryReference<PassengerType>)DictHelper.getChildPassengerType((int)age), (DictionaryReference<PassengerType>)DictHelper.getChildPassengerType(), seatPreferences);
            }
        }
        ctx.putObject((Enum)IBusGdsContextKeys.FLIGHT_SEARCH_PARAMETERS, (Object)parameters);
    }

    private static void replacePassengerType(FlightSearchParameters parameters, DictionaryReference<PassengerType> source, DictionaryReference<PassengerType> target, Map<DictionaryReference<PassengerType>, SeatPreferences> seatPreferences) {
        SeatPreferences spSource = seatPreferences.get(source);
        if (spSource == null) {
            return;
        }
        SeatPreferences spTarget = seatPreferences.get(target);
        if (spTarget != null) {
            spTarget.setCount(spTarget.getCount() + spSource.getCount());
            parameters.getSeats().remove(spSource);
        } else {
            spSource.setPassengerType(target);
        }
        parameters.getReplacedPassengerTypes().put(source, target);
    }
}

