/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus.searchFlights.customFilter;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.bof.midoffice.ibus.gdsTracing.GdsTracingItemBuilder;
import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.GdsTracingSettings;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import java.util.Comparator;
import java.util.stream.Collectors;

public class BestPriceFilter
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Collection flights = (Collection)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHTS);
        GdsTracingSettings gdsTracingSettings = (GdsTracingSettings)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_SETTINGS);
        boolean isSaveRulesTraces = gdsTracingSettings != null && gdsTracingSettings.isActive() && gdsTracingSettings.isSaveRulesTraces();
        GdsTracingItemBuilder builder = (GdsTracingItemBuilder)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_ITEM_BUILDER);
        flights.stream().collect(Collectors.groupingBy(BestPriceFilter::buildId)).values().forEach(flightGroup -> flightGroup.stream().sorted(Comparator.comparing(flight -> FlightHelper.calcTotalPrice((Flight)flight, (ContractType)ContractType.CLIENT))).skip(1L).forEach(flight -> {
            flights.remove(flight);
            if (isSaveRulesTraces) {
                builder.traceFlightLogic((BaseEntity)flight, MessageType.MESSAGE, String.format("excluded option from gds account %s", flight.getGdsAccount()));
            }
        }));
    }

    private static String buildId(Flight flight) {
        return FlightHelper.buildFlightNumbersString((Flight)flight).concat("*".concat(FlightHelper.getCurrency((Flight)flight, (ContractType)ContractType.CLIENT)));
    }
}

