/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus.ssr;

import com.gridnine.bof.midoffice.ibus.BookingFileOperationParameters;
import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.SpecialServiceRequest;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.dict.SpecialServiceRequestStatus;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CheckNeedSaveProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Map<String, SpecialServiceRequestStatus> ssrStatusesOld;
        EntityContainer bfCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
        EntityContainer bfCtrClone = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE_CLONE);
        BookingFileOperationParameters parameters = (BookingFileOperationParameters)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE_OPERATION_PARAMETERS);
        Map<String, SpecialServiceRequestStatus> ssrStatuses = this.getSsrStatuses((BookingFile)bfCtr.getEntity());
        parameters.setSaveBookingFile(!CollectionUtil.equals(ssrStatuses, ssrStatusesOld = this.getSsrStatuses((BookingFile)bfCtrClone.getEntity()), (boolean)true));
    }

    private Map<String, SpecialServiceRequestStatus> getSsrStatuses(BookingFile bf) {
        HashMap<String, SpecialServiceRequestStatus> result = new HashMap<String, SpecialServiceRequestStatus>();
        List reservations = BookingHelper.getReservationsForProduct((BookingFile)bf, (Class[])new Class[]{Product.class});
        for (Reservation res : reservations) {
            for (Product product : AirProductHelper.getProducts((Reservation)res)) {
                List segments = AirProductHelper.getSegments((Collection)product.getSegmentTariffs());
                for (Segment segment : segments) {
                    for (SpecialServiceRequest ssr : segment.getSsrs()) {
                        result.put(ssr.getUid(), ssr.getStatus());
                    }
                }
            }
        }
        return result;
    }
}

