/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus.ssr;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.SpecialServiceRequest;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.dict.SpecialServiceRequestStatus;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.server.ibus.components.BaseRoutingKeyProvider;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class IsBookingFileOkToUpdateSsrProvider
extends BaseRoutingKeyProvider {
    private static List<ProductStatus> CORRECT_PRODUCT_STATUSES = Arrays.asList(ProductStatus.BOOKING, ProductStatus.SELL);

    public String getRoutingKey(MessageContext ctx) throws Exception {
        EntityContainer bfCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
        boolean isOk = this.isBookingOkToUpdateSsr((BookingFile)bfCtr.getEntity());
        return Boolean.toString(isOk);
    }

    private boolean isBookingOkToUpdateSsr(BookingFile booking) {
        for (Reservation reservation : booking.getReservations()) {
            List products = AirProductHelper.getProducts((Reservation)reservation);
            for (Product product : products) {
                if (!this.isProductOkToUpdateSsr(product)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isProductOkToUpdateSsr(Product product) {
        if (!CORRECT_PRODUCT_STATUSES.contains(product.getStatus())) {
            return false;
        }
        for (Segment segment : AirProductHelper.getSegments((Collection)product.getSegmentTariffs())) {
            for (SpecialServiceRequest ssr : segment.getSsrs()) {
                if (ssr.getStatus() != SpecialServiceRequestStatus.PENDING) continue;
                return true;
            }
        }
        return false;
    }
}

