/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus.ssr;

import com.gridnine.xtrip.common.model.booking.ProductIndex;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibus.components.BaseTargetsProvider;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;

public class UpdateSsrStatusesBookingFilesProvider
extends BaseTargetsProvider<String> {
    public Collection<String> getTargets(MessageContext ctx) throws Exception {
        boolean isUpdateErrors = "true".equalsIgnoreCase((String)ctx.getObject("isUpdateErrors"));
        List<ProductIndex> indexes = this.searchProducts(isUpdateErrors);
        HashSet<String> bookingNumbers = new HashSet<String>();
        for (ProductIndex idx : indexes) {
            bookingNumbers.add(idx.getBookingNumber());
        }
        return bookingNumbers;
    }

    private List<ProductIndex> searchProducts(boolean isUpdateErrors) {
        SearchQuery sq = new SearchQuery();
        sq.getCriteria().getCriterions().add(SearchCriterion.in((String)ProductIndex.Property.status.name(), (Object[])new Object[]{ProductStatus.BOOKING, ProductStatus.SELL}));
        ArrayList<SearchCriterion> criterions = new ArrayList<SearchCriterion>();
        criterions.add(SearchCriterion.eq((String)ProductIndex.Property.hasPendingSsrs.name(), (Object)Boolean.TRUE));
        if (isUpdateErrors) {
            criterions.add(SearchCriterion.eq((String)ProductIndex.Property.hasErrorSsrs.name(), (Object)Boolean.TRUE));
        }
        sq.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])criterions.toArray(new SearchCriterion[0])));
        sq.getCriteria().getCriterions().add(SearchCriterion.ge((String)ProductIndex.Property.firstFlightDate.name(), (Object)MiscUtil.setDayEndTime((Date)new Date())));
        sq.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ProductIndex.Property.ssrLastDate.name(), null), SearchCriterion.ge((String)ProductIndex.Property.ssrLastDate.name(), (Object)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)new Date(), (int)-2)))}));
        sq.getPreferredProperties().add(ProductIndex.Property.bookingNumber.name());
        return EntityStorage.get().search(ProductIndex.class, sq).getData();
    }
}

