/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus.tracing;

import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.Document;
import com.gridnine.xtrip.common.model.system.DocumentType;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.common.xml.XUtil;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public final class BookingTracingHelper {
    private static final Logger log = LoggerFactory.getLogger(BookingTracingHelper.class);
    private static ThreadLocal<TracingContext> contexts = new ThreadLocal();

    public static void startNewDocument(String operationName, String bookingNumber) {
        contexts.set(new TracingContext(operationName, bookingNumber));
    }

    public static void addTraceData(TraceItem traceItem) {
        TracingContext context = contexts.get();
        if (context != null) {
            context.traceData.add(traceItem);
        }
    }

    public static Document finishDocument() {
        return BookingTracingHelper.finishDocument(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document finishDocument(boolean needDocument) {
        TracingContext context = contexts.get();
        if (context == null) {
            return null;
        }
        if (!needDocument) {
            contexts.set(null);
            return null;
        }
        try {
            Document document = BookingTracingHelper.prepareTraceDoc(context);
            return document;
        }
        catch (Throwable e) {
            log.error("unable to trace document", e);
            Document document = null;
            return document;
        }
        finally {
            contexts.set(null);
        }
    }

    public static byte[] finishTracing() {
        TracingContext context = contexts.get();
        if (context == null) {
            return null;
        }
        try {
            byte[] byArray = BookingTracingHelper.getTraceData(context);
            return byArray;
        }
        catch (Throwable e) {
            log.error("unable to trace document", e);
            byte[] byArray = null;
            return byArray;
        }
        finally {
            contexts.set(null);
        }
    }

    private static Document prepareTraceDoc(TracingContext context) throws Exception {
        byte[] data = BookingTracingHelper.getTraceData(context);
        if (data == null) {
            return null;
        }
        Document document = new Document();
        document.setCreated(new Date());
        document.setContentType(ContentType.XML);
        document.setContent(data);
        String name = String.format("%s.xml", context.operationName);
        document.setName(name);
        document.setTitle(context.operationName);
        document.setType(DocumentType.GDS_LOG);
        document.setCheckSum(MiscUtil.getCheckSum((byte[])data));
        return document;
    }

    private static byte[] getTraceData(TracingContext context) throws Exception {
        if (context.traceData.isEmpty()) {
            return null;
        }
        org.w3c.dom.Document doc = DocumentBuilderHelper.newDocument();
        Element root = doc.createElement("connector");
        doc.appendChild(root);
        root.setAttribute("bookingNumber", context.bookingNumber);
        for (TraceItem ti : context.traceData) {
            root.appendChild(doc.importNode(ti.getTraceEl(), true));
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        XUtil.newTransformer().transform(new DOMSource(doc), new StreamResult(baos));
        return baos.toByteArray();
    }

    private BookingTracingHelper() {
    }

    public static abstract class TraceItem {
        public abstract Element getTraceEl();
    }

    static class TracingContext {
        String operationName;
        String bookingNumber;
        final List<TraceItem> traceData = new ArrayList<TraceItem>();

        TracingContext(String operationName, String bookingNumber) {
            this.operationName = operationName;
            this.bookingNumber = bookingNumber;
        }
    }
}

