/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus.unsell;

import com.gridnine.xtrip.common.gds.rules.AutoRefundActionsSet;
import com.gridnine.xtrip.common.gds.rules.Targets;
import com.gridnine.xtrip.common.midoffice.model.GdsProductRefundFinanceDetails;
import com.gridnine.xtrip.common.midoffice.model.UnsellProductFinanceDetailsDebugInfo;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.AppliedRule;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.model.validation.StandartValidationMessageType;
import com.gridnine.xtrip.common.model.validation.ValidationMessageHelper;
import com.gridnine.xtrip.common.model.validation.ValidationMessageType;
import com.gridnine.xtrip.common.rules.RuleEngine;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.elements.DebugInfo;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.ibus.autorefund.AutoRefundHelper;
import com.gridnine.xtrip.server.gds.rules.proxy.GdsProductPropertySet;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;

public class AutoRefundCalculatePossibleProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) {
        List contracts = (List)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.AUTOREFUND_VENDOR_CONTRACTS);
        Product product = (Product)ctx.getMandatoryObject((Enum)IBusBookingContextKeys.PRODUCT);
        GdsProductRefundFinanceDetails details = AutoRefundHelper.getOrCreateRecord(product, AutoRefundHelper.getOrCreateMap(ctx));
        UnsellProductFinanceDetailsDebugInfo debugInfo = details.getDebugInfo();
        if (debugInfo.getDebugInfo() == null) {
            debugInfo.setDebugInfo(new DebugInfo());
        }
        debugInfo.getDebugInfo().startBlock("autorefund");
        this.fillRefundProductDetails(details, product, contracts, ctx);
        debugInfo.getDebugInfo().endBlock();
    }

    private boolean isProductValidForRefund(Product prod) {
        return prod.getStatus() == ProductStatus.SELL && prod.getNextProduct() == null;
    }

    private void fillRefundProductDetails(GdsProductRefundFinanceDetails details, Product prod, List<EntityContainer<Contract>> contracts, MessageContext ctx) {
        details.setPossible(false);
        if (!this.isProductValidForRefund(prod)) {
            return;
        }
        try {
            details.setPossible(true);
            AutoRefundActionsSet as = this.applyRulesForAutoRefund(prod, contracts, details.getDebugInfo(), ctx);
            if (as == null) {
                return;
            }
            if (!as.isAutoRefundAllowed()) {
                details.setPossible(false);
                return;
            }
        }
        catch (Exception ex) {
            this.log.error("", (Throwable)ex);
            details.setPossible(false);
        }
    }

    private AutoRefundActionsSet applyRulesForAutoRefund(Product product, List<EntityContainer<Contract>> contracts, UnsellProductFinanceDetailsDebugInfo debugInfo, MessageContext ctx) throws Exception {
        ContractType contractType = ContractType.VENDOR;
        if (contracts.isEmpty()) {
            this.log.debug(String.format("no contracts of type \"%s\" were collected", contractType.name()));
            product.getValidationMessages().add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.RH_MISSING_CONTRACT_OF_TYPE, (Object[])new Object[]{contractType}));
            return null;
        }
        AutoRefundActionsSet autoRefundActionsSet = new AutoRefundActionsSet();
        autoRefundActionsSet.setAutoRefundAllowed(true);
        DebugInfo info = null;
        RuleProxy proxy = new RuleProxy();
        for (EntityContainer<Contract> contractCtr : contracts) {
            HashSet beforeRules = new HashSet(proxy.getAppliedRules());
            List rules = ProfileHelper.getRuleContainers(contractCtr, (Date)new Date());
            proxy.getTracer().setDisabled(info != null);
            proxy.setProxyType(Targets.REFUND_PARAMETERS.getId());
            proxy.setProxyDate(new Date());
            proxy.setPropertySet((Object)new GdsProductPropertySet(proxy));
            if (info == null) {
                info = new DebugInfo();
                proxy.getTracer().setDebugInfo(info);
            }
            ((GdsProductPropertySet)((Object)proxy.getPropertySet())).init(product);
            proxy.setActionSet((Object)autoRefundActionsSet);
            for (EntityContainer container : rules) {
                RuleSet ruleSet = ProfileHelper.getRuleSet((EntityContainer)container);
                RuleEngine.applyRules(Collections.singletonList(proxy), (RuleSet)ruleSet);
            }
            HashSet localRules = new HashSet(proxy.getAppliedRules());
            localRules.removeAll(beforeRules);
            List appliedRules = RulesHelper.calcAppliedRulesToBooking((RuleProxy)proxy, localRules, (List)rules, (BaseProduct)product, contractCtr);
            debugInfo.getAppliedRules().addAll(appliedRules);
            for (AppliedRule rule : appliedRules) {
                info.message(String.format("\u043f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u043e \u043f\u0440\u0430\u0432\u0438\u043b\u043e %s \u0438\u0437 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 %s", rule.getRuleName(), ((Contract)contractCtr.getEntity()).toString()));
            }
            if (appliedRules.isEmpty()) continue;
            info.message("appliedRules.addAll: " + ctx.getRouteDump());
        }
        if (info != null) {
            debugInfo.getDebugInfo().addBlock(info);
        }
        return autoRefundActionsSet;
    }
}

