/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus.unsell;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.midoffice.model.GdsProductRefexFinanceDetails;
import com.gridnine.xtrip.common.midoffice.model.UnsellFinanceDetails;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.AirProductTaxHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;

public class FakeUnsellAirReservationProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        Map unsellRequest = (Map)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.UNSELL_REQUEST);
        UnsellFinanceDetails unsellDetails = (UnsellFinanceDetails)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.UNSELL_FINANCE_DETAILS);
        this.unsell(reservation, unsellRequest, unsellDetails);
    }

    private void unsell(Reservation reservation, Map<String, ProductStatus> unsellRequest, UnsellFinanceDetails unsellDetails) throws Exception {
        for (BaseProduct bp : new ArrayList(reservation.getProducts())) {
            if (unsellRequest.get(bp.getUid()) != ProductStatus.REFUND) continue;
            Product product = (Product)bp;
            GdsProductRefexFinanceDetails gdsRefexDetails = (GdsProductRefexFinanceDetails)unsellDetails.getGdsDetails().get((Object)bp.getUid());
            if (gdsRefexDetails == null) {
                throw Xeption.forDeveloper((String)"no refund details found for product {0}", (Object[])new Object[]{product.getSystemNumber()});
            }
            if (gdsRefexDetails.isVoidPossible()) {
                product.setStatus(ProductStatus.VOID);
                continue;
            }
            Product refund = AirProductHelper.clone((Product)product, (boolean)true);
            product.setNextProduct(refund);
            refund.setPreviousProduct(product);
            refund.setStatus(ProductStatus.REFUND);
            refund.setIssueDate(new Date());
            refund.getFares().clear();
            refund.getTaxes().clear();
            AirProductHelper.setEquivalentFare((Product)refund, (BigDecimal)gdsRefexDetails.getEquivalentFare());
            gdsRefexDetails.getTaxes().stream().map(AirProductTaxHelper::toProductTax).forEach(refund.getTaxes()::add);
            refund.setPenalty(gdsRefexDetails.getPenalty());
        }
    }
}

