/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus.unsell;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.helper.GdsDictHelper;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.server.gds.ibus.autorefund.AutoRefundHelper;
import com.gridnine.xtrip.server.ibus.components.BaseRoutingKeyProvider;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Map;

public class IsAviaPartialReservationUnsellWithPassengerWithoutSeatProvider
extends BaseRoutingKeyProvider {
    public String getRoutingKey(MessageContext ctx) {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        Map request = (Map)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.UNSELL_REQUEST);
        return Boolean.toString(this.isAvia(reservation) && this.containsPassengerWithoutSeat(reservation) && this.isPartial(reservation, request));
    }

    private boolean isAvia(Reservation reservation) {
        return reservation.getProducts().get(0) instanceof Product;
    }

    private boolean containsPassengerWithoutSeat(Reservation reservation) {
        for (Product prod : AirProductHelper.getProducts((Reservation)reservation)) {
            if (prod.getStatus() == ProductStatus.VOID || prod.getStatus() == ProductStatus.VOID_BOOKING || prod.getProductCategory() == ProductCategory.MCO || !GdsDictHelper.isWithoutSeat((DictionaryReference)prod.getPassengerType())) continue;
            return true;
        }
        return false;
    }

    private boolean isPartial(Reservation reservation, Map<String, ProductStatus> request) {
        if (AutoRefundHelper.isOnlyMcoRefund(reservation, request)) {
            return false;
        }
        for (Product prod : AirProductHelper.getProducts((Reservation)reservation)) {
            if (prod.getStatus() == ProductStatus.VOID || prod.getStatus() == ProductStatus.VOID_BOOKING || prod.getProductCategory() == ProductCategory.MCO || request.containsKey(prod.getUid())) continue;
            return true;
        }
        return false;
    }
}

