/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.index;

import com.gridnine.xtrip.common.gds.model.GDSLogDocument;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.system.BaseFileDocument;
import com.gridnine.xtrip.common.model.system.BasicDocumentIndex;
import com.gridnine.xtrip.common.model.system.BasicDocumentIndexData;
import com.gridnine.xtrip.common.model.system.DocumentType;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import java.util.ArrayList;
import java.util.Collection;

public class GdsLogDocumentBasicDocumentIndexHandler
implements IndexHandler<BaseFileDocument, BasicDocumentIndex> {
    public Class<BasicDocumentIndex> getIndexClass() {
        return BasicDocumentIndex.class;
    }

    public Class<BaseFileDocument> getEntityType() {
        return BaseFileDocument.class;
    }

    public Class<? extends BaseIndexData<BaseFileDocument, BasicDocumentIndex>> getDataClass() {
        return BasicDocumentIndexData.class;
    }

    public void create(EntityContainer<BaseFileDocument> etc, Collection<BaseIndexData<BaseFileDocument, BasicDocumentIndex>> indexes) {
        if (!GDSLogDocument.class.isAssignableFrom(((BaseFileDocument)etc.getEntity()).getClass())) {
            return;
        }
        BasicDocumentIndexData data = new BasicDocumentIndexData();
        BaseFileDocument entity = (BaseFileDocument)etc.getEntity();
        data.setContentType(entity.getContentType());
        data.setCreated(entity.getCreated());
        data.setName(entity.getName());
        data.setTitle(entity.getTitle());
        data.setCheckSum(entity.getCheckSum());
        data.setSize(entity.getContent() == null ? 0 : entity.getContent().length);
        data.setType(DocumentType.GDS_LOG);
        ArrayList<String> ownersUids = new ArrayList<String>();
        for (EntityReference owner : entity.getOwners()) {
            ownersUids.add(owner.getUid());
        }
        data.setOwnersUids(ownersUids);
        data.setOwner(entity.getOwner());
        data.setNavigationKey(entity.getNavigationKey());
        DataAggregator aggregator = new DataAggregator();
        aggregator.aggregate((Object)entity.getName());
        aggregator.aggregate(entity.getCreated());
        aggregator.aggregate((Enum)entity.getContentType());
        aggregator.aggregate((Object)entity.getDescription());
        aggregator.aggregate((Object)entity.getTitle());
        aggregator.aggregate((Object)entity.getOwner());
        data.setAggregatedData(aggregator.toString());
        indexes.add((BaseIndexData<BaseFileDocument, BasicDocumentIndex>)data);
    }
}

