/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.interceptors;

import com.gridnine.xtrip.common.gds.rules.AutoRefundActions;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ModelContract;
import com.gridnine.xtrip.common.model.rules.standard.RuleResultValue;
import com.gridnine.xtrip.common.rules.RuleResult;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.model.EntityInterceptor;
import com.gridnine.xtrip.server.fx.rpc.EntityServiceImpl;
import java.util.Date;

public class CheckPenaltiesConsistencyInterceptor
implements EntityInterceptor {
    public void onSave(SessionCallback ss, EntityContainer<?> data) throws Exception {
        EntityServiceImpl.ClientEntityOperation operation = (EntityServiceImpl.ClientEntityOperation)LogicalStorage.get().getEntityStorage().getGlobalOperationContext().getParameters().get("KEY_CLIENT_ENTITY_OPERATION");
        if (operation == EntityServiceImpl.ClientEntityOperation.SAVE) {
            if (ModelContract.class.equals((Object)data.getEntityType())) {
                this.checkConsistency(((ModelContract)data.getEntity()).getRuleSet());
            }
            if (Contract.class.equals((Object)data.getEntityType())) {
                this.checkConsistency(((Contract)data.getEntity()).getRuleSet());
            }
        }
    }

    private void checkConsistency(RuleSet ruleSet) {
        if (ruleSet == null) {
            return;
        }
        Date date = new Date();
        for (RuleSettings rs : ruleSet.getRules()) {
            if (rs.getPeriodBegin() != null && rs.getPeriodBegin().after(date) || rs.getPeriodEnd() != null && rs.getPeriodEnd().before(date)) continue;
            for (RuleResult rr : rs.getResults()) {
                RuleResultValue rrv;
                if (AutoRefundActions.PENALTY != rr.getAction() || (rrv = (RuleResultValue)rr.getValue()).getTarget() != null && EntityStorage.get().isAvailable(rrv.getTarget().getType(), rrv.getTarget().getUid())) continue;
                throw Xeption.forAdmin((String)"\u0432 \u043f\u0440\u0430\u0432\u0438\u043b\u0435 \u2116 {0} {1}\u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442\u0441\u044f \u043d\u0435\u0430\u043a\u0442\u0443\u0430\u043b\u044c\u043d\u0430\u044f \u0441\u0441\u044b\u043b\u043a\u0430 \u043d\u0430 \u0448\u0442\u0440\u0430\u0444", (Object[])new Object[]{ruleSet.getRules().indexOf(rs) + 1, rs.getName() == null ? "" : String.format("(%s) ", rs.getName())});
            }
        }
    }

    public void onDelete(SessionCallback ss, EntityContainer<?> data) throws Exception {
    }

    public double getPriority() {
        return 0.0;
    }
}

