/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.jibx;

import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.gds.jibx.TestJibxWsInvoker;
import com.gridnine.xtrip.server.gds.test.GDSTestBase;
import com.gridnine.xtrip.server.jibxws.WsRequest;
import com.gridnine.xtrip.server.jibxws.WsResponse;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IUnmarshallingContext;
import org.junit.Assert;
import org.w3c.dom.Element;

public abstract class JibxGdsTestBase
extends GDSTestBase {
    protected List<URL> collectIntegrationBusDescriptions() {
        List result = super.collectIntegrationBusDescriptions();
        result.add(JibxGdsTestBase.class.getResource("ibus-test-jibx-ws.xml"));
        return result;
    }

    protected void loadGdsTransactions(Map<String, Object> ctx, String filename) throws Exception {
        ArrayList<MiscUtil.Pair> transactions = new ArrayList<MiscUtil.Pair>();
        try (InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream(filename);){
            Element elTransactions = DocumentBuilderHelper.parse((InputStream)is).getDocumentElement();
            for (Element elTransaction : XmlUtil.getElements((Element)elTransactions, (String)"transaction")) {
                Element[] children;
                WsRequest wsRequest = new WsRequest();
                WsResponse wsResponse = new WsResponse();
                Element elRequest = XmlUtil.getElement((Element)elTransaction, (String)"request");
                Element elPayload = XmlUtil.getElement((Element)elRequest, (String)"payload");
                Element elEnvelope = XmlUtil.getChild((Element)elPayload, (String)"Envelope");
                Element elHeader = XmlUtil.getChild((Element)elEnvelope, (String)"Header");
                for (Element el : XmlUtil.getChildren((Element)elHeader)) {
                    el.removeAttribute("soap-env:mustUnderstand");
                    wsRequest.getHeaders().add(this.unmarshal(el));
                }
                Element elBody = XmlUtil.getChild((Element)elEnvelope, (String)"Body");
                wsRequest.setPayload(this.unmarshal(XmlUtil.getChildren((Element)elBody)[0]));
                Element elResponse = XmlUtil.getElement((Element)elTransaction, (String)"response");
                elPayload = XmlUtil.getElement((Element)elResponse, (String)"payload");
                elEnvelope = XmlUtil.getChild((Element)elPayload, (String)"Envelope");
                elHeader = XmlUtil.getChild((Element)elEnvelope, (String)"Header");
                if (elHeader != null) {
                    for (Element el : XmlUtil.getChildren((Element)elHeader)) {
                        el.removeAttribute("soap-env:mustUnderstand");
                        wsResponse.getHeaders().add(this.unmarshal(el));
                    }
                }
                if ((children = XmlUtil.getChildren((Element)(elBody = XmlUtil.getChild((Element)elEnvelope, (String)"Body")))).length > 0) {
                    wsResponse.setPayload(this.unmarshal(children[0]));
                }
                transactions.add(new MiscUtil.Pair((Object)wsRequest, (Object)wsResponse));
            }
        }
        ctx.put(TestJibxWsInvoker.GDS_TRANSACTIONS_KEY, transactions);
    }

    protected abstract Class<?> getJibxClass(String var1) throws Exception;

    private Object unmarshal(Element el) throws Exception {
        String tagName = el.getTagName();
        if (tagName.indexOf(58) >= 0) {
            tagName = tagName.substring(tagName.indexOf(58) + 1);
        }
        try (ByteArrayInputStream bais = new ByteArrayInputStream(XUtil.toString((Element)el).getBytes());){
            Class<?> clazz = this.getJibxClass(tagName);
            if (clazz == null) {
                throw new Exception("unknown tag " + tagName);
            }
            IBindingFactory factory = BindingDirectory.getFactory(clazz);
            IUnmarshallingContext unmarshaller = factory.createUnmarshallingContext();
            Object object = unmarshaller.unmarshalDocument((InputStream)bais, "UTF-8");
            return object;
        }
    }

    protected void checkScenarioCompleted(Map<String, Object> ctx) {
        Iterator iter = (Iterator)ctx.get(TestJibxWsInvoker.ITERATOR_KEY);
        Assert.assertFalse((String)"more transactions expected", (boolean)iter.hasNext());
    }
}

