/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.logger;

import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.Document;
import com.gridnine.xtrip.common.model.system.DocumentType;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.xml.XSUtil;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.jaxws.InvocationContext;
import com.gridnine.xtrip.server.jibx.logger.InvocationContext;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.codec.digest.DigestUtils;
import org.w3c.dom.Element;

public class InvocationContextWrapper {
    private static final InvocationContextWrapper INSTANCE = new InvocationContextWrapper();

    private InvocationContextWrapper() {
    }

    public static InvocationContextWrapper get() {
        return INSTANCE;
    }

    void begin() {
        com.gridnine.xtrip.server.jibx.logger.InvocationContext.get().begin();
        InvocationContext.get().begin();
    }

    boolean isActive() {
        return com.gridnine.xtrip.server.jibx.logger.InvocationContext.get().isActive() && InvocationContext.get().isActive();
    }

    void end() {
        com.gridnine.xtrip.server.jibx.logger.InvocationContext.get().end();
        InvocationContext.get().end();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Document buildDocument() throws Exception {
        byte[] content;
        List<TransactionWrapper> sortedTransactions = this.getSortedTransactions();
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            try (XMLStreamWriter writer = XSUtil.wrapForPrettyPrinting((XMLStreamWriter)XSUtil.getXMLOutputFactory().createXMLStreamWriter(baos));){
                writer.writeStartDocument();
                writer.writeStartElement("ws-transactions");
                for (TransactionWrapper wrapper : sortedTransactions) {
                    if (wrapper.source == TransactionSource.JIBX) {
                        this.writeJIBXTransacation((InvocationContext.Transaction)wrapper.transaction, baos, writer);
                    }
                    if (wrapper.source != TransactionSource.JAXWS) continue;
                    writer.flush();
                    this.writeJAXWSTransactions((InvocationContext.TransactionWrapper)wrapper.transaction, baos);
                }
                writer.writeEndElement();
                writer.writeEndDocument();
            }
            content = baos.toByteArray();
        }
        Document document = new Document();
        document.setContent(content);
        document.setCheckSum(DigestUtils.md5Hex((byte[])document.getContent()));
        document.setContentType(ContentType.XML);
        document.setType(DocumentType.GDS_LOG);
        document.setCreated(new Date());
        return document;
    }

    private List<TransactionWrapper> getSortedTransactions() {
        ArrayList<TransactionWrapper> result = new ArrayList<TransactionWrapper>();
        result.addAll(this.getJIBXTransactions());
        result.addAll(this.getJAXWSransactions());
        Collections.sort(result, (tr1, tr2) -> (int)(((TransactionWrapper)tr1).startingTime.getTime() - ((TransactionWrapper)tr2).startingTime.getTime()));
        return result;
    }

    private List<TransactionWrapper> getJIBXTransactions() {
        return com.gridnine.xtrip.server.jibx.logger.InvocationContext.get().getTransactions().stream().map(tr -> new TransactionWrapper(TransactionSource.JIBX, tr, tr.getStartingTime())).collect(Collectors.toList());
    }

    private List<TransactionWrapper> getJAXWSransactions() {
        return InvocationContext.get().getTransactions().stream().map(tr -> new TransactionWrapper(TransactionSource.JAXWS, tr, tr.getStartingTime())).collect(Collectors.toList());
    }

    private void writeJIBXTransacation(InvocationContext.Transaction transaction, ByteArrayOutputStream baos, XMLStreamWriter writer) throws Exception {
        transaction.toXML(writer, (OutputStream)baos);
    }

    private void writeJAXWSTransactions(InvocationContext.TransactionWrapper wrapper, ByteArrayOutputStream baos) throws Exception {
        MiscUtil.writeBytesWithoutXmlHeader((OutputStream)baos, (byte[])XUtil.toString((Element)wrapper.getTransaction()).getBytes());
        baos.flush();
    }

    private static class TransactionWrapper {
        private TransactionSource source;
        private Object transaction;
        private Date startingTime;

        public TransactionWrapper(TransactionSource source, Object transaction, Date startingTime) {
            this.source = source;
            this.transaction = transaction;
            this.startingTime = startingTime;
        }
    }

    private static enum TransactionSource {
        JIBX,
        JAXWS;

    }
}

