/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.rules;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.FareInfo;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightFare;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.model.FlightSegmentTariff;
import com.gridnine.xtrip.common.gds.rules.GDSRulesEnvironment;
import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.commission.BaseCommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.CalculationBasis;
import com.gridnine.xtrip.common.model.booking.commission.CalculationType;
import com.gridnine.xtrip.common.model.booking.commission.CommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.FeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.FeeType;
import com.gridnine.xtrip.common.model.booking.commission.PaymentFeeCalculationBasis;
import com.gridnine.xtrip.common.model.booking.commission.PaymentFeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.PaymentFeeType;
import com.gridnine.xtrip.common.model.booking.commission.RoundingMode;
import com.gridnine.xtrip.common.model.booking.commission.RoundingValue;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.AirlineReference;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.CommissionCategory;
import com.gridnine.xtrip.common.model.dict.CommissionCategoryReference;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.GeoLocationReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ContractCustomerInfo;
import com.gridnine.xtrip.common.model.profile.ExchangeRateCondition;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.model.profile.Pcc;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonEmployment;
import com.gridnine.xtrip.common.model.profile.PersonType;
import com.gridnine.xtrip.common.model.profile.PlaceOfSales;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.profile.Validator;
import com.gridnine.xtrip.common.model.rules.standard.Actions;
import com.gridnine.xtrip.common.model.rules.standard.Conditions;
import com.gridnine.xtrip.common.model.rules.standard.MidofficeRulesEnvironment;
import com.gridnine.xtrip.common.model.rules.standard.Properties;
import com.gridnine.xtrip.common.model.rules.standard.RuleResultValue;
import com.gridnine.xtrip.common.model.rules.standard.Targets;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.rules.RuleRestriction;
import com.gridnine.xtrip.common.rules.RuleResult;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.RulesEnvironment;
import com.gridnine.xtrip.common.rules.elements.RuleAction;
import com.gridnine.xtrip.common.rules.elements.RuleCondition;
import com.gridnine.xtrip.common.rules.elements.RuleProperty;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;
import com.gridnine.xtrip.common.util.interceptors.HasPriority;
import com.gridnine.xtrip.common.util.interceptors.InterceptorsRegistry;
import com.gridnine.xtrip.server.gds.ibus.FlightAndRuleProxies;
import com.gridnine.xtrip.server.gds.ibus.FlightSalesChainBuilder;
import com.gridnine.xtrip.server.gds.ibus.FlightsCommissionsCalculateCommissionsProcessor;
import com.gridnine.xtrip.server.gds.ibus.FlightsCommissionsCollectContractsProcessor;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.rules.proxy.FlightPropertySet;
import com.gridnine.xtrip.server.gds.rules.proxy.GDSParametersActions;
import com.gridnine.xtrip.server.gds.rules.proxy.GdsProductPropertySetInterceptor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.handlers.ProductPropertySetInterceptor;
import com.gridnine.xtrip.server.model.test.ModelTestBase;
import com.gridnine.xtrip.server.storage.DictionaryStorage;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;

public abstract class FlightCommissionsTestBase
extends ModelTestBase {
    protected EntityReference<CommissionProperties> commProp;
    protected EntityReference<FeeProperties> feeProp;
    protected EntityReference<SalesPoint> salesPoint;
    protected EntityReference<Organization> agency;
    protected EntityReference<Organization> bsp;
    protected EntityReference<Organization> client;
    protected EntityReference<Person> customer;
    protected DictionaryReference<Airline> carrier;
    protected String pcc = "PCC1";
    protected String validator = "VAL1";
    protected String commissionCategory = "CAT";
    protected String departureCityCode = "MOW";
    protected String arrivalCityCode = "PAR";

    protected void configureRulesEnvironment(RulesEnvironment re) {
        super.configureRulesEnvironment(re);
        new MidofficeRulesEnvironment().environmentInitialized(re);
        new GDSRulesEnvironment().environmentInitialized(re);
    }

    protected void createProfiles() throws Exception {
        this.createCommissionCategory();
        this.createCommissionProperties();
        this.feeProp = this.createFeeProperties(new CommissionCategoryReference(this.commissionCategory), true);
        this.bsp = new EntityReference("BSP_container", Organization.class, "BSP");
        EntityContainer<Organization> ctr = this.createOrganization("001", "Client", OrganizationType.CORPORATE_CLIENT);
        this.client = ctr.toReference();
        ctr = this.createOrganization("002", "Agency", OrganizationType.AGENCY);
        this.agency = ctr.toReference();
        this.carrier = new AirlineReference("A1");
        this.createSalesPoint();
        this.createAgent();
    }

    protected void createContracts(RuleSet vendorRuleSet, RuleSet clientRuleSet) throws Exception {
        this.createVendorContract(vendorRuleSet);
        this.createClientContract(clientRuleSet);
    }

    protected void createAgent() throws Exception {
        Person person = new Person();
        person.setCode("ivanov");
        person.setActive(true);
        L10nStringHelper.setValue((L10nString)person.getLastName(), (String)"Ivanov", (Locale)Locale.ENGLISH);
        L10nStringHelper.setValue((L10nString)person.getFirstName(), (String)"Ivan", (Locale)Locale.ENGLISH);
        person.getTypes().add(PersonType.MANAGER);
        PersonEmployment employment = new PersonEmployment();
        employment.setMainEmployment(true);
        employment.setOrganization(this.client);
        person.getEmployments().add(employment);
        PlaceOfSales pos = new PlaceOfSales();
        pos.setSalesPoint(this.salesPoint);
        person.getSalesPoints().add(pos);
        EntityContainer ctr = EntityContainer.create((BaseEntity)person);
        this.customer = ctr.toReference();
        EntityStorage.get().save(ctr, false);
    }

    protected void createVendorContract(RuleSet vendorRuleSet) throws Exception {
        Contract contract = new Contract();
        contract.setContractType(ContractType.VENDOR);
        contract.setName("Vendor contract");
        contract.setSupplier(this.bsp);
        contract.setVendor(this.bsp);
        ContractCustomerInfo info = new ContractCustomerInfo();
        info.setCustomer(this.agency);
        contract.getCustomers().add(info);
        contract.setRuleSet(vendorRuleSet);
        EntityStorage.get().save(EntityContainer.create((BaseEntity)contract), false);
    }

    protected void createClientContract(RuleSet clientRuleSet) throws Exception {
        this.createContract(clientRuleSet, this.agency, this.client, ContractType.CLIENT, null, null, null);
    }

    protected void createContract(RuleSet ruleSet, EntityReference<Organization> supplierRef, EntityReference<Organization> customerRef, ContractType contractType, String currency, RoundingMode roundingMode, RoundingValue roundingValue) throws Exception {
        Contract contract = new Contract();
        contract.setContractType(contractType);
        contract.setName("Client contract");
        contract.setSupplier(supplierRef);
        ContractCustomerInfo info = new ContractCustomerInfo();
        info.setCustomer(customerRef);
        info.setPaymentCurrency(currency);
        ExchangeRateCondition rateCond = new ExchangeRateCondition();
        rateCond.setCoefficient(1.0);
        rateCond.setRoundingMode(roundingMode);
        rateCond.setRoundingValue(roundingValue);
        info.getExchangeRateConditions().add(rateCond);
        contract.getCustomers().add(info);
        contract.setRuleSet(ruleSet);
        EntityStorage.get().save(EntityContainer.create((BaseEntity)contract), false);
    }

    protected RuleSet createVendorRuleSet(double value) {
        RuleSet ruleSet = new RuleSet();
        RuleSettings rs = new RuleSettings();
        rs.setName("Vendor rule");
        rs.setTarget((RuleTarget)Targets.PRODUCT_COMMISSION);
        RuleResultValue rrv = new RuleResultValue();
        rrv.setTarget(this.commProp);
        rrv.setCurrencyCode("%");
        rrv.setValue(value);
        RuleResult res = new RuleResult();
        res.setAction((RuleAction)Actions.SIMPLE_COMMISSION);
        res.setValue((Object)rrv);
        rs.getResults().add(res);
        ruleSet.getRules().add(rs);
        return ruleSet;
    }

    protected SalesContext createSalesContext() {
        SalesContext salesContext = new SalesContext();
        salesContext.setAgency(this.agency);
        salesContext.setAgent(this.customer);
        salesContext.setClient(this.client);
        salesContext.setSubagency(this.agency);
        salesContext.setSalesPoint(this.salesPoint);
        return salesContext;
    }

    protected Flight createFlight() {
        return this.createFlight("EUR");
    }

    protected Flight createFlight(String currencyCode) {
        Flight flight = new Flight();
        flight.setBlankOwner(this.bsp);
        flight.setEticket(true);
        flight.setGds(GdsName.SABRE);
        flight.setCarrier(this.carrier);
        FlightFare fare = new FlightFare();
        fare.setBaseAmount(SystemHelper.getMoney((double)100.0, (String)currencyCode));
        fare.setPassengerType(DictHelper.getAdultPassengerType());
        fare.setEquivalentAmount(BigDecimal.valueOf(100L));
        flight.getFares().add(fare);
        FlightSegmentTariff fst = new FlightSegmentTariff();
        fst.setGds(GdsName.SABRE);
        flight.getSegmentTariffs().add(fst);
        FlightSegment fs = new FlightSegment();
        fst.getSegments().add(fs);
        fs.setAirline((DictionaryReference)new AirlineReference("SU"));
        fs.setBookingClass("N");
        fs.setFlightNumber("100");
        fs.setGds(GdsName.SABRE);
        fs.setLocationBegin((DictionaryReference)new GeoLocationReference(this.departureCityCode));
        fs.setLocationEnd((DictionaryReference)new GeoLocationReference(this.arrivalCityCode));
        fs.setStarting(true);
        FareInfo fi = new FareInfo();
        fi.setPassengerType(DictHelper.getAdultPassengerType());
        fi.setFareBasis("NFareBasis");
        fs.getFareInfos().add(fi);
        fst = new FlightSegmentTariff();
        fst.setGds(GdsName.SABRE);
        flight.getSegmentTariffs().add(fst);
        fs = new FlightSegment();
        fst.getSegments().add(fs);
        fs.setAirline((DictionaryReference)new AirlineReference("SU"));
        fs.setBookingClass("N");
        fs.setFlightNumber("101");
        fs.setGds(GdsName.SABRE);
        fs.setLocationBegin((DictionaryReference)new GeoLocationReference(this.arrivalCityCode));
        fs.setLocationEnd((DictionaryReference)new GeoLocationReference(this.departureCityCode));
        fi = new FareInfo();
        fi.setPassengerType(DictHelper.getAdultPassengerType());
        fi.setFareBasis("NFareBasis");
        fs.getFareInfos().add(fi);
        return flight;
    }

    protected RuleSet createClientRuleSet(double vendorComm, double clientComm) {
        RuleSet ruleSet = new RuleSet();
        RuleSettings rs = new RuleSettings();
        rs.setName("Client rule");
        rs.setTarget((RuleTarget)Targets.PRODUCT_COMMISSION);
        RuleRestriction restr = new RuleRestriction();
        restr.setProperty((RuleProperty)Properties.VENDOR_COMMISSION_RATE);
        restr.setCondition((RuleCondition)Conditions.LESS_THAN);
        restr.setValue((Object)vendorComm);
        rs.getRestrictions().add(restr);
        RuleResultValue rrv = new RuleResultValue();
        rrv.setTarget(this.feeProp);
        rrv.setCurrencyCode("RUB");
        rrv.setValue(clientComm);
        RuleResult res = new RuleResult();
        res.setAction((RuleAction)Actions.SIMPLE_FEE);
        res.setValue((Object)rrv);
        rs.getResults().add(res);
        ruleSet.getRules().add(rs);
        return ruleSet;
    }

    protected RuleSet createSimpleRuleSet(int startValue, EntityReference<? extends BaseCommissionProperties> ... fees) {
        RuleSet ruleSet = new RuleSet();
        int index = startValue;
        for (EntityReference<? extends BaseCommissionProperties> fee : fees) {
            RuleSettings rs = new RuleSettings();
            rs.setName("A1-" + index);
            rs.setTarget((RuleTarget)Targets.PRODUCT_COMMISSION);
            RuleResult res = new RuleResult();
            res.setAction((RuleAction)Actions.SIMPLE_FEE);
            RuleResultValue value = new RuleResultValue();
            value.setCurrencyCode("RUB");
            value.setTarget(fee);
            value.setValue((double)index);
            res.setValue((Object)value);
            rs.getResults().add(res);
            ruleSet.getRules().add(rs);
            index += 10;
        }
        return ruleSet;
    }

    protected void createSalesPoint() throws Exception {
        SalesPoint sp = new SalesPoint();
        sp.setCode("001");
        sp.setShortName("Sales point");
        Validator val = new Validator();
        val.setAgency(this.agency);
        val.setBlankOwner(this.bsp);
        val.setSupplier(this.bsp);
        val.setNumber(this.validator);
        sp.getValidators().add(val);
        Pcc aPcc = new Pcc();
        aPcc.setAgency(this.agency);
        aPcc.setCode(this.pcc);
        sp.getPccs().add(aPcc);
        EntityContainer ctr = EntityContainer.create((BaseEntity)sp);
        this.salesPoint = ctr.toReference();
        EntityStorage.get().save(ctr, false);
    }

    protected EntityContainer<Organization> createOrganization(String code, String name, OrganizationType type) throws Exception {
        return this.createOrganization(code, name, type, null);
    }

    protected EntityContainer<Organization> createOrganization(String code, String name, OrganizationType type, EntityReference<Organization> parent) throws Exception {
        Organization result = new Organization();
        result.setCode(code);
        L10nStringHelper.setValue((L10nString)result.getFullName(), (String)name, (Locale)Locale.ENGLISH);
        L10nStringHelper.setValue((L10nString)result.getShortName(), (String)name, (Locale)Locale.ENGLISH);
        result.getTypes().add(type);
        result.setParent(parent);
        EntityContainer ctr = EntityContainer.create((BaseEntity)result);
        EntityStorage.get().save(ctr, false);
        return ctr;
    }

    protected void createCommissionCategory() throws Exception {
        CommissionCategory cat = new CommissionCategory();
        cat.setCode(this.commissionCategory);
        cat.getTranslations().put(Locale.ENGLISH, "Category");
        DictionaryStorage.get().save((BaseDictionary)cat);
    }

    protected void createCommissionProperties() throws Exception {
        CommissionProperties prop = new CommissionProperties();
        prop.setCategory((DictionaryReference)new CommissionCategoryReference(this.commissionCategory));
        prop.setDisplayName("Commission %");
        prop.setRate(true);
        prop.setRoundingMode(RoundingMode.MATH);
        prop.setRoundingValue(RoundingValue.V_1);
        EntityContainer ctr = EntityContainer.create((BaseEntity)prop);
        this.commProp = ctr.toReference();
        EntityStorage.get().save(ctr, false);
    }

    protected CommissionCategory createCategory(String code) throws Exception {
        CommissionCategory category1 = new CommissionCategory();
        category1.setCode(code);
        category1.getTranslations().put(Locale.ENGLISH, code);
        DictionaryStorage.get().save((BaseDictionary)category1);
        return category1;
    }

    protected EntityReference<FeeProperties> createFeeProperties(CommissionCategoryReference categoryRef, boolean chargeToClients) throws Exception {
        return this.createFeeProperties(categoryRef, chargeToClients, false, null);
    }

    protected EntityReference<FeeProperties> createFeeProperties(CommissionCategoryReference categoryRef, boolean chargeToClients, boolean rate, CalculationBasis basis) throws Exception {
        FeeProperties prop = new FeeProperties();
        prop.setCategory((DictionaryReference)categoryRef);
        prop.setDisplayName("Fee fixed");
        prop.setCalculationType(CalculationType.TICKET);
        prop.setType(FeeType.STANDARD);
        prop.setChargeToClientForAllContractTypes(chargeToClients);
        prop.setRate(rate);
        prop.setCalculationBasis(basis);
        EntityContainer ctr = EntityContainer.create((BaseEntity)prop);
        EntityStorage.get().save(ctr, false);
        return ctr.toReference();
    }

    protected EntityReference<PaymentFeeProperties> createPaymentFeeProperties(PaymentType ptype, boolean rate, PaymentFeeCalculationBasis basis, String name) throws Exception {
        PaymentFeeProperties prop = new PaymentFeeProperties();
        prop.setDisplayName(name);
        prop.setPaymentType(ptype);
        prop.setType(PaymentFeeType.STANDARD);
        prop.setRate(rate);
        prop.setBasis(basis);
        EntityContainer ctr = EntityContainer.create((BaseEntity)prop);
        EntityStorage.get().save(ctr, false);
        return ctr.toReference();
    }

    protected void applyRules(Flight flight) throws Throwable {
        SalesContext salesContext = this.createSalesContext();
        this.applyRules(flight, this.createProxy(flight, salesContext), salesContext);
    }

    protected void applyRules(Flight flight, RuleProxy<FlightPropertySet, GDSParametersActions> proxy, SalesContext salesContext) throws Throwable {
        MessageContext mc = new MessageContext();
        mc.putObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT, (Object)salesContext);
        ArrayList<Flight> flights = new ArrayList<Flight>();
        flights.add(flight);
        mc.putObject((Enum)IBusGdsContextKeys.FLIGHTS, flights);
        mc.putObject((Enum)IBusGdsContextKeys.FLIGHT_AND_RULE_PROXY, (Object)new FlightAndRuleProxies(flight, Collections.singletonMap(DictHelper.getAdultPassengerType(), proxy)));
        FlightSalesChainBuilder scBuilder = new FlightSalesChainBuilder();
        scBuilder.process(mc);
        mc.putObject((Enum)IBusGdsContextKeys.PAYMENT_TYPE, (Object)PaymentType.INVOICE);
        FlightsCommissionsCollectContractsProcessor collectContractsProcessor = new FlightsCommissionsCollectContractsProcessor();
        collectContractsProcessor.process(mc);
        FlightsCommissionsCalculateCommissionsProcessor calculateCommissionsProcessor = new FlightsCommissionsCalculateCommissionsProcessor();
        calculateCommissionsProcessor.process(mc);
    }

    protected RuleProxy<FlightPropertySet, GDSParametersActions> createProxy(Flight flight, SalesContext salesContext) {
        RuleProxy proxy = new RuleProxy();
        proxy.getTracer().setDisabled(true);
        proxy.setProxyType(com.gridnine.xtrip.common.gds.rules.Targets.GDS_PARAMETERS_EX.getId());
        proxy.setProxyDate(new Date());
        proxy.setPropertySet((Object)FlightPropertySet.create(flight, (DictionaryReference<PassengerType>)DictHelper.getAdultPassengerType(), PaymentType.INVOICE, null, proxy, salesContext));
        proxy.setActionSet((Object)new GDSParametersActions());
        return proxy;
    }

    protected void configureInterceptorsRegistry(InterceptorsRegistry registry) {
        super.configureInterceptorsRegistry(registry);
        registry.registerInterceptor(ProductPropertySetInterceptor.class, (HasPriority)new GdsProductPropertySetInterceptor());
    }
}

