/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.rules;

import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.GdsCommission;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.commission.CalculationBasis;
import com.gridnine.xtrip.common.model.booking.commission.CalculationType;
import com.gridnine.xtrip.common.model.booking.commission.Operation;
import com.gridnine.xtrip.common.model.booking.commission.RoundingMode;
import com.gridnine.xtrip.common.model.booking.commission.RoundingValue;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.server.gds.rules.FlightCommissionsTestBase;
import com.gridnine.xtrip.server.gds.test.TestFlightBuilder;
import com.gridnine.xtrip.server.model.test.TestCommissionCategoryBuilder;
import com.gridnine.xtrip.server.model.test.TestContractBuilderBuilder;
import com.gridnine.xtrip.server.model.test.TestFeePropertiesBuilder;
import java.math.BigDecimal;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class FlightHiddenFeeAsTaxTest
extends FlightCommissionsTestBase {
    @Test
    public void testHiddenFees() throws Throwable {
        this.createProfiles();
        DictionaryReference cat1Ref = ((TestCommissionCategoryBuilder)((TestCommissionCategoryBuilder)new TestCommissionCategoryBuilder().code("cat1")).translation("category1")).create();
        DictionaryReference cat2Ref = ((TestCommissionCategoryBuilder)((TestCommissionCategoryBuilder)new TestCommissionCategoryBuilder().code("cat2")).translation("category2")).create();
        EntityReference hiddenFeeRef = new TestFeePropertiesBuilder().displayName("Hidden Fee").calculationType(CalculationType.TICKET).calculationType(Operation.SELL).hidden(true, "RVI").category(cat2Ref).chargeToClient(true).create().toReference();
        EntityReference standardFeeRef = new TestFeePropertiesBuilder().displayName("Standard").calculationType(CalculationType.TICKET).basis(CalculationBasis.TOTAL).roundingMode(RoundingMode.UP).roundingValue(RoundingValue.V_1).calculationType(Operation.SELL).category(cat1Ref).create().toReference();
        new TestContractBuilderBuilder().contractType(ContractType.VENDOR).name("Vendor Contract").blankOwner(this.bsp).supplier(this.bsp).customer(this.agency).airFee(100.0, "RUB", hiddenFeeRef).create();
        new TestContractBuilderBuilder().contractType(ContractType.CLIENT).name("Client Contract").supplier(this.agency).customer(this.client).airFee(2.0, "%", standardFeeRef).create();
        Flight flight = new TestFlightBuilder().blankOwner(this.bsp).fare(100.0, DictHelper.getAdultPassengerType()).getEntity();
        this.applyRules(flight);
        List commissions = FlightHelper.getContractRelation((Flight)flight, (ContractType)ContractType.CLIENT, (DictionaryReference)DictHelper.getAdultPassengerType()).getCommissions();
        Assert.assertEquals((long)2L, (long)commissions.size());
        GdsCommission hiddenFee = (GdsCommission)commissions.get(0);
        Assert.assertEquals((double)100.0, (double)hiddenFee.getEquivalentAmount().doubleValue(), (double)0.001);
        BigDecimal basis = BigDecimal.valueOf(200L);
        GdsCommission standardFee = (GdsCommission)commissions.get(1);
        Assert.assertEquals((double)BigDecimal.valueOf(2L).multiply(basis).divide(BigDecimal.valueOf(100L), 0, java.math.RoundingMode.UP).doubleValue(), (double)standardFee.getEquivalentAmount().doubleValue(), (double)0.001);
    }
}

