/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.rules;

import com.gridnine.xtrip.common.gds.model.FareInfo;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightFare;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.model.FlightSegmentTariff;
import com.gridnine.xtrip.common.gds.rules.GDSRulesEnvironment;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.AirlineReference;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.GeoLocationReference;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.rules.RulesEnvironment;
import com.gridnine.xtrip.server.model.test.ModelTestBase;
import java.math.BigDecimal;

abstract class GdsActionsTestBase
extends ModelTestBase {
    protected EntityReference<Organization> bsp = new EntityReference("BSP_container", Organization.class, "BSP");
    protected String departureCityCode = "MOW";
    protected String arrivalCityCode = "PAR";

    GdsActionsTestBase() {
    }

    protected void configureRulesEnvironment(RulesEnvironment re) {
        new GDSRulesEnvironment().environmentInitialized(re);
    }

    protected Flight createFlight() {
        Flight flight = new Flight();
        flight.setBlankOwner(this.bsp);
        flight.setEticket(true);
        flight.setGds(GdsName.SABRE);
        FlightFare fare = new FlightFare();
        fare.setBaseAmount(SystemHelper.getMoney((double)100.0, (String)"EUR"));
        fare.setPassengerType(DictHelper.getAdultPassengerType());
        fare.setEquivalentAmount(BigDecimal.valueOf(100L));
        flight.getFares().add(fare);
        FlightSegmentTariff fst = new FlightSegmentTariff();
        fst.setGds(GdsName.SABRE);
        flight.getSegmentTariffs().add(fst);
        FlightSegment fs = new FlightSegment();
        fst.getSegments().add(fs);
        fs.setAirline((DictionaryReference)new AirlineReference("SU"));
        fs.setBookingClass("N");
        fs.setFlightNumber("100");
        fs.setGds(GdsName.SABRE);
        fs.setLocationBegin((DictionaryReference)new GeoLocationReference(this.departureCityCode));
        fs.setLocationEnd((DictionaryReference)new GeoLocationReference(this.arrivalCityCode));
        fs.setStarting(true);
        FareInfo fi = new FareInfo();
        fi.setPassengerType(DictHelper.getAdultPassengerType());
        fi.setFareBasis("NFareBasis");
        fs.getFareInfos().add(fi);
        fst = new FlightSegmentTariff();
        fst.setGds(GdsName.SABRE);
        flight.getSegmentTariffs().add(fst);
        fs = new FlightSegment();
        fst.getSegments().add(fs);
        fs.setAirline((DictionaryReference)new AirlineReference("SU"));
        fs.setBookingClass("N");
        fs.setFlightNumber("101");
        fs.setGds(GdsName.SABRE);
        fs.setLocationBegin((DictionaryReference)new GeoLocationReference(this.arrivalCityCode));
        fs.setLocationEnd((DictionaryReference)new GeoLocationReference(this.departureCityCode));
        fi = new FareInfo();
        fi.setPassengerType(DictHelper.getAdultPassengerType());
        fi.setFareBasis("NFareBasis");
        fs.getFareInfos().add(fi);
        return flight;
    }
}

