/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.rules;

import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.CardGdsCommission;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightCommission;
import com.gridnine.xtrip.common.gds.model.FlightFare;
import com.gridnine.xtrip.common.gds.model.FlightTax;
import com.gridnine.xtrip.common.gds.model.GdsCommission;
import com.gridnine.xtrip.common.gds.model.GdsContractRelationData;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.Contractor;
import com.gridnine.xtrip.common.model.booking.CurrencyRate;
import com.gridnine.xtrip.common.model.booking.CurrencyRateType;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.SalesChain;
import com.gridnine.xtrip.common.model.booking.air.Commission;
import com.gridnine.xtrip.common.model.booking.commission.CalculationBasis;
import com.gridnine.xtrip.common.model.booking.commission.FeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.PaymentFeeCalculationBasis;
import com.gridnine.xtrip.common.model.booking.commission.PaymentFeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.RoundingMode;
import com.gridnine.xtrip.common.model.booking.commission.RoundingValue;
import com.gridnine.xtrip.common.model.dict.AirlineReference;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ContractCustomerInfo;
import com.gridnine.xtrip.common.model.profile.ContractRelationDescription;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.model.profile.PredefinedContractRelationType;
import com.gridnine.xtrip.common.model.profile.PredefinedSalesChainType;
import com.gridnine.xtrip.common.model.profile.SalesChainDescription;
import com.gridnine.xtrip.common.model.rules.standard.Actions;
import com.gridnine.xtrip.common.model.rules.standard.Conditions;
import com.gridnine.xtrip.common.model.rules.standard.MidofficeActions;
import com.gridnine.xtrip.common.model.rules.standard.Properties;
import com.gridnine.xtrip.common.model.rules.standard.RuleResultValue;
import com.gridnine.xtrip.common.model.rules.standard.Targets;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.rules.RuleRestriction;
import com.gridnine.xtrip.common.rules.RuleResult;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.elements.RuleAction;
import com.gridnine.xtrip.common.rules.elements.RuleCondition;
import com.gridnine.xtrip.common.rules.elements.RuleProperty;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.server.gds.rules.FlightCommissionsTestBase;
import com.gridnine.xtrip.server.gds.rules.proxy.FlightPropertySet;
import com.gridnine.xtrip.server.gds.rules.proxy.GDSParametersActions;
import com.gridnine.xtrip.server.storage.DictionaryStorage;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;

public class GdsContractRelationsTest
extends FlightCommissionsTestBase {
    private EntityReference<Organization> subagencyRef;
    private EntityReference<FeeProperties> feePropNotCharge;
    private EntityReference<FeeProperties> feePropCharge;
    private EntityReference<FeeProperties> feeSupplier;
    private EntityReference<FeeProperties> feeSupplierRate;
    private EntityReference<FeeProperties> feeClientFromVendorComm;
    private EntityReference<PaymentFeeProperties> paymentFeeCash;
    private EntityReference<PaymentFeeProperties> paymentFeeInvoice;

    @Test
    public void testGdsContractRelationDataAndSalesChain() throws Throwable {
        this.createProfiles();
        this.createCurrencyRate("RUB", "EUR", 50.0);
        this.createCurrencyRate("EUR", "RUB", 0.02);
        RuleSet ruleSet = this.createVendorRuleSet(12.0);
        this.createVendorContract(ruleSet);
        this.createContract(this.createSimpleRuleSet(20, this.feePropCharge, this.feePropNotCharge), (EntityReference<Organization>)this.agency, this.subagencyRef, ContractType.SUBAGENCY, "EUR", RoundingMode.MATH, RoundingValue.V_0_0_1);
        RuleSet clientRuleSet = this.createClientRuleSet();
        this.createContract(clientRuleSet, this.subagencyRef, (EntityReference<Organization>)this.client, ContractType.CLIENT, null, null, null);
        Flight flight = this.createFlight();
        SalesContext salesContext = this.createSalesContext();
        salesContext.setSubagency(this.subagencyRef);
        RuleProxy<FlightPropertySet, GDSParametersActions> proxy = this.createProxy(flight, salesContext);
        this.applyRules(flight, proxy, salesContext);
        SalesChain sc = flight.getSalesChain();
        Assert.assertNotNull((Object)sc);
        Assert.assertEquals((long)4L, (long)sc.getContractors().size());
        Assert.assertEquals((Object)this.client, (Object)((Contractor)sc.getContractors().get(3)).getContractor());
        Assert.assertEquals(this.subagencyRef, (Object)((Contractor)sc.getContractors().get(2)).getContractor());
        Assert.assertEquals((Object)this.agency, (Object)((Contractor)sc.getContractors().get(1)).getContractor());
        Assert.assertEquals((Object)this.bsp, (Object)((Contractor)sc.getContractors().get(0)).getContractor());
        SalesChainDescription scDesc = (SalesChainDescription)EntityStorage.get().resolve(sc.getDescription()).getEntity();
        Assert.assertEquals((Object)PredefinedSalesChainType.SUBAGENT, (Object)scDesc.getPredefinedType());
        Assert.assertNotNull((Object)flight.getContractRelations());
        Assert.assertEquals((long)3L, (long)flight.getContractRelations().size());
        List data = (List)flight.getContractRelations().get(DictHelper.getAdultPassengerType());
        Assert.assertEquals((long)3L, (long)data.size());
        GdsContractRelationData gdsData = (GdsContractRelationData)data.get(0);
        this.assertGdsContractRelationData(gdsData, PredefinedContractRelationType.SUPPLIER_TO_AGENCY, null, (EntityReference<Organization>)this.bsp, (EntityReference<Organization>)this.agency);
        Assert.assertEquals((double)100.0, (double)gdsData.getServiceData().getDetalization().getFare().doubleValue(), (double)0.0);
        Assert.assertEquals((long)1L, (long)gdsData.getServiceData().getDetalization().getTaxes().size());
        Assert.assertEquals((long)3L, (long)gdsData.getCommissions().size());
        Assert.assertEquals((double)42.0, (double)this.getCommissionsEqAmount(gdsData.getCommissions()), (double)0.0);
        gdsData = (GdsContractRelationData)data.get(1);
        this.assertGdsContractRelationData(gdsData, PredefinedContractRelationType.AGENCY_TO_SUBAGENCY, null, (EntityReference<Organization>)this.agency, this.subagencyRef);
        Assert.assertEquals((double)2.0, (double)gdsData.getServiceData().getDetalization().getFare().doubleValue(), (double)0.0);
        Assert.assertEquals((long)4L, (long)gdsData.getCommissions().size());
        Assert.assertEquals((double)1.6, (double)this.getCommissionsEqAmount(gdsData.getCommissions()), (double)0.0);
        gdsData = (GdsContractRelationData)data.get(2);
        this.assertGdsContractRelationData(gdsData, PredefinedContractRelationType.SUBAGENCY_TO_CLIENT, null, this.subagencyRef, (EntityReference<Organization>)this.client);
        Assert.assertEquals((double)100.0, (double)gdsData.getServiceData().getDetalization().getFare().doubleValue(), (double)0.0);
        for (GdsCommission comm : gdsData.getCommissions()) {
            Assert.assertNotNull((Object)comm.getCommissionProperties());
            Assert.assertEquals((Object)ContractType.CLIENT, (Object)comm.getContractType());
        }
        Assert.assertEquals((long)6L, (long)gdsData.getCommissions().size());
        Assert.assertEquals((double)110.6, (double)this.getCommissionsEqAmount(gdsData.getCommissions()), (double)0.0);
        data = (List)flight.getContractRelations().get(DictHelper.getChildPassengerType((int)5));
        Assert.assertEquals((long)3L, (long)data.size());
        gdsData = (GdsContractRelationData)data.get(0);
        this.assertGdsContractRelationData(gdsData, PredefinedContractRelationType.SUPPLIER_TO_AGENCY, null, (EntityReference<Organization>)this.bsp, (EntityReference<Organization>)this.agency);
        Assert.assertEquals((double)20.0, (double)gdsData.getServiceData().getDetalization().getFare().doubleValue(), (double)0.0);
        Assert.assertEquals((long)2L, (long)gdsData.getServiceData().getDetalization().getTaxes().size());
        gdsData = (GdsContractRelationData)data.get(1);
        this.assertGdsContractRelationData(gdsData, PredefinedContractRelationType.AGENCY_TO_SUBAGENCY, null, (EntityReference<Organization>)this.agency, this.subagencyRef);
        Assert.assertEquals((double)0.4, (double)gdsData.getServiceData().getDetalization().getFare().doubleValue(), (double)0.0);
        gdsData = (GdsContractRelationData)data.get(2);
        this.assertGdsContractRelationData(gdsData, PredefinedContractRelationType.SUBAGENCY_TO_CLIENT, null, this.subagencyRef, (EntityReference<Organization>)this.client);
        Assert.assertEquals((double)20.0, (double)gdsData.getServiceData().getDetalization().getFare().doubleValue(), (double)0.0);
        Assert.assertEquals((long)5L, (long)gdsData.getCommissions().size());
        data = (List)flight.getContractRelations().get(DictHelper.getChildPassengerType((int)7));
        Assert.assertEquals((long)3L, (long)data.size());
        gdsData = (GdsContractRelationData)data.get(0);
        this.assertGdsContractRelationData(gdsData, PredefinedContractRelationType.SUPPLIER_TO_AGENCY, null, (EntityReference<Organization>)this.bsp, (EntityReference<Organization>)this.agency);
        Assert.assertEquals((double)5.0, (double)gdsData.getServiceData().getDetalization().getFare().doubleValue(), (double)0.0);
        Assert.assertEquals((long)1L, (long)gdsData.getServiceData().getDetalization().getTaxes().size());
        this.testFlightHelperMethods(flight);
        this.testMergeRelations(flight);
    }

    private void testFlightHelperMethods(Flight flight) {
        Commission vendorCommission = FlightHelper.getTotalVendorCommission((Flight)flight, (DictionaryReference)DictHelper.getAdultPassengerType());
        Assert.assertEquals((double)12.0, (double)vendorCommission.getEquivalentAmount().doubleValue(), (double)0.0);
        Assert.assertEquals((double)12.0, (double)vendorCommission.getRate(), (double)0.0);
        HashMap<DictionaryReference, Integer> seats = new HashMap<DictionaryReference, Integer>();
        seats.put(DictHelper.getAdultPassengerType(), 3);
        seats.put(DictHelper.getChildPassengerType((int)5), 1);
        seats.put(DictHelper.getChildPassengerType((int)7), 1);
        Assert.assertEquals((double)39.0, (double)FlightHelper.getCommissionAmount((Flight)flight, (ContractType)ContractType.VENDOR, seats).doubleValue(), (double)0.0);
        Assert.assertEquals((long)9L, (long)FlightHelper.getGdsCommissions((Flight)flight, (ContractType)ContractType.VENDOR).size());
        Assert.assertEquals((long)3L, (long)GeneralProductHelper.filterCommissions((Collection)FlightHelper.getGdsCommissions((Flight)flight, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionPropertyTypes, null, null).size());
        Assert.assertEquals((long)3L, (long)FlightHelper.getGdsCommissions((Flight)flight, (ContractType)ContractType.VENDOR, (DictionaryReference)DictHelper.getChildPassengerType((int)5)).size());
        Assert.assertEquals((long)1L, (long)GeneralProductHelper.filterCommissions((Collection)FlightHelper.getGdsCommissions((Flight)flight, (ContractType)ContractType.VENDOR, (DictionaryReference)DictHelper.getChildPassengerType((int)5)), (Set)GeneralProductHelper.commissionPropertyTypes, null, null).size());
        Assert.assertEquals((long)16L, (long)FlightHelper.getFees((Flight)flight, (ContractType)ContractType.CLIENT).size());
        Collection oldFees = FlightHelper.getCardFees((Flight)flight, (ContractType)ContractType.CLIENT);
        Assert.assertEquals((long)16L, (long)oldFees.size());
        for (CardGdsCommission oldFee : oldFees) {
            Assert.assertNotNull((Object)oldFee.getPassengerType());
        }
        oldFees = FlightHelper.getCardCommissions((Flight)flight, (ContractType)ContractType.VENDOR, (Set)GeneralProductHelper.commissionPropertyTypes);
        Assert.assertEquals((long)3L, (long)oldFees.size());
        oldFees = FlightHelper.getCardCommissions((Flight)flight, (ContractType)ContractType.SUBAGENCY, (Set)GeneralProductHelper.commissionPropertyTypes);
        Assert.assertEquals((long)0L, (long)oldFees.size());
        Collection clientFees = FlightHelper.getFees((Flight)flight, (ContractType)ContractType.CLIENT, (DictionaryReference)DictHelper.getAdultPassengerType());
        Assert.assertEquals((long)6L, (long)clientFees.size());
        int cntClient = 0;
        int cntVendor = 0;
        int cntSubagency = 0;
        for (GdsCommission fee : clientFees) {
            if (FlightHelper.getContractType((GdsCommission)fee) == ContractType.SUBAGENCY) {
                ++cntSubagency;
            }
            if (FlightHelper.getContractType((GdsCommission)fee) == ContractType.VENDOR) {
                ++cntVendor;
            }
            if (FlightHelper.getContractType((GdsCommission)fee) != ContractType.CLIENT) continue;
            ++cntClient;
        }
        Assert.assertEquals((long)3L, (long)cntClient);
        Assert.assertEquals((long)2L, (long)cntVendor);
        Assert.assertEquals((long)1L, (long)cntSubagency);
    }

    private void testMergeRelations(Flight flight) throws Exception {
        Flight part = (Flight)XCloneHelper.clone((XCloneable)flight);
        List data = (List)part.getContractRelations().get(DictHelper.getAdultPassengerType());
        Assert.assertEquals((long)3L, (long)data.size());
        GdsContractRelationData gdsData = (GdsContractRelationData)data.get(0);
        gdsData.getServiceData().getDetalization().setFare(BigDecimal.valueOf(50.0));
        gdsData.getCommissions().remove(0);
        gdsData = (GdsContractRelationData)data.get(1);
        gdsData.getServiceData().getDetalization().setFare(BigDecimal.valueOf(1.0));
        gdsData.getCommissions().remove(0);
        gdsData = (GdsContractRelationData)data.get(2);
        gdsData.getServiceData().getDetalization().setFare(BigDecimal.valueOf(50L));
        gdsData.getCommissions().remove(0);
        gdsData.getCommissions().remove(0);
        gdsData.getServiceData().getDetalization().getTaxes().clear();
        Flight res = new Flight();
        FlightHelper.mergeContractRelations((Flight)res, (Flight)flight);
        FlightHelper.mergeContractRelations((Flight)res, (Flight)part);
        data = (List)res.getContractRelations().get(DictHelper.getAdultPassengerType());
        Assert.assertEquals((long)3L, (long)data.size());
        gdsData = (GdsContractRelationData)data.get(0);
        this.assertGdsContractRelationData(gdsData, PredefinedContractRelationType.SUPPLIER_TO_AGENCY, null, (EntityReference<Organization>)this.bsp, (EntityReference<Organization>)this.agency);
        Assert.assertEquals((double)150.0, (double)gdsData.getServiceData().getDetalization().getFare().doubleValue(), (double)0.0);
        Assert.assertEquals((long)2L, (long)gdsData.getServiceData().getDetalization().getTaxes().size());
        Assert.assertEquals((long)5L, (long)gdsData.getCommissions().size());
        gdsData = (GdsContractRelationData)data.get(1);
        this.assertGdsContractRelationData(gdsData, PredefinedContractRelationType.AGENCY_TO_SUBAGENCY, null, (EntityReference<Organization>)this.agency, this.subagencyRef);
        Assert.assertEquals((double)3.0, (double)gdsData.getServiceData().getDetalization().getFare().doubleValue(), (double)0.0);
        Assert.assertEquals((long)2L, (long)gdsData.getServiceData().getDetalization().getTaxes().size());
        Assert.assertEquals((long)7L, (long)gdsData.getCommissions().size());
        gdsData = (GdsContractRelationData)data.get(2);
        this.assertGdsContractRelationData(gdsData, PredefinedContractRelationType.SUBAGENCY_TO_CLIENT, null, this.subagencyRef, (EntityReference<Organization>)this.client);
        Assert.assertEquals((double)150.0, (double)gdsData.getServiceData().getDetalization().getFare().doubleValue(), (double)0.0);
        Assert.assertEquals((long)10L, (long)gdsData.getCommissions().size());
        Assert.assertEquals((long)1L, (long)gdsData.getServiceData().getDetalization().getTaxes().size());
        data = (List)res.getContractRelations().get(DictHelper.getChildPassengerType((int)5));
        Assert.assertEquals((long)3L, (long)data.size());
        gdsData = (GdsContractRelationData)data.get(0);
        this.assertGdsContractRelationData(gdsData, PredefinedContractRelationType.SUPPLIER_TO_AGENCY, null, (EntityReference<Organization>)this.bsp, (EntityReference<Organization>)this.agency);
        Assert.assertEquals((double)40.0, (double)gdsData.getServiceData().getDetalization().getFare().doubleValue(), (double)0.0);
        Assert.assertEquals((long)4L, (long)gdsData.getServiceData().getDetalization().getTaxes().size());
        gdsData = (GdsContractRelationData)data.get(1);
        this.assertGdsContractRelationData(gdsData, PredefinedContractRelationType.AGENCY_TO_SUBAGENCY, null, (EntityReference<Organization>)this.agency, this.subagencyRef);
        Assert.assertEquals((double)0.8, (double)gdsData.getServiceData().getDetalization().getFare().doubleValue(), (double)0.0);
        gdsData = (GdsContractRelationData)data.get(2);
        this.assertGdsContractRelationData(gdsData, PredefinedContractRelationType.SUBAGENCY_TO_CLIENT, null, this.subagencyRef, (EntityReference<Organization>)this.client);
        Assert.assertEquals((double)40.0, (double)gdsData.getServiceData().getDetalization().getFare().doubleValue(), (double)0.0);
        Assert.assertEquals((long)10L, (long)gdsData.getCommissions().size());
        data = (List)res.getContractRelations().get(DictHelper.getChildPassengerType((int)7));
        Assert.assertEquals((long)3L, (long)data.size());
        gdsData = (GdsContractRelationData)data.get(0);
        this.assertGdsContractRelationData(gdsData, PredefinedContractRelationType.SUPPLIER_TO_AGENCY, null, (EntityReference<Organization>)this.bsp, (EntityReference<Organization>)this.agency);
        Assert.assertEquals((double)10.0, (double)gdsData.getServiceData().getDetalization().getFare().doubleValue(), (double)0.0);
        Assert.assertEquals((long)2L, (long)gdsData.getServiceData().getDetalization().getTaxes().size());
    }

    @Override
    protected void createProfiles() throws Exception {
        this.createCommissionCategory();
        this.createCommissionProperties();
        this.feeProp = this.createFeeProperties(this.createCategory("feeProp").toReference(), true);
        this.feePropCharge = this.createFeeProperties(this.createCategory("feePropCharge").toReference(), true);
        this.feePropNotCharge = this.createFeeProperties(this.createCategory("feePropNotCharge").toReference(), false);
        this.feeSupplier = this.createFeeProperties(this.createCategory("feeSupplier").toReference(), true);
        this.feeSupplierRate = this.createFeeProperties(this.createCategory("feeSupplierRate").toReference(), true, true, CalculationBasis.FARE);
        this.feeClientFromVendorComm = this.createFeeProperties(this.createCategory("feeClientFromVendorComm").toReference(), true);
        this.paymentFeeCash = this.createPaymentFeeProperties(PaymentType.CASH, false, null, "paymentFeeCash");
        this.paymentFeeInvoice = this.createPaymentFeeProperties(PaymentType.INVOICE, true, PaymentFeeCalculationBasis.PRICE_AND_FEES, "paymentFeeInvoice");
        this.bsp = this.createOrganization("BSP", "BSP_container", OrganizationType.BLANK_OWNER).toReference();
        this.agency = this.createOrganization("003", "Agency", OrganizationType.AGENCY).toReference();
        this.subagencyRef = this.createOrganization("002", "Subagency", OrganizationType.AGENCY, (EntityReference<Organization>)this.agency).toReference();
        this.client = this.createOrganization("001", "Client", OrganizationType.CORPORATE_CLIENT, this.subagencyRef).toReference();
        this.carrier = new AirlineReference("A1");
        this.createSalesPoint();
        this.createAgent();
    }

    @Override
    protected RuleSet createVendorRuleSet(double value) {
        RuleSet ruleSet = super.createVendorRuleSet(value);
        RuleSettings rs = new RuleSettings();
        rs.setName("A1-10");
        rs.setTarget((RuleTarget)Targets.PRODUCT_COMMISSION);
        RuleResult res = new RuleResult();
        res.setAction((RuleAction)Actions.SIMPLE_FEE);
        RuleResultValue rrValue = new RuleResultValue();
        rrValue.setCurrencyCode("RUB");
        rrValue.setTarget(this.feeSupplier);
        rrValue.setValue(10.0);
        res.setValue((Object)rrValue);
        rs.getResults().add(res);
        res = new RuleResult();
        res.setAction((RuleAction)Actions.SIMPLE_FEE);
        rrValue = new RuleResultValue();
        rrValue.setCurrencyCode("RUB");
        rrValue.setTarget(this.paymentFeeCash);
        rrValue.setValue(5.0);
        res.setValue((Object)rrValue);
        rs.getResults().add(res);
        ruleSet.getRules().add(rs);
        rs = new RuleSettings();
        rs.setName("A1-20");
        rs.setTarget((RuleTarget)Targets.PRODUCT_COMMISSION);
        RuleResultValue rrv = new RuleResultValue();
        rrv.setTarget(this.commProp);
        rrv.setCurrencyCode("%");
        rrv.setValue(value);
        RuleResult res2 = new RuleResult();
        res2.setAction((RuleAction)Actions.SIMPLE_COMMISSION);
        res2.setValue((Object)rrv);
        rs.getResults().add(res2);
        ruleSet.getRules().add(rs);
        rs = new RuleSettings();
        rs.setName("A1-30");
        rs.setTarget((RuleTarget)Targets.PRODUCT_COMMISSION);
        rrv = new RuleResultValue();
        rrv.setTarget(this.feeSupplierRate);
        rrv.setCurrencyCode("%");
        rrv.setValue(20.0);
        res2 = new RuleResult();
        res2.setAction((RuleAction)Actions.SIMPLE_FEE);
        res2.setValue((Object)rrv);
        rs.getResults().add(res2);
        ruleSet.getRules().add(rs);
        return ruleSet;
    }

    private RuleSet createClientRuleSet() {
        RuleSet clientRuleSet = this.createSimpleRuleSet(40, this.feeProp);
        RuleResult res = new RuleResult();
        res.setAction((RuleAction)MidofficeActions.ALLOWED_PAYMENT_TYPES);
        res.setValue((Object)new PaymentType[]{PaymentType.INVOICE});
        ((RuleSettings)clientRuleSet.getRules().get(0)).getResults().add(res);
        res = new RuleResult();
        res.setAction((RuleAction)Actions.SIMPLE_FEE);
        RuleResultValue rrValue = new RuleResultValue();
        rrValue.setCurrencyCode("%");
        rrValue.setTarget(this.paymentFeeInvoice);
        rrValue.setValue(10.0);
        res.setValue((Object)rrValue);
        ((RuleSettings)clientRuleSet.getRules().get(0)).getResults().add(res);
        RuleSettings rs = new RuleSettings();
        rs.setName("Vendor Comm");
        rs.setTarget((RuleTarget)Targets.PRODUCT_COMMISSION);
        RuleRestriction rr = new RuleRestriction();
        rr.setCondition((RuleCondition)Conditions.EQUALS);
        rr.setProperty((RuleProperty)Properties.VENDOR_COMMISSION_VALUE);
        rr.setValue((Object)12.0);
        rs.getRestrictions().add(rr);
        RuleResultValue rrv = new RuleResultValue();
        rrv.setTarget(this.feeClientFromVendorComm);
        rrv.setCurrencyCode("RUB");
        rrv.setValue(1.0);
        RuleResult res2 = new RuleResult();
        res2.setAction((RuleAction)Actions.SIMPLE_FEE);
        res2.setValue((Object)rrv);
        rs.getResults().add(res2);
        clientRuleSet.getRules().add(0, rs);
        return clientRuleSet;
    }

    private int calcCommissionCount(ContractType cType, List<FlightCommission> commissions) {
        int res = 0;
        for (FlightCommission fc : commissions) {
            if (!fc.getContractType().equals((Object)cType)) continue;
            ++res;
        }
        return res;
    }

    private double getCommissionsEqAmount(List<GdsCommission> commissions) {
        BigDecimal res = BigDecimal.ZERO;
        for (GdsCommission comm : commissions) {
            res = res.add(comm.getEquivalentAmount());
        }
        return res.doubleValue();
    }

    private void createCurrencyRate(String baseCur, String cur, double rateValue) throws Exception {
        CurrencyRate rate = new CurrencyRate();
        rate.setBaseCurrency(baseCur);
        rate.setCurrency(cur);
        rate.setDate(new Date());
        rate.setRate(rateValue);
        rate.setTariffType(TariffType.REGULAR);
        rate.setType(CurrencyRateType.IATA);
        DictionaryStorage.get().save((BaseDictionary)rate);
    }

    private void assertGdsContractRelationData(GdsContractRelationData gdsData, PredefinedContractRelationType type, String currencyCode, EntityReference<Organization> supplierRef, EntityReference<Organization> customerRef) {
        ContractRelationDescription desc = (ContractRelationDescription)EntityStorage.get().resolve(gdsData.getDescription()).getEntity();
        Assert.assertEquals((Object)type, (Object)desc.getPredefinedType());
        Assert.assertNotNull((Object)gdsData.getGeneralData().getContract());
        EntityStorageContext ctx = new EntityStorageContext();
        ContractCustomerInfo info = (ContractCustomerInfo)EntityStorageHelper.resolve((NestedEntityReference)gdsData.getGeneralData().getContract(), (EntityStorageContext)ctx);
        Assert.assertEquals(customerRef, (Object)info.getCustomer());
        Contract contract = (Contract)EntityStorageHelper.findParentEntity((BaseEntity)info, Contract.class, (EntityStorageContext)ctx);
        Assert.assertEquals(supplierRef, (Object)contract.getSupplier());
    }

    @Override
    protected Flight createFlight() {
        Flight flight = super.createFlight("RUB");
        FlightFare fare = new FlightFare();
        fare.setBaseAmount(SystemHelper.getMoney((double)20.0, (String)"RUB"));
        fare.setPassengerType(DictHelper.getChildPassengerType((int)5));
        fare.setEquivalentAmount(BigDecimal.valueOf(20L));
        flight.getFares().add(fare);
        fare = new FlightFare();
        fare.setBaseAmount(SystemHelper.getMoney((double)5.0, (String)"RUB"));
        fare.setPassengerType(DictHelper.getChildPassengerType((int)7));
        fare.setEquivalentAmount(BigDecimal.valueOf(5L));
        flight.getFares().add(fare);
        flight.getTaxes().add(this.createTax((DictionaryReference<PassengerType>)DictHelper.getAdultPassengerType(), 5, "ADTAX"));
        flight.getTaxes().add(this.createTax((DictionaryReference<PassengerType>)DictHelper.getChildPassengerType((int)5), 2, "CODE1"));
        flight.getTaxes().add(this.createTax((DictionaryReference<PassengerType>)DictHelper.getChildPassengerType((int)5), 1, "CODE2"));
        flight.getTaxes().add(this.createTax((DictionaryReference<PassengerType>)DictHelper.getChildPassengerType((int)7), 6, "CODE1"));
        return flight;
    }

    private FlightTax createTax(DictionaryReference<PassengerType> passType, int amount, String code) {
        FlightTax tax = new FlightTax();
        tax.setBaseAmount(SystemHelper.getMoney((double)amount, (String)"RUB"));
        tax.setCode(code);
        tax.setPassengerType(passType);
        tax.setEquivalentAmount(new BigDecimal(amount));
        return tax;
    }
}

