/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.rules;

import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.GdsCommission;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.CurrencyRate;
import com.gridnine.xtrip.common.model.booking.CurrencyRateType;
import com.gridnine.xtrip.common.model.booking.commission.CalculationType;
import com.gridnine.xtrip.common.model.booking.commission.Operation;
import com.gridnine.xtrip.common.model.booking.commission.RoundingMode;
import com.gridnine.xtrip.common.model.booking.commission.RoundingValue;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.server.gds.rules.FlightCommissionsTestBase;
import com.gridnine.xtrip.server.gds.test.TestFlightBuilder;
import com.gridnine.xtrip.server.model.test.TestCommissionCategoryBuilder;
import com.gridnine.xtrip.server.model.test.TestContractBuilderBuilder;
import com.gridnine.xtrip.server.model.test.TestCurrencyRateBuilder;
import com.gridnine.xtrip.server.model.test.TestFeePropertiesBuilder;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import org.junit.Assert;
import org.junit.Test;

public class MulticurrencyFeeConversionTest
extends FlightCommissionsTestBase {
    @Test
    public void testConversion() throws Throwable {
        DictHelper.invalidateCurrencySuperCache();
        this.createProfiles();
        new TestCurrencyRateBuilder("EUR", "RUB", 0.0125, CurrencyRateType.IATA, "2016-01-01").create();
        EntityReference agencyFee = new TestFeePropertiesBuilder().displayName("Agency Fee").calculationType(CalculationType.TICKET).calculationType(Operation.SELL).chargeToClient(true).category(((TestCommissionCategoryBuilder)((TestCommissionCategoryBuilder)new TestCommissionCategoryBuilder().code("cat1")).translation("Agency Fee")).create()).create().toReference();
        EntityReference subagencyFee = new TestFeePropertiesBuilder().displayName("Agency Fee").calculationType(CalculationType.TICKET).calculationType(Operation.SELL).category(((TestCommissionCategoryBuilder)((TestCommissionCategoryBuilder)new TestCommissionCategoryBuilder().code("cat1")).translation("Agency Fee")).create()).create().toReference();
        new TestContractBuilderBuilder().contractType(ContractType.SUBAGENCY).name("Subagency contract").supplier(this.agency).customer(this.subagency).airFee(100.0, "RUB", agencyFee).create();
        new TestContractBuilderBuilder().contractType(ContractType.CLIENT).name("Client contract").supplier(this.subagency).customer().customer(this.client).paymentCurrency("EUR", CurrencyRateType.IATA, RoundingMode.MATH, RoundingValue.V_1).end().airFee(2.0, "EUR", subagencyFee).create();
        Flight flight = new TestFlightBuilder().blankOwner(this.bsp).agency(this.agency).subagency(this.subagency).fare(100.0, DictHelper.getAdultPassengerType()).getEntity();
        this.applyRules(flight);
        ArrayList commissions = new ArrayList(FlightHelper.getContractRelation((Flight)flight, (ContractType)ContractType.CLIENT, (DictionaryReference)DictHelper.getAdultPassengerType()).getCommissions());
        Assert.assertEquals((long)2L, (long)commissions.size());
        CurrencyRate currencyRate = DictHelper.findExactCurrencyRate((String)"RUB", (String)"EUR", (Date)new Date(), (CurrencyRateType)CurrencyRateType.IATA, null, null);
        if (currencyRate == null) {
            System.out.println("currency rate is null");
        } else {
            System.out.println(String.format("rate = %s, date = %s", Double.toString(currencyRate.getRate()), currencyRate.getDate()));
        }
        GdsCommission comm = (GdsCommission)commissions.get(0);
        Assert.assertEquals((double)100.0, (double)comm.getAmount().getValue().doubleValue(), (double)0.001);
        Assert.assertEquals((Object)"RUB", (Object)comm.getAmount().getCurrency());
        Assert.assertEquals((double)1.0, (double)comm.getEquivalentAmount().doubleValue(), (double)0.001);
        BigDecimal fare = FlightHelper.getEquivalentFareOfClientRelation((Flight)flight, (DictionaryReference)DictHelper.getAdultPassengerType());
        Assert.assertEquals((double)1.0, (double)fare.doubleValue(), (double)0.001);
    }

    @Override
    protected SalesContext createSalesContext() {
        SalesContext result = super.createSalesContext();
        result.setSubagency(this.subagency);
        return result;
    }
}

