/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.rules;

import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.GdsCommission;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.commission.CalculationBasis;
import com.gridnine.xtrip.common.model.booking.commission.CalculationType;
import com.gridnine.xtrip.common.model.booking.commission.Operation;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.commission.RoundingMode;
import com.gridnine.xtrip.common.model.booking.commission.RoundingValue;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.server.gds.rules.FlightCommissionsTestBase;
import com.gridnine.xtrip.server.gds.test.TestFlightBuilder;
import com.gridnine.xtrip.server.model.test.TestCommissionCategoryBuilder;
import com.gridnine.xtrip.server.model.test.TestContractBuilderBuilder;
import com.gridnine.xtrip.server.model.test.TestFeePropertiesBuilder;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class ProductTypeFeesTest
extends FlightCommissionsTestBase {
    @Test
    public void testProductTypes() throws Throwable {
        this.createProfiles();
        DictionaryReference cat1Ref = ((TestCommissionCategoryBuilder)((TestCommissionCategoryBuilder)new TestCommissionCategoryBuilder().code("cat1")).translation("Category 1")).create();
        DictionaryReference cat2Ref = ((TestCommissionCategoryBuilder)((TestCommissionCategoryBuilder)new TestCommissionCategoryBuilder().code("cat 2")).translation("Category 2")).create();
        EntityReference fee1Prop = new TestFeePropertiesBuilder().displayName("Fee 1").calculationType(CalculationType.TICKET).basis(CalculationBasis.TOTAL).roundingMode(RoundingMode.UP).roundingValue(RoundingValue.V_1).calculationType(Operation.SELL).category(cat1Ref).productTypes(new ProductType[]{ProductType.AEROEXPRESS}).create().toReference();
        EntityReference fee2Prop = new TestFeePropertiesBuilder().displayName("Fee 2").calculationType(CalculationType.TICKET).basis(CalculationBasis.TOTAL).roundingMode(RoundingMode.UP).roundingValue(RoundingValue.V_1).calculationType(Operation.SELL).category(cat2Ref).productTypes(new ProductType[]{ProductType.AIR_TICKET}).create().toReference();
        new TestContractBuilderBuilder().contractType(ContractType.CLIENT).name("Client Contract").supplier(this.agency).customer(this.client).airFee(2.0, "%", fee1Prop).airFee(2.0, "%", fee2Prop).create();
        Flight flight = new TestFlightBuilder().blankOwner(this.bsp).fare(100.0, DictHelper.getAdultPassengerType()).getEntity();
        this.applyRules(flight);
        List commissions = FlightHelper.getContractRelation((Flight)flight, (ContractType)ContractType.CLIENT, (DictionaryReference)DictHelper.getAdultPassengerType()).getCommissions();
        Assert.assertEquals((long)1L, (long)commissions.size());
        Assert.assertEquals((Object)fee2Prop, (Object)((GdsCommission)commissions.get(0)).getCommissionProperties());
    }
}

