/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.rules;

import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.model.FlightSegmentTariff;
import com.gridnine.xtrip.common.gds.rules.Actions;
import com.gridnine.xtrip.common.gds.rules.Conditions;
import com.gridnine.xtrip.common.gds.rules.ConnectionRestrictionValue;
import com.gridnine.xtrip.common.gds.rules.Properties;
import com.gridnine.xtrip.common.gds.rules.Targets;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocationReference;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.rules.RuleEngine;
import com.gridnine.xtrip.common.rules.RuleRestriction;
import com.gridnine.xtrip.common.rules.RuleResult;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.elements.RuleAction;
import com.gridnine.xtrip.common.rules.elements.RuleCondition;
import com.gridnine.xtrip.common.rules.elements.RuleProperty;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;
import com.gridnine.xtrip.server.gds.rules.GdsActionsTestBase;
import com.gridnine.xtrip.server.gds.rules.proxy.FlightPropertySet;
import com.gridnine.xtrip.server.gds.rules.proxy.GDSParametersActions;
import java.util.Collections;
import java.util.Date;
import org.junit.Assert;
import org.junit.Test;

public class Sua95Test
extends GdsActionsTestBase {
    @Test
    public void testDifferentAirports() throws Exception {
        Assert.assertTrue((boolean)this.applyRules(this.createFlight("airport DME", "SVO", 60), Conditions.CONNECTION_WITH_DIFFERENT_AIRPORTS, null, 0));
        Assert.assertFalse((boolean)this.applyRules(this.createFlight("airport DME", "airport DME", 60), Conditions.CONNECTION_WITH_DIFFERENT_AIRPORTS, null, 0));
        Assert.assertTrue((boolean)this.applyRules(this.createFlight("airport DME", "airport DME", 30), Conditions.CONNECTION_TIME_RESTRICTED, "DME", 60));
        Assert.assertFalse((boolean)this.applyRules(this.createFlight("airport DME", "airport DME", 60), Conditions.CONNECTION_TIME_RESTRICTED, "DME", 30));
        Assert.assertFalse((boolean)this.applyRules(this.createFlight("SVO", "SVO", 30), Conditions.CONNECTION_TIME_RESTRICTED, "DME", 60));
        Assert.assertTrue((boolean)this.applyRules(this.createFlight("SVO", "SVO", 30), Conditions.CONNECTION_TIME_RESTRICTED, "*", 60));
    }

    private Flight createFlight(String code1, String code2, int connectionTime) {
        Flight flight = this.createFlight();
        Date currentDate = new Date();
        FlightSegment seg = (FlightSegment)((FlightSegmentTariff)flight.getSegmentTariffs().get(0)).getSegments().get(0);
        seg.setStarting(true);
        seg.setDateBegin(currentDate);
        seg.setDateEnd(currentDate);
        seg.setLocationEnd((DictionaryReference)new GeoLocationReference(code1));
        seg = (FlightSegment)((FlightSegmentTariff)flight.getSegmentTariffs().get(1)).getSegments().get(0);
        seg.setStarting(false);
        seg.setDateBegin(new Date(currentDate.getTime() + (long)(connectionTime * 60) * 1000L));
        seg.setLocationBegin((DictionaryReference)new GeoLocationReference(code2));
        return flight;
    }

    private boolean applyRules(Flight flight, Conditions cond, String airportCode, int maxConnectionTime) throws Exception {
        RuleSet rs = new RuleSet();
        RuleSettings settings = new RuleSettings();
        settings.setTarget((RuleTarget)Targets.GDS_PARAMETERS_EX);
        rs.getRules().add(settings);
        RuleRestriction restr = new RuleRestriction();
        restr.setProperty((RuleProperty)Properties.CONNECTION_TIME);
        restr.setCondition((RuleCondition)cond);
        ConnectionRestrictionValue value = null;
        if (airportCode != null) {
            value = new ConnectionRestrictionValue();
            value.setMinConnectionTimeInMinutes(maxConnectionTime);
            value.getAirportCodes().add(airportCode);
        }
        restr.setValue(value);
        settings.getRestrictions().add(restr);
        RuleResult res = new RuleResult();
        res.setAction((RuleAction)Actions.EXCLUDE_FROM_RESULT);
        settings.getResults().add(res);
        RuleProxy proxy = new RuleProxy();
        FlightPropertySet ps = FlightPropertySet.create(flight, (DictionaryReference<PassengerType>)DictHelper.getAdultPassengerType(), PaymentType.INVOICE, "testPcc", proxy, new SalesContext());
        GDSParametersActions as = new GDSParametersActions();
        proxy.setActionSet((Object)as);
        proxy.setPropertySet((Object)ps);
        proxy.setProxyDate(new Date());
        proxy.setProxyType(Targets.GDS_PARAMETERS_EX.getId());
        RuleEngine.applyRules(Collections.singletonList(proxy), (RuleSet)rs);
        return as.isExcludeFromResult();
    }
}

