/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.rules;

import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.server.gds.rules.FlightCommissionsLightweightTestBase;
import com.gridnine.xtrip.server.gds.rules.proxy.FlightCommissionActionSet;
import com.gridnine.xtrip.server.gds.rules.proxy.FlightPropertySet;
import com.gridnine.xtrip.server.gds.test.TestFlightBuilder;
import org.junit.Assert;
import org.junit.Test;

public class VIP34604Test
extends FlightCommissionsLightweightTestBase {
    @Test
    public void testDepartureLocation() throws Exception {
        Flight flight = this.createFlight("airport DME", "LED");
        RuleProxy<FlightPropertySet, FlightCommissionActionSet> proxy = this.createProxy(flight);
        Assert.assertTrue((boolean)((FlightPropertySet)((Object)proxy.getPropertySet())).getDepartureLocations().contains("DME"));
        Assert.assertTrue((boolean)((FlightPropertySet)((Object)proxy.getPropertySet())).getDepartureLocations().contains("MOW"));
    }

    @Test
    public void testArrivalLocation() throws Exception {
        Flight flight = this.createFlight("LED", "airport DME");
        RuleProxy<FlightPropertySet, FlightCommissionActionSet> proxy = this.createProxy(flight);
        Assert.assertTrue((boolean)((FlightPropertySet)((Object)proxy.getPropertySet())).getArrivalLocations().contains("DME"));
        Assert.assertTrue((boolean)((FlightPropertySet)((Object)proxy.getPropertySet())).getArrivalLocations().contains("MOW"));
    }

    @Test
    public void getAllLocations() throws Exception {
        Flight flight = this.createFlight("LED", "airport DME");
        RuleProxy<FlightPropertySet, FlightCommissionActionSet> proxy = this.createProxy(flight);
        Assert.assertTrue((boolean)((FlightPropertySet)((Object)proxy.getPropertySet())).getAllLocations().contains("DME"));
        Assert.assertTrue((boolean)((FlightPropertySet)((Object)proxy.getPropertySet())).getAllLocations().contains("MOW"));
        Assert.assertTrue((boolean)((FlightPropertySet)((Object)proxy.getPropertySet())).getAllLocations().contains("LED"));
    }

    private Flight createFlight(String start, String end) {
        return new TestFlightBuilder().segmentTariff().segment().locationBegin(start).locationEnd(end).end().end().segmentTariff().segment().locationBegin(end).locationEnd(start).end().end().getEntity();
    }
}

