/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.rules;

import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.model.rules.standard.Conditions;
import com.gridnine.xtrip.common.model.rules.standard.Properties;
import com.gridnine.xtrip.common.model.rules.standard.RouteSegmentsRestriction;
import com.gridnine.xtrip.common.rules.RuleRestriction;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.elements.RuleCondition;
import com.gridnine.xtrip.common.rules.elements.RuleProperty;
import com.gridnine.xtrip.server.gds.rules.FlightCommissionsTestBase;
import java.util.Collection;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;

public class Vip9000Test
extends FlightCommissionsTestBase {
    @Test
    public void testSegmentRestriction() throws Throwable {
        this.createProfiles();
        EntityContainer<Organization> subagencyCtr = this.createOrganization("0033", "subAgency", OrganizationType.AGENCY);
        EntityContainer orgCtr = EntityStorage.get().resolve(this.client);
        ((Organization)orgCtr.getEntity()).setParent(subagencyCtr.toReference());
        EntityStorage.get().save(orgCtr, false);
        ((Organization)subagencyCtr.getEntity()).setParent(this.agency);
        EntityStorage.get().save(subagencyCtr, false);
        RuleSet vendorRuleSet = this.createVendorRuleSet(3.0);
        RuleSettings ruleSettings = (RuleSettings)vendorRuleSet.getRules().get(0);
        ruleSettings.getRestrictions().clear();
        RuleRestriction restr = new RuleRestriction();
        ruleSettings.getRestrictions().add(restr);
        restr.setProperty((RuleProperty)Properties.ROUTE_SEGMENTS_RESTRICTION);
        restr.setCondition((RuleCondition)Conditions.CONTAINS_ONLY);
        RouteSegmentsRestriction restrValue = new RouteSegmentsRestriction();
        restr.setValue((Object)restrValue);
        RouteSegmentsRestriction.ComplexSegmentRestriction segRestr = new RouteSegmentsRestriction.ComplexSegmentRestriction();
        segRestr.setSegmentsCountPattern(new RouteSegmentsRestriction.SegmentsCountRestriction(1, 1));
        RouteSegmentsRestriction.GeoLocationPattern startPattern = new RouteSegmentsRestriction.GeoLocationPattern();
        startPattern.getCodes().add(new RouteSegmentsRestriction.GeoLocationCode(false, "MOW"));
        RouteSegmentsRestriction.GeoLocationPattern endPattern = new RouteSegmentsRestriction.GeoLocationPattern();
        endPattern.getCodes().add(new RouteSegmentsRestriction.GeoLocationCode(false, "PAR"));
        segRestr.getRoutes().add(new RouteSegmentsRestriction.GeoLocationPair(startPattern, endPattern));
        restrValue.getRestrictions().add(segRestr);
        segRestr = new RouteSegmentsRestriction.ComplexSegmentRestriction();
        segRestr.setSegmentsCountPattern(new RouteSegmentsRestriction.SegmentsCountRestriction(1, 1));
        startPattern = new RouteSegmentsRestriction.GeoLocationPattern();
        startPattern.getCodes().add(new RouteSegmentsRestriction.GeoLocationCode(false, "PAR"));
        endPattern = new RouteSegmentsRestriction.GeoLocationPattern();
        endPattern.getCodes().add(new RouteSegmentsRestriction.GeoLocationCode(false, "MOW"));
        segRestr.getRoutes().add(new RouteSegmentsRestriction.GeoLocationPair(startPattern, endPattern));
        restrValue.getRestrictions().add(segRestr);
        this.createVendorContract(vendorRuleSet);
        Flight flight = this.createFlight();
        this.applyRules(flight);
        Assert.assertEquals((long)1L, (long)GeneralProductHelper.filterCommissions((Collection)FlightHelper.getGdsCommissions((Flight)flight, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionPropertyTypes, null, null).size());
    }
}

