/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.rules.proxy;

import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.GdsCommission;
import com.gridnine.xtrip.common.gds.model.GdsContractRelationData;
import com.gridnine.xtrip.common.gds.rules.FlightActionsProvider;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseContractRelationData;
import com.gridnine.xtrip.common.model.booking.CurrencyRate;
import com.gridnine.xtrip.common.model.booking.CurrencyRateType;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.SimpleTax;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.air.Commission;
import com.gridnine.xtrip.common.model.booking.commission.BaseCommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.CalculationBasis;
import com.gridnine.xtrip.common.model.booking.commission.CommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.DiscountProperties;
import com.gridnine.xtrip.common.model.booking.commission.FeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.Operation;
import com.gridnine.xtrip.common.model.booking.commission.PaymentFeeCalculationBasis;
import com.gridnine.xtrip.common.model.booking.commission.PaymentFeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.PaymentFeeType;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.commission.RoundingMode;
import com.gridnine.xtrip.common.model.booking.commission.RoundingValue;
import com.gridnine.xtrip.common.model.booking.commission.RouteType;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.FinanceHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.MulticurrencyHelper;
import com.gridnine.xtrip.common.model.profile.ExchangeRateData;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.model.rules.standard.TechnicalFeeActionsProvider;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.NamedValue;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.validation.StandartValidationMessageType;
import com.gridnine.xtrip.common.model.validation.ValidationMessageHelper;
import com.gridnine.xtrip.common.model.validation.ValidationMessageType;
import com.gridnine.xtrip.common.rules.elements.RuleLogTracer;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.ValueHolder;
import com.gridnine.xtrip.server.gds.rules.proxy.FlightPropertySet;
import com.gridnine.xtrip.server.model.handlers.AirRulesProductHandler;
import com.gridnine.xtrip.server.model.handlers.BaseAirPropertySet;
import com.gridnine.xtrip.server.model.handlers.BaseCommissionActionSet;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class FlightCommissionActionSet
extends BaseCommissionActionSet
implements FlightActionsProvider,
TechnicalFeeActionsProvider {
    private static final long serialVersionUID = 1931014852152742636L;
    private final Flight flight;
    private final DictionaryReference<PassengerType> passengerType;
    private GdsContractRelationData currentContractRelation;

    public FlightCommissionActionSet(RuleProxy<?, ?> px, FlightPropertySet propSet, DictionaryReference<PassengerType> pt) {
        super(px, (BaseAirPropertySet)propSet);
        this.passengerType = pt;
        this.flight = propSet.getFlight();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean accept(FeeProperties feeProp) {
        RuleLogTracer tracer = this.getProxy().getTracer();
        tracer.traceEnteringMethod(FlightCommissionActionSet.class, "accept()", new String[0]);
        try {
            ProductType productType = AirProductHelper.getProductType((ProductCategory)(this.flight.getMcoCategory() == null ? ProductCategory.AIR : ProductCategory.MCO), (MCOCategory)this.flight.getMcoCategory());
            if (!feeProp.getProductTypes().isEmpty() && !feeProp.getProductTypes().contains(productType)) {
                tracer.traceLogic(String.format("fee properites %s does not apply to %s productType, returning false", productType, feeProp));
                boolean bl = false;
                return bl;
            }
            if (!feeProp.getRouteTypes().isEmpty()) {
                if (this.getPropertySet().isOneWayTicket() && !feeProp.getRouteTypes().contains(RouteType.ONE_WAY)) {
                    tracer.traceLogic("ticket is a one way ticket, but route types does not contain ONE_WAY, returning false");
                    boolean bl = false;
                    return bl;
                }
                if (!this.getPropertySet().isOneWayTicket() && !feeProp.getRouteTypes().contains(RouteType.ROUND_TRIP)) {
                    tracer.traceLogic("ticket is a round trip ticket, but route types does not contain ROUND_TRIP, returning false");
                    boolean bl = false;
                    return bl;
                }
            }
            boolean bl = feeProp.getOperation() == null || feeProp.getOperation() == Operation.SELL;
            return bl;
        }
        finally {
            tracer.traceExitingMethod(FlightCommissionActionSet.class, "accept()", new String[0]);
        }
    }

    protected boolean accept(DiscountProperties discountProp) {
        return discountProp.getOperation() == null || discountProp.getOperation() == Operation.SELL;
    }

    protected boolean accept(CommissionProperties commProp) {
        RuleLogTracer tracer = this.getProxy().getTracer();
        ProductType productType = AirProductHelper.getProductType((ProductCategory)(this.flight.getMcoCategory() == null ? ProductCategory.AIR : ProductCategory.MCO), (MCOCategory)this.flight.getMcoCategory());
        if (!commProp.getProductTypes().isEmpty() && !commProp.getProductTypes().contains(productType)) {
            tracer.traceLogic(String.format("commission properties %s does not apply to %s productType, returning false", productType, commProp));
            return false;
        }
        return commProp.getOperation() == null || commProp.getOperation() == Operation.SELL;
    }

    protected void fixFeeRate(Commission commission, FeeProperties feeProp) {
    }

    protected BigDecimal updateRuleValueWithVatRate(BigDecimal value, Commission commission, BaseCommissionProperties properties) {
        return value;
    }

    protected void updateAmountWithVatRate(Commission commission, BaseCommissionProperties properties) {
    }

    protected BigDecimal getCurrencyRate(String currencyCode, boolean feeForRefund, Collection<ValidationMessage> messages) {
        return this.getCurrencyRate(null, currencyCode, false, messages);
    }

    protected BigDecimal getCurrencyRate(String baseCurrencyCode, String currencyCode, boolean feeForRefund, Collection<ValidationMessage> messages) {
        TariffType tariffType;
        CurrencyRateType currencyRateType;
        Date issueDate;
        String equivalentCurrencyCode = baseCurrencyCode == null ? DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, null) : baseCurrencyCode;
        CurrencyRate currencyRate = BookingHelper.findCurrencyRate((String)equivalentCurrencyCode, (String)currencyCode, (Date)(issueDate = new Date()), (CurrencyRateType)(currencyRateType = FinanceHelper.getCurrencyRateType((String)equivalentCurrencyCode)), (TariffType)(tariffType = (TariffType)CollectionUtil.findEnumConstant(TariffType.class, (String)this.getPropertySet().getTariffType())), null, null);
        if (currencyRate != null) {
            return BigDecimal.valueOf(currencyRate.getRate());
        }
        currencyRate = BookingHelper.findCurrencyRate((String)currencyCode, (String)equivalentCurrencyCode, (Date)issueDate, (CurrencyRateType)currencyRateType, (TariffType)tariffType, null, null);
        if (currencyRate != null) {
            return BigDecimal.ONE.divide(BigDecimal.valueOf(currencyRate.getRate()), 10, java.math.RoundingMode.HALF_UP);
        }
        messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.FCAS_CURRENCY_RATE_IS_1));
        return BigDecimal.ONE;
    }

    public List<GdsCommission> createCommissions(GdsContractRelationData contractRelation, List<GdsContractRelationData> allContractRelations, Set<PaymentType> paymentTypes, ExchangeRateData rateData, Collection<ValidationMessage> messages, boolean translateSupplierFees) throws Exception {
        GdsCommission comm2;
        this.currentContractRelation = contractRelation;
        ArrayList<GdsCommission> result = new ArrayList<GdsCommission>();
        String currencyCode = contractRelation.getGeneralData().getCurrency() == null ? DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, (String)"RUB") : contractRelation.getGeneralData().getCurrency().getCode();
        ContractType cType = GeneralProductHelper.getContractType((EntityReference)contractRelation.getDescription());
        ArrayList<Commission> hiddenFees = new ArrayList<Commission>();
        int idx = allContractRelations.indexOf(contractRelation);
        if (idx > 0) {
            for (GdsContractRelationData previousRelation : this.getPreviousRelations(allContractRelations, (BaseContractRelationData)contractRelation)) {
                for (GdsCommission comm2 : previousRelation.getCommissions()) {
                    FeeProperties feeProperties;
                    EntityContainer ctr = EntityStorage.get().resolve(comm2.getCommissionProperties());
                    if (ctr == null || !(ctr.getEntity() instanceof FeeProperties) || !(feeProperties = (FeeProperties)ctr.getEntity()).isHidden() && (!feeProperties.isTechFee() || Boolean.FALSE.equals(this.getProdUid2TransferTechFee().get(this.getProdUid()))) && (!feeProperties.isChargeToClientForAllContractTypes() || !translateSupplierFees)) continue;
                    GdsCommission newGdsComm = new GdsCommission();
                    newGdsComm.setCommissionProperties(comm2.getCommissionProperties());
                    if (rateData != null) {
                        Money amount = new Money();
                        amount.setCurrency(previousRelation.getGeneralData().getCurrency().getCode());
                        amount.setValue(comm2.getEquivalentAmount());
                        newGdsComm.setAmount(amount);
                        newGdsComm.setRate(null);
                    } else {
                        newGdsComm.setAmount(comm2.getAmount());
                        newGdsComm.setRate(comm2.getRate());
                    }
                    newGdsComm.setContractType(cType);
                    newGdsComm.setSource(comm2);
                    newGdsComm.setEquivalentAmount(comm2.getEquivalentAmount());
                    if (rateData != null) {
                        newGdsComm.setEquivalentAmount(RulesHelper.convert((BigDecimal)newGdsComm.getEquivalentAmount(), (ExchangeRateData)rateData));
                    }
                    contractRelation.getCommissions().add(newGdsComm);
                    result.add(newGdsComm);
                    if (!feeProperties.isHidden()) continue;
                    Commission hiddenFee = new Commission();
                    hiddenFee.setEquivalentAmount(newGdsComm.getEquivalentAmount());
                    if (rateData != null) {
                        hiddenFee.setEquivalentAmount(RulesHelper.convert((BigDecimal)hiddenFee.getEquivalentAmount(), (ExchangeRateData)rateData));
                    }
                    hiddenFee.setCommissionProperties(newGdsComm.getCommissionProperties());
                    hiddenFees.add(hiddenFee);
                }
            }
        }
        ArrayList commissions = new ArrayList(super.createCommissions(contractRelation.getDescription(), currencyCode, hiddenFees, messages));
        ArrayList<Commission> paymentFees = new ArrayList<Commission>();
        Iterator it = commissions.iterator();
        while (it.hasNext()) {
            comm2 = (Commission)it.next();
            if (comm2.getCommissionProperties() == null || !PaymentFeeProperties.class.equals((Object)comm2.getCommissionProperties().getType())) continue;
            it.remove();
            if (!ContractType.CLIENT.equals((Object)cType) || paymentTypes == null || paymentTypes.size() != 1) continue;
            PaymentType paymentType = paymentTypes.iterator().next();
            EntityContainer ctr = EntityStorage.get().resolve(comm2.getCommissionProperties());
            if (ctr == null) continue;
            PaymentFeeProperties prop = (PaymentFeeProperties)ctr.getEntity();
            if (paymentType == null || !paymentType.equals((Object)prop.getPaymentType())) continue;
            paymentFees.add((Commission)comm2);
        }
        it = commissions.iterator();
        while (it.hasNext()) {
            comm2 = (Commission)it.next();
            if (comm2.getEquivalentAmount() == null) {
                this.getProxy().getTracer().traceWarn(String.format("commission %s has null equivalent amount", comm2.getCommissionProperties()), null);
                it.remove();
                continue;
            }
            contractRelation.getCommissions().add(FlightHelper.buildGdsCommission((Commission)comm2, this.passengerType));
            result.add(FlightHelper.buildGdsCommission((Commission)comm2, this.passengerType));
        }
        result.addAll(this.getPaymentFees(paymentFees, contractRelation, messages));
        if (Boolean.FALSE.equals(this.getProdUid2IncludeBonus().get(this.getProdUid()))) {
            this.handleAgencyBonus(result);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private List<GdsCommission> getPaymentFees(List<Commission> paymentFees, GdsContractRelationData contractRelation, Collection<ValidationMessage> messages) {
        ArrayList<GdsCommission> result = new ArrayList<GdsCommission>();
        HashMap<void, Commission> minCommissions = new HashMap<void, Commission>();
        HashMap<void, Commission> maxCommissions = new HashMap<void, Commission>();
        HashMap<void, Commission> standardCommissions = new HashMap<void, Commission>();
        block4: for (Commission value : paymentFees) {
            void var10_10;
            String string = "";
            PaymentFeeType type = PaymentFeeType.STANDARD;
            EntityContainer bp = EntityStorage.get().resolve(value.getCommissionProperties());
            if (bp != null) {
                PaymentFeeProperties pfp = (PaymentFeeProperties)bp.getEntity();
                if (pfp.getPaymentType() != null) {
                    String string2 = pfp.getPaymentType().name();
                }
                if (pfp.getType() != null) {
                    type = pfp.getType();
                }
            }
            this.updatePaymentFeeAmount(value, contractRelation, messages);
            if (type != PaymentFeeType.MAXIMUM && value.getEquivalentAmount() == null) continue;
            if (value.getEquivalentAmount() == null) {
                value.setEquivalentAmount(BigDecimal.ZERO);
            }
            switch (type) {
                case MINIMUM: {
                    minCommissions.put(var10_10, value);
                    continue block4;
                }
                case MAXIMUM: {
                    maxCommissions.put(var10_10, value);
                    continue block4;
                }
            }
            standardCommissions.put(var10_10, value);
        }
        ArrayList<Object> resultList = new ArrayList<Object>();
        for (Map.Entry entry : new HashMap(standardCommissions).entrySet()) {
            Commission minCom;
            Commission commission = (Commission)entry.getValue();
            Commission max = (Commission)maxCommissions.get(entry.getKey());
            if (max != null && Math.abs(commission.getEquivalentAmount().doubleValue()) - Math.abs(max.getEquivalentAmount().doubleValue()) > 0.001) {
                commission = max;
            }
            if ((minCom = (Commission)minCommissions.get(entry.getKey())) != null) {
                minCommissions.remove(entry.getKey());
                if (Math.abs(minCom.getEquivalentAmount().doubleValue()) - Math.abs(commission.getEquivalentAmount().doubleValue()) > 0.001) {
                    commission = minCom;
                }
            }
            resultList.add(commission);
        }
        resultList.addAll(minCommissions.values());
        for (Commission commission : resultList) {
            if (commission.getEquivalentAmount() == null) continue;
            GdsCommission gdsComm = FlightHelper.buildGdsCommission((Commission)commission, this.passengerType);
            contractRelation.getCommissions().add(gdsComm);
            result.add(gdsComm);
        }
        return result;
    }

    private void handleAgencyBonus(List<GdsCommission> commissions) {
        List agencyBonuses = commissions.stream().filter(arg_0 -> ((FlightCommissionActionSet)this).isCommission(arg_0)).collect(Collectors.toList());
        for (GdsCommission agencyBonus : agencyBonuses) {
            String currencyCode = Optional.ofNullable(agencyBonus.getAmount()).map(Money::getCurrency).orElse(null);
            List<GdsCommission> technicalFees = commissions.stream().filter(arg_0 -> ((FlightCommissionActionSet)this).isTechnicalFee(arg_0)).filter(item -> MiscUtil.equals(Optional.ofNullable(item.getAmount()).map(Money::getCurrency).orElse(null), (Object)currencyCode)).collect(Collectors.toList());
            if (technicalFees.isEmpty()) continue;
            technicalFees.forEach(fee -> {
                fee.getAmount().setValue(fee.getAmount().getValue().subtract(agencyBonus.getAmount().getValue()));
                fee.setEquivalentAmount(fee.getEquivalentAmount().subtract(agencyBonus.getEquivalentAmount()));
                fee.setContractEquivalentAmount(fee.getContractEquivalentAmount().subtract(agencyBonus.getContractEquivalentAmount()));
            });
            commissions.remove(agencyBonus);
        }
    }

    public void updatePaymentFeeAmount(Commission comm, GdsContractRelationData contractRelation, Collection<ValidationMessage> messages) {
        comm.setEquivalentAmount(null);
        if (comm.getRate() == null) {
            comm.setEquivalentAmount(this.calculateEquivalentAmount(comm.getAmount(), comm.getRoundingMode(), comm.getRoundingValue()));
            return;
        }
        EntityContainer ctr = EntityStorage.get().resolve(comm.getCommissionProperties());
        if (ctr == null) {
            messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.PCAS_LOADING_COMMISSION_PROPERTIES_FAILED, (Object[])new Object[]{comm.getCommissionProperties()}));
            return;
        }
        PaymentFeeProperties prop = (PaymentFeeProperties)ctr.getEntity();
        if (prop.getPaymentType() == null) {
            messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.PCAS_COMMISSION_PAYMENT_TYPE_NOT_DEFINED, (Object[])new Object[]{comm.getCommissionProperties()}));
            return;
        }
        if (prop.getBasis() == null) {
            messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.PCAS_COMMISSION_BASIS_NOT_DEFINED, (Object[])new Object[]{comm.getCommissionProperties()}));
            return;
        }
        BigDecimal basis = BigDecimal.ZERO;
        if (prop.getBasis().equals((Object)PaymentFeeCalculationBasis.PRICE) || prop.getBasis().equals((Object)PaymentFeeCalculationBasis.PRICE_AND_FEES) || prop.getBasis().equals((Object)PaymentFeeCalculationBasis.TRANSACTION)) {
            basis = basis.add(contractRelation.getServiceData().getDetalization().getFare());
            for (SimpleTax tax : contractRelation.getServiceData().getDetalization().getTaxes()) {
                basis = basis.add(tax.getAmount());
            }
        }
        if (prop.getBasis().equals((Object)PaymentFeeCalculationBasis.FEES) || prop.getBasis().equals((Object)PaymentFeeCalculationBasis.PRICE_AND_FEES) || prop.getBasis().equals((Object)PaymentFeeCalculationBasis.TRANSACTION)) {
            for (GdsCommission gdsCommission : contractRelation.getCommissions()) {
                if (!gdsCommission.getCommissionProperties().getType().equals(FeeProperties.class)) continue;
                basis = basis.add(gdsCommission.getEquivalentAmount());
            }
        }
        BigDecimal value = basis.multiply(BigDecimal.valueOf(comm.getRate())).divide(BigDecimal.valueOf(100L), 3, java.math.RoundingMode.HALF_UP);
        if (prop.getBasis().equals((Object)PaymentFeeCalculationBasis.TRANSACTION)) {
            value = value.divide(BigDecimal.valueOf(1.0 - comm.getRate() / 100.0), 3, java.math.RoundingMode.HALF_UP);
        }
        comm.setEquivalentAmount(value);
    }

    private BigDecimal calculateEquivalentAmount(Money amount, RoundingMode rm, RoundingValue rv) {
        if (amount == null || amount.getCurrency() == null || amount.getValue() == null) {
            return null;
        }
        String eqvCode = this.getEquivalentCurrencyCode();
        BigDecimal value = amount.getValue();
        String currencyCode = amount.getCurrency();
        if (!currencyCode.equals(eqvCode)) {
            value = value.multiply(this.getCurrencyRate(currencyCode, false, new ArrayList<ValidationMessage>()));
        }
        return RulesHelper.roundDouble((BigDecimal)value, (RoundingMode)rm, (RoundingValue)rv);
    }

    protected BigDecimal getBasis(CalculationBasis basis, List<Commission> hiddenFees, boolean useDifference) {
        ValueHolder amount;
        AirRulesProductHandler h = AirRulesProductHandler.get();
        if (h != null && h.getBasis(null, this.contractRelationDescription, basis, hiddenFees, useDifference, amount = new ValueHolder())) {
            return MiscUtil.guarded((BigDecimal)((BigDecimal)amount.getValue()));
        }
        if (basis == CalculationBasis.PAYMENT_SUM_TO_SUPPLIER) {
            if (this.contractRelationDescription == null || GeneralProductHelper.getContractType((EntityReference)this.currentContractRelation.getDescription()) == ContractType.VENDOR || this.flight.getContractRelations().get(this.passengerType) == null) {
                return BigDecimal.ZERO;
            }
            BigDecimal result = null;
            for (GdsContractRelationData relation : (List)this.flight.getContractRelations().get(this.passengerType)) {
                if (result == null) {
                    if (GeneralProductHelper.getContractType((EntityReference)relation.getDescription()) != ContractType.VENDOR) continue;
                    result = MiscUtil.guarded((BigDecimal)relation.getServiceData().getTotalPrice());
                    for (GdsCommission comm : relation.getCommissions()) {
                        if (!FeeProperties.class.equals((Object)comm.getCommissionProperties().getType())) continue;
                        result = result.add(MiscUtil.guarded((BigDecimal)comm.getEquivalentAmount()));
                    }
                    continue;
                }
                ExchangeRateData exchangeRateData = relation.getGeneralData().getRate();
                if (exchangeRateData != null) {
                    result = MulticurrencyHelper.convert(result, (ExchangeRateData)exchangeRateData);
                }
                if (!this.currentContractRelation.getDescription().equals((Object)relation.getDescription())) continue;
                break;
            }
            return result == null ? BigDecimal.ZERO : result;
        }
        boolean withTaxes = Arrays.asList(CalculationBasis.TOTAL, CalculationBasis.TOTAL_AND_PENALTY).contains(basis);
        BigDecimal result = MiscUtil.guarded((BigDecimal)this.currentContractRelation.getServiceData().getDetalization().getFare());
        if (withTaxes) {
            for (SimpleTax tax : this.currentContractRelation.getServiceData().getDetalization().getTaxes()) {
                result = MiscUtil.sum((BigDecimal[])new BigDecimal[]{result, tax.getAmount()});
            }
            for (Commission comm : hiddenFees) {
                FeeProperties feeProp = (FeeProperties)EntityStorage.get().resolve(comm.getCommissionProperties()).getEntity();
                if (TextUtil.isBlank((String)feeProp.getHiddenFeeTaxCode())) continue;
                result = result.add(comm.getEquivalentAmount());
            }
        }
        return result;
    }

    protected boolean accept(PaymentFeeProperties feeProp) {
        return true;
    }

    public DictionaryReference<PassengerType> getPassengerType() {
        return this.passengerType;
    }

    public void addAllowedPaymentType(String pt) {
        super.addAllowedPaymentType(pt);
        if (pt != null) {
            this.flight.getAllowedPaymentTypes().add(PaymentType.valueOf((String)pt));
        }
    }

    protected void fixCommissionRate(Commission result, CommissionProperties commProp) {
    }

    protected void fixDiscountRate(Commission result, DiscountProperties discProp) {
    }

    public void addSSR(String details) {
        this.flight.getSsrs().add(details);
    }

    public void addNonGdsCustomProperty(NamedValue property) {
        if (property == null) {
            return;
        }
        NamedValue sameProperty = this.flight.getNonGdsCustomProperties().stream().filter(Objects::nonNull).filter(prop -> prop.getName() != null && prop.getName().equals(property.getName())).findFirst().orElse(null);
        if (sameProperty != null) {
            sameProperty.setValue(property.getValue());
        } else {
            this.flight.getNonGdsCustomProperties().add(property);
        }
    }

    public List<GdsCommission> getCommissions() {
        return this.currentContractRelation.getCommissions();
    }

    public String getProdUid() {
        return this.flight.getUid();
    }
}

