/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.rules.proxy;

import com.gridnine.xtrip.common.gds.model.BaseGdsAccount;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightCommission;
import com.gridnine.xtrip.common.gds.model.FlightLeg;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.midoffice.helper.CommonHelper;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.TransportationType;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.rules.standard.Constants;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.model.rules.standard.TimeLimitPropertyProvider;
import com.gridnine.xtrip.common.rules.elements.RuleLogTracer;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.util.ObjectFilter;
import com.gridnine.xtrip.server.gds.rules.proxy.BaseGdsAirPropertySet;
import com.gridnine.xtrip.server.gds.rules.proxy.FlightProxyHelper;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlightLegPropertySet
extends BaseGdsAirPropertySet
implements TimeLimitPropertyProvider {
    private static final long serialVersionUID = -6432596753650186546L;
    private static final transient Logger log = LoggerFactory.getLogger(FlightLegPropertySet.class);
    private static final ObjectFilter<PropertyDescriptor> TRACE_FILTER = descr -> {
        try {
            Class<?> propertyType = descr.getPropertyType();
            if (propertyType == null) {
                return false;
            }
            if (Flight.class.isAssignableFrom(propertyType)) {
                return false;
            }
            if (FlightCommission.class.isAssignableFrom(propertyType)) {
                return true;
            }
            return RuleLogTracer.STANDARD_FILTER.accept(descr);
        }
        catch (Throwable t) {
            return false;
        }
    };
    private final FlightLeg leg;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FlightLegPropertySet(FlightLeg l, RuleProxy<?, ?> proxy, SalesContext ctx, EntityReference<? extends BaseGdsAccount> accountRef) {
        proxy.getTracer().traceEnteringMethod(((Object)((Object)this)).getClass(), "ctor()", new String[0]);
        try {
            this.setAgent(ctx.getAgent());
            this.setBookingAgent(ctx.getAgent());
            this.setClient(ctx.getClient());
            this.setAgencyCode(CommonHelper.getAgencyCode((SalesContext)ctx));
            this.addSubagencyCodes(ctx.getSubagency());
            this.addProfileGroups(ctx.getAgent());
            this.addProfileGroups(ctx.getClient());
            this.leg = l;
            this.setCurrentDate(new Date());
            this.setProductCategory(ProductCategory.AIR.name());
            this.setIssueDate(new Date());
            this.setGdsName(((FlightSegment)l.getSegments().get(0)).getGds() != null ? ((FlightSegment)l.getSegments().get(0)).getGds().name() : null);
            this.setGdsAccount(accountRef);
            this.setTariffType(TariffType.REGULAR.name());
            this.setTargetType(ProductCategory.AIR.name());
            if (this.calculateTransportationType(l) == TransportationType.DOMESTIC) {
                this.setTransportationType(Constants.TRANSPORTATION_DOMESTIC.name());
            } else {
                this.setTransportationType(Constants.TRANSPORTATION_INTRENATIONAL.name());
            }
            this.setNumOfSegments(this.getNumOfSegments() + l.getSegments().size());
            if (((FlightSegment)l.getSegments().get(0)).getLocationBegin() != null) {
                Set codes = RulesHelper.collectGeoCodes(Collections.singleton(((FlightSegment)l.getSegments().get(0)).getLocationBegin().getCode()), (boolean)true, (boolean)true);
                this.getVisitedCities().add(codes.toArray(new String[0]));
                this.getAllLocations().addAll(codes);
                this.getDepartureLocations().addAll(codes);
            }
            this.updateValidatingCarrierCountries(this.leg);
            if (this.leg.getCarrier() != null) {
                Airline airline = (Airline)DictionaryCache.get().resolveReference(this.leg.getCarrier());
                if (airline != null) {
                    this.getCarriers().addAll(airline.getCodeVariants().values());
                    this.setCarrierNumber(airline.getAirlineNumber());
                } else {
                    log.warn(String.format("airline with code %s cannot be resolved", this.leg.getCarrier()));
                }
            }
            this.getAllValidatingCarriersCodes().add(this.getCarriers().toArray(new String[0]));
            if (this.leg.getCarrier() == null) {
                this.getCarriers().addAll(this.getAirlines());
            }
            for (FlightSegment seg : l.getSegments()) {
                if (seg.getLocationEnd() != null) {
                    Set codes = RulesHelper.collectGeoCodes(Collections.singleton(seg.getLocationEnd().getCode()), (boolean)true, (boolean)true);
                    this.getVisitedCities().add(codes.toArray(new String[0]));
                    this.getAllLocations().addAll(codes);
                    this.getArrivalLocations().addAll(codes);
                }
                this.getFlightNumbers().add(seg.getFlightNumber());
                if (seg.getServiceClass() != null) {
                    this.getServiceClasses().add(seg.getServiceClass().name());
                }
                this.getBookingClasses().add(seg.getBookingClass());
                this.getDepartureDates().add(seg.getDateBegin());
                if (seg.getAirline() != null) {
                    this.getAirlines().add(seg.getAirline().getCode());
                }
                this.setTravelDuration(this.getTravelDuration() + seg.getTravelDuration());
                this.getSurfaceSegments().add(Boolean.FALSE);
                if (seg.getDateBegin() != null && (this.getDepartureDate() == null || this.getDepartureDate().after(seg.getDateBegin()))) {
                    this.setDepartureDate(seg.getDateBegin());
                }
                if (seg.getDateEnd() != null && (this.getArrivalDate() == null || this.getArrivalDate().before(seg.getDateEnd()))) {
                    this.setArrivalDate(seg.getDateEnd());
                }
                if (seg.getLocationEnd() == null) continue;
                this.fillVisitedGeolocations(seg);
            }
            this.setFirstSegmentDepartureDate(((FlightSegment)l.getSegments().get(0)).getDateBegin());
            this.setFirstSegmentDepartureLocation(((FlightSegment)l.getSegments().get(0)).getLocationBegin());
            this.setHoursBeforeDepartureSupplier(() -> ((FlightLegPropertySet)this).calculateHoursBeforeDeparture());
        }
        finally {
            proxy.getTracer().traceObject("proxy", (Object)this, TRACE_FILTER);
            proxy.getTracer().traceExitingMethod(((Object)((Object)this)).getClass(), "ctor()", new String[0]);
        }
    }

    private void updateValidatingCarrierCountries(FlightLeg leg) {
        Airline validatingCarrier = (Airline)DictionaryCache.get().resolveReference(leg.getCarrier());
        if (validatingCarrier == null || validatingCarrier.getCountry() == null) {
            return;
        }
        this.getPrimaryCarrierCountry().add(validatingCarrier.getCountry().getCode());
        Country country = (Country)DictionaryCache.get().resolveReference(validatingCarrier.getCountry());
        if (country != null) {
            this.getPrimaryCarrierCountry().addAll(country.getCodeVariants().values());
        }
    }

    private TransportationType calculateTransportationType(FlightLeg leg) {
        for (FlightSegment seg : leg.getSegments()) {
            if (FlightProxyHelper.calculateTransportationType((DictionaryReference<GeoLocation>)seg.getLocationBegin(), (DictionaryReference<GeoLocation>)seg.getLocationEnd()) != TransportationType.INTERNATIONAL) continue;
            return TransportationType.INTERNATIONAL;
        }
        return TransportationType.DOMESTIC;
    }

    public FlightLeg getLeg() {
        return this.leg;
    }

    private void fillVisitedGeolocations(FlightSegment seg) {
        ArrayList lvgl = new ArrayList();
        Stream.of(seg.getLocationBegin(), seg.getLocationEnd()).filter(Objects::nonNull).forEach(geoLoc -> {
            HashSet<String> geoCodes = new HashSet<String>();
            geoCodes.add(geoLoc.getCode());
            geoCodes.addAll(RulesHelper.collectGeoCodes(geoCodes, (boolean)true));
            geoCodes.addAll(RulesHelper.collectGeoCodes((DictionaryReference)geoLoc, (boolean)true, (boolean)true));
            if (lvgl.isEmpty() || !((Set)lvgl.get(lvgl.size() - 1)).equals(geoCodes)) {
                lvgl.add(geoCodes);
            }
        });
        this.getVisitedGeolocations().addAll(RulesHelper.fillVisitedGeolocations(lvgl));
    }

    public boolean isTimeLimitFromSupplierReceived() {
        return false;
    }

    public boolean isTimeLimitFromSupplierAfterDeparture() {
        return false;
    }
}

