/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.rules.proxy;

import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.PassportType;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.rules.passport.PassportPropertiesProvider;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.server.gds.rules.proxy.FlightPropertySet;
import java.util.HashSet;
import java.util.Set;

public class FlightPassportPropertySet
extends FlightPropertySet
implements PassportPropertiesProvider {
    private final Set<PassportType> passengerTypes = new HashSet<PassportType>();
    private final Set<DictionaryReference<Country>> citizenships = new HashSet<DictionaryReference<Country>>();
    private final SalesContext salesContext;

    public FlightPassportPropertySet(Flight flight, DictionaryReference<PassengerType> passengerType, Passport passport, RuleProxy<?, ?> proxy, SalesContext salesContext) {
        super.update(flight, passengerType, PaymentType.INVOICE, null, proxy, salesContext);
        this.salesContext = salesContext;
        if (passport != null) {
            DictionaryReference citizenship;
            PassportType passportType = passport.getType();
            if (passportType != null) {
                this.getPassportTypes().add(passportType);
            }
            if ((citizenship = passport.getCitizenship()) != null) {
                this.getCitizenship().add((DictionaryReference<Country>)citizenship);
            }
        }
    }

    public Set<PassportType> getPassportTypes() {
        return this.passengerTypes;
    }

    public Set<DictionaryReference<Country>> getCitizenship() {
        return this.citizenships;
    }

    public SalesContext getSalesContext() {
        return this.salesContext;
    }
}

