/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.rules.proxy;

import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.FareInfo;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightCommission;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.model.FlightSegmentTariff;
import com.gridnine.xtrip.common.gds.model.SeatPreferences;
import com.gridnine.xtrip.common.gds.rules.ConnectionData;
import com.gridnine.xtrip.common.gds.rules.FlightAdditionalPropertiesProvider;
import com.gridnine.xtrip.common.gds.rules.Properties;
import com.gridnine.xtrip.common.midoffice.helper.CommonHelper;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.ReservationType;
import com.gridnine.xtrip.common.model.booking.SalesChain;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.TransportationType;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.CountryReference;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.Address;
import com.gridnine.xtrip.common.model.profile.CostCode;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PredefinedContractorType;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.rules.standard.Constants;
import com.gridnine.xtrip.common.model.rules.standard.PayersPropertiesProvider;
import com.gridnine.xtrip.common.model.rules.standard.ProductStatusPropertiesProvider;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.model.rules.standard.TechnicalFeePropertiesProvider;
import com.gridnine.xtrip.common.model.rules.standard.TicketTypePropertiesProvider;
import com.gridnine.xtrip.common.model.rules.standard.TimeLimitPropertyProvider;
import com.gridnine.xtrip.common.model.rules.standard.TravellersPropertyProvider;
import com.gridnine.xtrip.common.model.rules.standard.UDIDsPropertyProvider;
import com.gridnine.xtrip.common.model.standard.helpers.NamedValueHelper;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.rules.elements.RuleLogTracer;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.util.LazyValueHolder;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.ObjectFilter;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.gds.helper.TransatlaticRouteHelper;
import com.gridnine.xtrip.server.gds.rules.proxy.FlightProxyHelper;
import com.gridnine.xtrip.server.model.handlers.BaseAirPropertySet;
import java.beans.PropertyDescriptor;
import java.math.BigDecimal;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlightPropertySet
extends BaseAirPropertySet
implements PayersPropertiesProvider,
TravellersPropertyProvider,
UDIDsPropertyProvider,
TicketTypePropertiesProvider,
FlightAdditionalPropertiesProvider,
ProductStatusPropertiesProvider,
TechnicalFeePropertiesProvider,
TimeLimitPropertyProvider {
    private static final long serialVersionUID = -4967516137668463163L;
    private static final transient Logger log = LoggerFactory.getLogger(FlightPropertySet.class);
    private static final ObjectFilter<PropertyDescriptor> TRACE_FILTER = descr -> {
        try {
            Class<?> propertyType = descr.getPropertyType();
            if (propertyType == null) {
                return false;
            }
            if (Flight.class.isAssignableFrom(propertyType)) {
                return false;
            }
            if (FlightCommission.class.isAssignableFrom(propertyType)) {
                return true;
            }
            return RuleLogTracer.STANDARD_FILTER.accept(descr);
        }
        catch (Throwable t) {
            return false;
        }
    };
    private Flight flight;
    private DictionaryReference<PassengerType> passengerType;
    private PaymentType paymentType;
    private int childrenPerAdultCount;
    private String salesOriginProvider;
    private String salesOriginContent;
    private final List<CostCode> costCodes = new ArrayList<CostCode>();
    private final LazyValueHolder<List<EntityReference<Organization>>> employers = new LazyValueHolder(ArrayList::new);
    private Date timeLimitFromSupplier;
    private DictionaryReference<Airline> carrier;
    private EntityReference<Organization> blankOwner;
    private final Collection<EntityReference<Organization>> payers = new HashSet<EntityReference<Organization>>();

    public static FlightPropertySet create(Flight flt, DictionaryReference<PassengerType> passengerType, PaymentType paymentType, String pcc, RuleProxy<?, ?> proxy, SalesContext ctx) {
        FlightPropertySet ps = (FlightPropertySet)((Object)flt.getFlightPropertySet(passengerType));
        if (ps == null) {
            ps = new FlightPropertySet();
            flt.setFlightPropertySet(passengerType, (Object)ps);
        }
        ps.update(flt, passengerType, paymentType, pcc, proxy, ctx);
        return ps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void update(Flight flt, DictionaryReference<PassengerType> passengerType, PaymentType paymentType, String pcc, RuleProxy<?, ?> proxy, SalesContext ctx) {
        proxy.getTracer().traceEnteringMethod(((Object)((Object)this)).getClass(), "update()", new String[0]);
        try {
            if (this.flight == null) {
                this.flight = flt;
                this.init(this.flight);
            } else if (this.flight != flt) {
                throw Xeption.forDeveloper((String)"can't reinit property set with different flight, create new property set", (Object[])new Object[0]);
            }
            this.update(this.flight);
            this.update(ctx);
            if (!MiscUtil.equals(this.passengerType, passengerType)) {
                this.passengerType = passengerType;
                this.update(passengerType);
            }
            if (!MiscUtil.equals((Object)this.paymentType, (Object)paymentType)) {
                this.paymentType = paymentType;
                this.update(paymentType);
            }
            this.setPcc(pcc);
        }
        finally {
            proxy.getTracer().traceObject("proxy", (Object)this, TRACE_FILTER);
            proxy.getTracer().traceExitingMethod(((Object)((Object)this)).getClass(), "update()", new String[0]);
        }
    }

    private void init(Flight flt) {
        this.setLatinRegistration(this.flight.isLatinRegistration());
        this.setGdsName(this.flight.getGds() != null ? this.flight.getGds().name() : null);
        this.getCustomParameters().put("gdsAccount", this.flight.getGdsAccount());
        this.setTransatlanticFlight(TransatlaticRouteHelper.isTransatlanticFlight(flt));
        this.setTariffType(flt.isBlockCharter() ? TariffType.BLOCKCHARTER.name() : TariffType.REGULAR.name());
        this.setSupplier(this.getSupplier(flt));
        if (FlightProxyHelper.calculateTransportationType(this.flight) == TransportationType.DOMESTIC) {
            this.setTransportationType(Constants.TRANSPORTATION_DOMESTIC.name());
        } else {
            this.setTransportationType(Constants.TRANSPORTATION_INTRENATIONAL.name());
        }
        this.setEticket(this.flight.isEticket());
        int childCount = 0;
        int adultCount = 0;
        for (SeatPreferences seatPref : this.flight.getSeats()) {
            if (DictHelper.isChildPassengerTypeCategory((DictionaryReference)seatPref.getPassengerType())) {
                childCount += seatPref.getCount();
                continue;
            }
            if (!DictHelper.isAdultPassengerTypeCategory((DictionaryReference)seatPref.getPassengerType())) continue;
            adultCount += seatPref.getCount();
        }
        this.childrenPerAdultCount = adultCount == 0 ? Integer.MAX_VALUE : (int)(Math.ceil(childCount) / (double)adultCount);
        boolean firstSegment = true;
        DictionaryReference prevLoc = null;
        DictionaryReference prevAirline = null;
        Date prevArriveDate = null;
        String firstDepartureCode = null;
        String arrivalCode = null;
        ArrayList<String> cities = new ArrayList<String>();
        DictionaryReference turnoverLocation = null;
        DictionaryReference lastRoutePoint = null;
        ArrayList lvgl = new ArrayList();
        for (FlightSegmentTariff st : this.flight.getSegmentTariffs()) {
            for (FlightSegment seg : st.getSegments()) {
                DictionaryReference board;
                Collection values;
                Airline airline;
                this.setNumOfSegments(this.getNumOfSegments() + 1);
                if (!this.isTransatlanticFlight()) {
                    this.setTransatlanticFlight(RulesHelper.isTransatlanticFlight((DictionaryReference)seg.getLocationBegin(), (DictionaryReference)seg.getLocationEnd(), (Date)seg.getDateBegin(), (Date)seg.getDateEnd(), (Integer)seg.getTravelDuration()));
                }
                lastRoutePoint = seg.getLocationEnd();
                String departureCityCode = seg.getLocationBegin() == null ? null : seg.getLocationBegin().getCode();
                DictionaryReference departure = seg.getLocationBegin();
                Set dlcs = Collections.emptySet();
                if (departure != null) {
                    departureCityCode = departure.getCode();
                    GeoLocation departureCity = DictHelper.findCityByAirport((String)departureCityCode);
                    if (departureCity != null) {
                        departureCityCode = departureCity.getCode();
                    }
                    dlcs = RulesHelper.collectGeoCodes((DictionaryReference)departure, (boolean)true, (boolean)true, (boolean)true);
                    this.getAllLocations().addAll(dlcs);
                }
                if (firstSegment) {
                    if (departure != null) {
                        this.getDepartureLocations().addAll(dlcs);
                    }
                    cities.add(departureCityCode);
                    this.setFirstSegmentDepartureDate(seg.getDateBegin());
                    this.setFirstSegmentDepartureLocation(seg.getLocationBegin());
                }
                if (seg.getLocationBegin() != null && firstDepartureCode == null) {
                    firstDepartureCode = seg.getLocationBegin().getCode();
                }
                if (!firstSegment && !MiscUtil.equals(prevLoc, (Object)seg.getLocationBegin())) {
                    cities.add(departureCityCode);
                    this.getSurfaceSegments().add(Boolean.TRUE);
                    this.getFlightNumbers().add(null);
                    this.getFareBasises().add(null);
                    this.getServiceClasses().add(null);
                    this.getBookingClasses().add(null);
                    this.getInterlineCarriers().add(null);
                    this.getDepartureDates().add(null);
                    this.getDomesticFlightsAC().add(null);
                    Set codes = RulesHelper.collectGeoCodes((DictionaryReference)seg.getLocationBegin(), (boolean)true, (boolean)true);
                    this.getOpenJawEnd().addAll(codes);
                    this.getOpenJawLoc().addAll(codes);
                    codes = RulesHelper.collectGeoCodes(prevLoc, (boolean)true, (boolean)true);
                    this.getOpenJawStart().addAll(codes);
                    this.getOpenJawLoc().addAll(codes);
                    this.getConnectedFlights().add(null);
                }
                if ((airline = (Airline)DictionaryCache.get().resolveReference(seg.getAirline())) != null) {
                    values = airline.getCodeVariants().values();
                } else {
                    values = seg.getAirline() == null ? Collections.emptySet() : Collections.singleton(seg.getAirline().getCode());
                    log.warn(String.format("airline with code %s cannot be resolved", seg.getAirline()));
                }
                this.getSegmentAirlines().add(values.toArray(new String[0]));
                if (firstSegment) {
                    this.getFirstSegmentAirline().addAll(values);
                }
                if ((board = seg.getBoard()) != null) {
                    this.getAircraftsCodes().add(board.getCode());
                }
                if ((airline = (Airline)DictionaryCache.get().resolveReference(seg.getOperatingAirline() == null ? seg.getAirline() : seg.getOperatingAirline())) != null) {
                    values = airline.getCodeVariants().values();
                    this.getSegmentOperatingAirlines().add(values.toArray(new String[0]));
                } else {
                    String[] stringArray;
                    List list = this.getSegmentOperatingAirlines();
                    if (seg.getAirline() == null) {
                        stringArray = new String[]{};
                    } else {
                        String[] stringArray2 = new String[1];
                        stringArray = stringArray2;
                        stringArray2[0] = seg.getAirline().getCode();
                    }
                    list.add(stringArray);
                    log.warn(String.format("airline with code %s cannot be resolved", seg.getAirline()));
                }
                if (seg.getOperatingAirline() != null) {
                    airline = (Airline)DictionaryCache.get().resolveReference(seg.getOperatingAirline());
                    if (airline != null) {
                        values = airline.getCodeVariants().values();
                        this.getOperatingAirlines().addAll(values);
                    } else {
                        this.getOperatingAirlines().add(seg.getOperatingAirline().getCode());
                        log.warn(String.format("airline with code %s cannot be resolved", seg.getOperatingAirline()));
                    }
                }
                if (seg.getAirline() != null && seg.getOperatingAirline() != null && !seg.getAirline().equals((Object)seg.getOperatingAirline())) {
                    this.setHasCodeSharing(true);
                    airline = (Airline)DictionaryCache.get().resolveReference(seg.getOperatingAirline());
                    if (airline != null) {
                        this.getCodeShareAirlines().addAll(airline.getCodeVariants().values());
                    } else {
                        log.warn(String.format("airline with code %s cannot be resolved", seg.getOperatingAirline()));
                        this.getCodeShareAirlines().add(seg.getOperatingAirline().getCode());
                    }
                }
                this.getSurfaceSegments().add(Boolean.FALSE);
                this.getConnectedFlights().add(!seg.isStarting());
                this.getDomesticFlightsAC().add(this.isDomesticFlightAC(seg.getAirline(), seg.getLocationBegin(), seg.getLocationEnd()));
                this.getFlightNumbers().add(seg.getFlightNumber());
                if (seg.getServiceClass() != null) {
                    this.getServiceClasses().add(seg.getServiceClass().name());
                }
                this.getBookingClasses().add(seg.getBookingClass());
                if (seg.getAirline() != null) {
                    airline = (Airline)DictionaryCache.get().resolveReference(seg.getAirline());
                    if (airline != null) {
                        this.getAirlines().addAll(airline.getCodeVariants().values());
                    } else {
                        log.warn(String.format("airline with code %s cannot be resolved", seg.getAirline().getCode()));
                        this.getAirlines().add(seg.getAirline().getCode());
                    }
                }
                if (!firstSegment && !MiscUtil.equals(prevAirline, (Object)seg.getAirline())) {
                    this.setInterline(true);
                    this.getInterlineCarriers().add(new String[]{seg.getAirline().getCode()});
                } else {
                    this.getInterlineCarriers().add(null);
                    if (this.getCarrierNumber() == null) {
                        airline = (Airline)DictionaryCache.get().resolveReference(seg.getAirline());
                        if (airline != null) {
                            this.setCarrierNumber(airline.getAirlineNumber());
                        } else {
                            log.warn(String.format("airline with code %s cannot be resolved", seg.getAirline()));
                        }
                    }
                }
                this.getDepartureDates().add(seg.getDateBegin());
                DictionaryReference arrival = seg.getLocationEnd();
                arrivalCode = null;
                if (arrival != null) {
                    arrivalCode = arrival.getCode();
                    GeoLocation arrivalCity = DictHelper.findCityByAirport((String)arrivalCode);
                    if (arrivalCity != null) {
                        arrivalCode = arrivalCity.getCode();
                    }
                    this.getAllLocations().addAll(RulesHelper.collectGeoCodes((DictionaryReference)arrival, (boolean)true, (boolean)true, (boolean)true));
                }
                if (arrivalCode != null && !cities.contains(arrivalCode)) {
                    turnoverLocation = arrival;
                }
                if (arrivalCode != null) {
                    cities.add(arrivalCode);
                }
                if (seg.getDateBegin() != null && (this.getDepartureDate() == null || this.getDepartureDate().after(seg.getDateBegin()))) {
                    this.setDepartureDate(seg.getDateBegin());
                }
                if (seg.getDateEnd() != null && (this.getArrivalDate() == null || this.getArrivalDate().before(seg.getDateEnd()))) {
                    this.setArrivalDate(seg.getDateEnd());
                }
                if (!seg.isStarting()) {
                    ConnectionData connectionData = new ConnectionData();
                    connectionData.setArrivalAirport(prevLoc);
                    connectionData.setDepartureAirport(seg.getLocationBegin());
                    if (prevArriveDate != null && seg.getDateBegin() != null) {
                        connectionData.setConnectionTimeInMinutes(Math.round((float)(seg.getDateBegin().getTime() - prevArriveDate.getTime()) / 60000.0f));
                    }
                    List connections = (List)this.getCustomParameter(Properties.CONNECTION_TIME.name());
                    connections.add(connectionData);
                }
                firstSegment = false;
                prevLoc = seg.getLocationEnd();
                prevAirline = seg.getAirline();
                prevArriveDate = seg.getDateEnd();
                ArrayList<String[]> lst = new ArrayList<String[]>();
                lst.add(this.getCodes((DictionaryReference<GeoLocation>)departure));
                lst.add(this.getCodes((DictionaryReference<GeoLocation>)arrival));
                this.getFlightSegments().add(lst);
                ArrayList<DictionaryReference> referenceList = new ArrayList<DictionaryReference>();
                referenceList.add(departure);
                referenceList.add(arrival);
                for (DictionaryReference reference : referenceList) {
                    if (reference == null) continue;
                    HashSet<String> geoCodes = new HashSet<String>();
                    geoCodes.add(reference.getCode());
                    geoCodes.addAll(RulesHelper.collectGeoCodes(geoCodes, (boolean)true));
                    geoCodes.addAll(RulesHelper.collectGeoCodes((DictionaryReference)reference, (boolean)true, (boolean)true));
                    if (!lvgl.isEmpty() && ((Set)lvgl.get(lvgl.size() - 1)).equals(geoCodes)) continue;
                    lvgl.add(geoCodes);
                }
            }
            this.setHasTransferTariffs(this.isHasTransferTariffs() || st.getSegments().size() > 1);
        }
        this.getVisitedGeolocations().addAll(RulesHelper.fillVisitedGeolocations(lvgl));
        this.getLastRoutePointCodes().addAll(RulesHelper.collectGeoCodes(lastRoutePoint, (boolean)true, (boolean)true));
        for (String city : cities) {
            HashSet<String> geoCodes = new HashSet<String>();
            if (!TextUtil.isBlank((String)city)) {
                geoCodes.add(city);
                geoCodes.addAll(RulesHelper.collectGeoCodes(geoCodes, (boolean)true));
            }
            this.getVisitedCities().add(geoCodes.toArray(new String[0]));
        }
        this.getArrivalLocations().clear();
        if (turnoverLocation != null) {
            this.getArrivalLocations().addAll(RulesHelper.collectGeoCodes(turnoverLocation, (boolean)true, (boolean)true, (boolean)true));
        }
        this.setOneWayTicket(!MiscUtil.equals((Object)DictHelper.findCityByAirport(firstDepartureCode), (Object)DictHelper.findCityByAirport(arrivalCode)));
        this.setHasOpenJaw(!this.getOpenJawLoc().isEmpty());
        this.applyTravelDuration();
        this.applyGdsCurrency(this.flight);
        if (this.flight.getMcoCategory() != null) {
            this.setProductCategory(ProductCategory.MCO.name());
            this.setMcoCategory(this.flight.getMcoCategory().name());
        }
        this.setHoursBeforeDepartureSupplier(() -> ((FlightPropertySet)this).calculateHoursBeforeDeparture());
        this.setHoursBeforeSellAndDepartureSupplier(() -> ((FlightPropertySet)this).calculateHourseBeforeSellAndDepature());
        if (this.flight.getSalesOriginProvider() != null) {
            this.salesOriginProvider = this.flight.getSalesOriginProvider().name();
        }
        if (this.flight.getSalesOriginContent() != null) {
            this.salesOriginContent = this.flight.getSalesOriginContent().name();
        }
        this.timeLimitFromSupplier = this.flight.getPqTimeLimit();
        this.setAccountCode(this.flight.getAccountCode());
    }

    private EntityReference<Organization> getSupplier(Flight flt) {
        return GeneralProductHelper.getContractor((SalesChain)flt.getSalesChain(), (PredefinedContractorType)PredefinedContractorType.SUPPLIER);
    }

    private void update(Flight flt) {
        if (!MiscUtil.equals(this.carrier, (Object)this.flight.getCarrier())) {
            if (this.carrier != null) {
                this.getPrimaryCarrierCountry().clear();
                this.getCarriers().clear();
                this.getAllValidatingCarriersCodes().clear();
            }
            this.carrier = this.flight.getCarrier();
            this.updateValidatingCarrierCountries(this.flight);
            if (this.flight.getCarrier() != null) {
                Airline airline = (Airline)DictionaryCache.get().resolveReference(this.flight.getCarrier());
                if (airline != null) {
                    this.getCarriers().addAll(airline.getCodeVariants().values());
                    this.setCarrierNumber(airline.getAirlineNumber());
                } else {
                    log.warn(String.format("airline with code %s cannot be resolved", this.flight.getCarrier()));
                }
            }
            this.getAllValidatingCarriersCodes().add(this.getCarriers().toArray(new String[0]));
            if (this.flight.getCarrier() == null) {
                this.getCarriers().addAll(this.getAirlines());
            }
        }
        if (!MiscUtil.equals(this.blankOwner, (Object)this.flight.getBlankOwner())) {
            DictionaryReference blankOwnerAirline;
            if (this.blankOwner != null) {
                this.getBlankOwners().clear();
            }
            this.blankOwner = this.flight.getBlankOwner();
            if (this.flight.getBlankOwner() != null && (blankOwnerAirline = ProfileHelper.findAirline((EntityReference)this.flight.getBlankOwner())) != null) {
                this.getBlankOwners().add(blankOwnerAirline.getCode());
                Airline airline = (Airline)DictionaryCache.get().resolveReference(blankOwnerAirline);
                if (airline != null) {
                    this.getBlankOwners().addAll(airline.getCodeVariants().values());
                    if (!TextUtil.isBlank((String)airline.getAirlineNumber())) {
                        this.getBlankOwners().add(airline.getAirlineNumber());
                    }
                }
            }
        }
        EntityReference<Organization> flightSupplier = this.getSupplier(this.flight);
        if (!MiscUtil.equals((Object)this.getSupplier(), flightSupplier) && flightSupplier != null) {
            this.setSupplier(flightSupplier);
        }
        this.updateTripartiteProperties(this.flight);
    }

    public void updateTripartiteProperties(Flight flight) {
        this.setTourCode(flight.getTourCode());
        if (flight.getTripartiteContractDetails() != null) {
            this.setContractCode(RulesHelper.getString((String)flight.getTripartiteContractDetails().getContractCode()));
        }
    }

    private void update(SalesContext ctx) {
        this.setAgent(ctx.getAgent());
        this.setBookingAgent(ctx.getAgent());
        this.setClient(ctx.getClient());
        this.setAgencyCode(CommonHelper.getAgencyCode((SalesContext)ctx));
        this.getSubagencyCodes().clear();
        this.addSubagencyCodes(ctx.getSubagency());
        this.getProfileGroups().clear();
        this.addProfileGroups(ctx.getAgent());
        this.addProfileGroups(ctx.getClient());
        this.setSalesPointUid(ctx.getSalesPoint() != null ? ctx.getSalesPoint().getUid() : null);
        EntityContainer ctr = EntityStorage.get().resolve(ctx.getSalesPoint());
        this.getSalesPointCountryCodes().clear();
        FlightPropertySet.addCountryCodes(this.getSalesPointCountryCodes(), ctr == null ? null : ((SalesPoint)ctr.getEntity()).getAddresses());
        EntityContainer agencyCtr = EntityStorage.get().resolve(ctx.getAgency());
        this.getAgencyCountryCodes().clear();
        FlightPropertySet.addCountryCodes(this.getAgencyCountryCodes(), agencyCtr == null ? null : ProfileHelper.getOrganizationAddresses((Organization)((Organization)agencyCtr.getEntity())));
        EntityReference agentRef = ctx.getAgent();
        this.getCreatedByClientHolder().setSupplier(() -> BookingHelper.isCreatedByClient((EntityReference)agentRef));
        this.employers.setSupplier(() -> BookingHelper.getEmployersOfBookingAgent((EntityReference)this.getAgent()));
    }

    private void update(DictionaryReference<PassengerType> passengerType) {
        this.setPassengerType(RulesHelper.getDictCode(passengerType));
        this.getPassengerTypeCategories().clear();
        this.getPassengerTypeCategories().addAll(RulesHelper.getPassengerTypeCategoryCodes(passengerType));
        Money fare = new Money();
        fare.setValue(FlightProxyHelper.calculateEquivalentFare(this.flight, passengerType, false));
        fare.setCurrency(DictHelper.getEquivCurrency());
        this.setBaseFare(fare);
        this.setFare(fare.getValue().doubleValue());
        BigDecimal equivFareAndTaxes = FlightProxyHelper.calculateEquivalentFare(this.flight, passengerType, true);
        this.setPrice(equivFareAndTaxes);
        this.getFareBasises().clear();
        this.setHasLuggage(false);
        this.setBrandName(null);
        boolean firstSegment = true;
        DictionaryReference prevLoc = null;
        for (FlightSegmentTariff st : this.flight.getSegmentTariffs()) {
            for (FlightSegment seg : st.getSegments()) {
                if (!firstSegment && !MiscUtil.equals(prevLoc, (Object)seg.getLocationBegin())) {
                    this.getFareBasises().add(null);
                }
                this.getFareBasises().add(this.findFareBasis(seg, this.flight, passengerType));
                for (FareInfo fi : seg.getFareInfos()) {
                    if (!MiscUtil.equals(passengerType, (Object)fi.getPassengerType())) continue;
                    if (firstSegment && fi.getFareDetails() != null) {
                        this.setBrandName(fi.getFareDetails().getBrandName());
                    }
                    if (fi.getLuggageInfo() != null && !fi.getLuggageInfo().isNil() && fi.getLuggageInfo().getQuantity() != null && fi.getLuggageInfo().getQuantity() > 0) {
                        this.setHasLuggage(true);
                        break;
                    }
                    if (!Boolean.TRUE.equals(GDSHelper.hasLuggage(fi.getFareDetails()))) continue;
                    this.setHasLuggage(true);
                    break;
                }
                firstSegment = false;
                prevLoc = seg.getLocationEnd();
            }
        }
    }

    private void update(PaymentType paymentType) {
        this.getPaymentTypes().clear();
        this.getPaymentTypes().add(paymentType.name());
        this.getClientPaymentTypes().clear();
        this.getClientPaymentTypes().add(paymentType.name());
        this.getTCHPaymentTypes().clear();
        this.getTCHPaymentTypes().add(paymentType.name());
    }

    protected FlightPropertySet() {
        this.getCustomParameters().put(Properties.CONNECTION_TIME.name(), new ArrayList());
        this.setProductCategory(ProductCategory.AIR.name());
        this.setIssueDate(new Date());
        this.setTargetType(ProductCategory.AIR.name());
        this.setCurrentDate(new Date());
        this.setReservationType(ReservationType.IBE.name());
    }

    public Collection<EntityReference<Person>> getTravellers() {
        return Collections.emptyList();
    }

    public List<CostCode> getCostCodes() {
        return this.costCodes;
    }

    private String[] getCodes(DictionaryReference<GeoLocation> departure) {
        if (departure == null) {
            return new String[0];
        }
        Set codes = new HashSet<String>();
        codes.add(departure.getCode());
        codes = RulesHelper.collectGeoCodes(codes, (boolean)true);
        return codes.toArray(new String[0]);
    }

    private void applyTravelDuration() {
        int duration = 0;
        for (FlightSegmentTariff st : this.flight.getSegmentTariffs()) {
            for (FlightSegment fs : st.getSegments()) {
                duration += fs.getTravelDuration();
            }
        }
        this.setTravelDuration(duration);
    }

    private void updateValidatingCarrierCountries(Flight flt) {
        Airline validatingCarrier = (Airline)DictionaryCache.get().resolveReference(flt.getCarrier());
        if (validatingCarrier == null || validatingCarrier.getCountry() == null) {
            return;
        }
        this.getPrimaryCarrierCountry().add(validatingCarrier.getCountry().getCode());
        Country country = (Country)DictionaryCache.get().resolveReference(validatingCarrier.getCountry());
        if (country != null) {
            this.getPrimaryCarrierCountry().addAll(country.getCodeVariants().values());
        }
    }

    private void applyGdsCurrency(Flight flt) {
        String gdsCurrencyCode = (String)MiscUtil.guarded((Object)NamedValueHelper.getValueForName((String)"gdsCurrency", (Collection)this.flight.getCustomProperties()), (Object)this.flight.getGdsCurrencyCode());
        if (gdsCurrencyCode != null) {
            try {
                this.setGdsCurrency(gdsCurrencyCode);
                this.setPriceCurrency(gdsCurrencyCode);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private String findFareBasis(FlightSegment seg, Flight aFlight, DictionaryReference<PassengerType> passengerType) {
        String fullMatchedFareBasis = null;
        String passengerTypeMatchedFareBasis = null;
        for (FareInfo fi : seg.getFareInfos()) {
            if (MiscUtil.equals(passengerType, (Object)fi.getPassengerType())) {
                fullMatchedFareBasis = fi.getFareBasis();
                passengerTypeMatchedFareBasis = fi.getFareBasis();
                break;
            }
            if (!TextUtil.isBlank(passengerTypeMatchedFareBasis) || !MiscUtil.equals(passengerType, (Object)fi.getPassengerType())) continue;
            passengerTypeMatchedFareBasis = fi.getFareBasis();
        }
        if (!TextUtil.isBlank(fullMatchedFareBasis)) {
            return fullMatchedFareBasis;
        }
        if (!TextUtil.isBlank(passengerTypeMatchedFareBasis)) {
            return passengerTypeMatchedFareBasis;
        }
        if (log.isDebugEnabled()) {
            log.debug(String.format("no farebasis found for flight %s for passenger type %s", FlightHelper.toString((Flight)aFlight), passengerType));
        }
        log.warn(String.format("no farebasis found for flight %s for passenger type %s", FlightHelper.toString((Flight)aFlight), passengerType));
        return null;
    }

    public Flight getFlight() {
        return this.flight;
    }

    public DictionaryReference<PassengerType> getPassengerTypeRef() {
        return this.passengerType;
    }

    private static void addCountryCodes(Set<String> codes, List<Address> addresses) {
        Country country;
        Address addr;
        Iterator<Address> iterator;
        CountryReference ref = null;
        if (addresses != null && (iterator = addresses.iterator()).hasNext() && (addr = iterator.next()).getCountry() != null) {
            ref = addr.getCountry();
        }
        if (ref == null) {
            ref = new CountryReference("RU");
        }
        if ((country = (Country)DictionaryCache.get().resolveReference(ref)) == null) {
            log.warn(String.format("unable to resolve country reference with code %s", ref.getCode()));
        } else {
            codes.addAll(country.getCodeVariants().values());
        }
    }

    public Collection<EntityReference<Organization>> getPayers() {
        return this.payers;
    }

    public TicketType getTicketType() {
        return TicketType.OWN;
    }

    public int getChildrenPerAdultCount() {
        return this.childrenPerAdultCount;
    }

    public ProductStatus getProductStatus() {
        return ProductStatus.BOOKING;
    }

    public List<EntityReference<Organization>> getEmployersOfBookingAgent() {
        return (List)this.employers.get();
    }

    public String getSalesOriginProvider() {
        return this.salesOriginProvider;
    }

    public String getSalesOriginContent() {
        return this.salesOriginContent;
    }

    public boolean isTimeLimitFromSupplierReceived() {
        return this.timeLimitFromSupplier != null;
    }

    public boolean isTimeLimitFromSupplierAfterDeparture() {
        return this.timeLimitFromSupplier.toInstant().atZone(ZoneId.systemDefault()).isAfter(DictHelper.getZonedDateTime((Date)this.getFirstSegmentDepartureDate(), (DictionaryReference)this.getFirstSegmentDepartureLocation(), (boolean)false));
    }
}

