/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.rules.proxy;

import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightFare;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.model.FlightSegmentTariff;
import com.gridnine.xtrip.common.gds.model.FlightTax;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.TransportationType;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.math.BigDecimal;

public final class FlightProxyHelper {
    public static BigDecimal calculateEquivalentFare(Flight flight, DictionaryReference<PassengerType> passengerType, boolean includeTaxes) {
        BigDecimal amount;
        BigDecimal result = BigDecimal.ZERO;
        for (FlightFare fare : flight.getFares()) {
            amount = fare.getEquivalentAmount();
            if (amount == null || (double)BigDecimal.ZERO.compareTo(amount) == 0.0 || !MiscUtil.equals((Object)fare.getPassengerType(), passengerType)) continue;
            result = result.add(amount);
        }
        if (!includeTaxes) {
            return result;
        }
        for (FlightTax tax : flight.getTaxes()) {
            amount = tax.getEquivalentAmount();
            if (amount == null || (double)BigDecimal.ZERO.compareTo(amount) == 0.0 || !MiscUtil.equals((Object)tax.getPassengerType(), passengerType)) continue;
            result = result.add(amount);
        }
        return result;
    }

    static TransportationType calculateTransportationType(Flight flight) {
        for (FlightSegmentTariff st : flight.getSegmentTariffs()) {
            for (FlightSegment seg : st.getSegments()) {
                Boolean domestic = FlightProxyHelper.isDomestic((DictionaryReference<GeoLocation>)seg.getLocationBegin());
                if (domestic != null && !domestic.booleanValue()) {
                    return TransportationType.INTERNATIONAL;
                }
                domestic = FlightProxyHelper.isDomestic((DictionaryReference<GeoLocation>)seg.getLocationEnd());
                if (domestic == null || domestic.booleanValue()) continue;
                return TransportationType.INTERNATIONAL;
            }
        }
        return TransportationType.DOMESTIC;
    }

    static TransportationType calculateTransportationType(DictionaryReference<GeoLocation> locBegin, DictionaryReference<GeoLocation> locEnd) {
        Boolean domestic = FlightProxyHelper.isDomestic(locBegin);
        if (domestic != null && !domestic.booleanValue()) {
            return TransportationType.INTERNATIONAL;
        }
        domestic = FlightProxyHelper.isDomestic(locEnd);
        if (domestic != null && !domestic.booleanValue()) {
            return TransportationType.INTERNATIONAL;
        }
        return TransportationType.DOMESTIC;
    }

    private static Boolean isDomestic(DictionaryReference<GeoLocation> ref) {
        if (ref == null) {
            return null;
        }
        DictionaryReference countryRef = DictHelper.getCountry(ref);
        Country country = (Country)DictionaryCache.get().resolveReference(countryRef);
        if (country == null) {
            return null;
        }
        return country.isDomestic();
    }

    private FlightProxyHelper() {
    }
}

