/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.rules.proxy;

import com.gridnine.xtrip.common.gds.model.BaseAirGdsAccount;
import com.gridnine.xtrip.common.gds.model.TravelDocType;
import com.gridnine.xtrip.common.gds.rules.GDSParametersActionsProvider;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.TimeLimitType;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.AirlineReference;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.model.profile.Pcc;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.rules.standard.TimeLimitActionsProvider;
import com.gridnine.xtrip.common.util.TextUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class GDSParametersActions
implements Serializable,
GDSParametersActionsProvider,
TimeLimitActionsProvider {
    private static final long serialVersionUID = -3251065530635903368L;
    private boolean autoTicketingEnabled;
    private Boolean subsidizedTariff;
    private DictionaryReference<Airline> validatingCarrier;
    private EntityReference<Organization> blankOwner;
    private String sabrePrinterType;
    private String searchPCC;
    private NestedEntityReference<SalesPoint, Pcc> searchPCCRef;
    private String bookingPCC;
    private NestedEntityReference<SalesPoint, Pcc> bookingPCCRef;
    private String ticketingPCC;
    private NestedEntityReference<SalesPoint, Pcc> ticketingPCCRef;
    private String fopReplacementCode;
    private String endorsement;
    private List<String> remarks = new ArrayList<String>();
    private final Set<DictionaryReference<Airline>> preferredAirlines = new LinkedHashSet<DictionaryReference<Airline>>();
    private boolean excludeFromResult;
    private boolean issuingUrgent;
    private TravelDocType travelDocType;
    private final Set<EntityReference<BaseAirGdsAccount>> applicableGdsAccounts = new HashSet<EntityReference<BaseAirGdsAccount>>();
    private Tax segmentHiddenTax;
    private Tax ticketHiddenTax;
    private EntityReference<BaseAirGdsAccount> usedGdsAccount;
    private EntityReference<BaseAirGdsAccount> charterGdsAccount;
    private EntityReference<BaseAirGdsAccount> sabreEmulatorGdsAccount;
    private TimeLimitType timeLimitType;
    private int timeForTimeLimit;
    private List<Integer> timeForWarningAboutExpiringTime = new ArrayList<Integer>();
    private boolean hideAdditionalFares;

    public void setHideAdditionalFares(boolean hideAdditionalFares) {
        this.hideAdditionalFares = hideAdditionalFares;
    }

    public boolean isHideAdditionalFares() {
        return this.hideAdditionalFares;
    }

    public void addApplicableGDSAccount(EntityReference<BaseAirGdsAccount> account) {
        if (account != null) {
            this.applicableGdsAccounts.add(account);
        }
    }

    public Set<EntityReference<BaseAirGdsAccount>> getApplicableGdsAccounts() {
        return this.applicableGdsAccounts;
    }

    public boolean isAutoTicketingEnabled() {
        return this.autoTicketingEnabled;
    }

    public void setAutoTicketingEnabled(boolean value) {
        this.autoTicketingEnabled = value;
    }

    public DictionaryReference<Airline> getValidatingCarrier() {
        return this.validatingCarrier;
    }

    public void setValidatingCarrier(String value) {
        this.validatingCarrier = TextUtil.isBlank((String)value) ? null : new AirlineReference(value);
    }

    public String getTicketingPCC() {
        return this.ticketingPCC;
    }

    public void setTicketingPCC(String value) {
        this.ticketingPCC = value;
    }

    public NestedEntityReference<SalesPoint, Pcc> getTicketingPCCRef() {
        return this.ticketingPCCRef;
    }

    public void setTicketingPCCRef(NestedEntityReference<SalesPoint, Pcc> value) {
        this.ticketingPCCRef = value;
    }

    public String getFopReplacementCode() {
        return this.fopReplacementCode;
    }

    public void setFopReplacementCode(String value) {
        this.fopReplacementCode = value;
    }

    public EntityReference<Organization> getBlankOwner() {
        return this.blankOwner;
    }

    public void setBlankOwner(String value) throws Exception {
        if (TextUtil.isBlank((String)value)) {
            this.blankOwner = null;
            return;
        }
        EntityContainer ctr = EntityStorage.get().find(OrganizationIndex.class, OrganizationIndex.Property.code.name(), (Object)value);
        if (ctr == null) {
            throw new Exception(String.format("can't find organization profile with code %s", value));
        }
        if (!((Organization)ctr.getEntity()).getTypes().contains(OrganizationType.BLANK_OWNER)) {
            throw new Exception(String.format("organization with code %s is not a blank owner", value));
        }
        this.blankOwner = ctr.toReference();
    }

    public String getSabrePrinterType() {
        return this.sabrePrinterType;
    }

    public void setSabrePrinterType(String sabrePrinterType) {
        this.sabrePrinterType = sabrePrinterType;
    }

    public String getSearchPCC() {
        return this.searchPCC;
    }

    public void setSearchPCC(String value) {
        this.searchPCC = value;
    }

    public NestedEntityReference<SalesPoint, Pcc> getSearchPCCRef() {
        return this.searchPCCRef;
    }

    public void setSearchPCCRef(NestedEntityReference<SalesPoint, Pcc> value) {
        this.searchPCCRef = value;
    }

    public String getBookingPCC() {
        return this.bookingPCC;
    }

    public void setBookingPCC(String value) {
        this.bookingPCC = value;
    }

    public NestedEntityReference<SalesPoint, Pcc> getBookingPCCRef() {
        return this.bookingPCCRef;
    }

    public void setBookingPCCRef(NestedEntityReference<SalesPoint, Pcc> value) {
        this.bookingPCCRef = value;
    }

    public boolean isExcludeFromResult() {
        return this.excludeFromResult;
    }

    public void setExcludeFromResult(boolean value) {
        this.excludeFromResult = value;
    }

    public void addPreferredAirline(String code) {
        if (!TextUtil.isBlank((String)code)) {
            this.preferredAirlines.add((DictionaryReference<Airline>)new AirlineReference(code));
        }
    }

    public Set<DictionaryReference<Airline>> getPreferredAirlines() {
        return this.preferredAirlines;
    }

    public boolean isIssuingUrgent() {
        return this.issuingUrgent;
    }

    public void setIssuingUrgent(boolean value) {
        this.issuingUrgent = value;
    }

    public boolean isSubsidizedTariff() {
        return Boolean.TRUE.equals(this.subsidizedTariff);
    }

    public void setSubsidizedTariff(boolean value) {
        this.subsidizedTariff = value;
    }

    public boolean isSubsidizedTariffFlagSet() {
        return this.subsidizedTariff != null;
    }

    public String getEndorsement() {
        return this.endorsement;
    }

    public void setEndorsement(String value) {
        this.endorsement = value;
    }

    public List<String> getRemarks() {
        return this.remarks;
    }

    public void addRemark(String value) {
        if (!TextUtil.isBlank((String)value)) {
            this.remarks.add(value);
        }
    }

    public TravelDocType getTravelDocType() {
        return this.travelDocType;
    }

    public void setTravelDocType(TravelDocType type) {
        this.travelDocType = type;
    }

    public EntityReference<BaseAirGdsAccount> getUsedGdsAccount() {
        return this.usedGdsAccount;
    }

    public void setUsedGdsAccount(EntityReference<BaseAirGdsAccount> usedGdsAccount) {
        this.usedGdsAccount = usedGdsAccount;
    }

    public EntityReference<BaseAirGdsAccount> getCharterGdsAccount() {
        return this.charterGdsAccount;
    }

    public void setCharterGdsAccount(EntityReference<BaseAirGdsAccount> charterGdsAccount) {
        this.charterGdsAccount = charterGdsAccount;
    }

    public void setSabreEmulatorGdsAccount(EntityReference<BaseAirGdsAccount> gdsAccount) {
        this.sabreEmulatorGdsAccount = gdsAccount;
    }

    public EntityReference<BaseAirGdsAccount> getSabreEmulatorGdsAccount() {
        return this.sabreEmulatorGdsAccount;
    }

    public TimeLimitType getTimeLimitType() {
        return this.timeLimitType;
    }

    public void setTimeLimitType(TimeLimitType type) {
        this.timeLimitType = type;
    }

    public int getTimeForTimeLimit() {
        return this.timeForTimeLimit;
    }

    public void setTimeForTimeLimit(int time) {
        this.timeForTimeLimit = time;
    }

    public List<Integer> getWarningAboutExpiringTime() {
        return this.timeForWarningAboutExpiringTime;
    }
}

