/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.rules.proxy;

import com.gridnine.xtrip.common.gds.model.BaseGdsAccount;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.model.FlightSegmentTariff;
import com.gridnine.xtrip.common.gds.model.RouteSegment;
import com.gridnine.xtrip.common.gds.model.RouteType;
import com.gridnine.xtrip.common.gds.model.ScheduleSearchParameters;
import com.gridnine.xtrip.common.gds.rules.GDSParametersPropertiesProvider;
import com.gridnine.xtrip.common.midoffice.helper.CommonHelper;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.rules.standard.Constants;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class GDSParametersProperties
implements Serializable,
GDSParametersPropertiesProvider {
    private static final long serialVersionUID = 3984635366116808299L;
    private final Set<String> subagencyCodes = new HashSet<String>();
    private final Set<String> profileGroups = new HashSet<String>();
    private final Set<String> allLocations = new HashSet<String>();
    private final Set<String> arrivalLocations = new HashSet<String>();
    private final Set<String> departureLocations = new HashSet<String>();
    private final List<String[]> visitedCities = new ArrayList<String[]>();
    private final List<String[]> visitedGeoLocations = new ArrayList<String[]>();
    private Date departureDate;
    private String transportationType;
    private RouteType routeType;
    private final String gdsName;
    private final EntityReference<? extends BaseGdsAccount> gdsAccount;
    private EntityReference<Person> agent;
    private EntityReference<Organization> client;
    private String agencyCode;

    public GDSParametersProperties(SalesContext ctx, RuleProxy<?, ?> proxy) {
        proxy.getTracer().traceEnteringMethod(this.getClass(), "ctor()", new String[0]);
        try {
            this.gdsName = null;
            this.gdsAccount = null;
            this.addSubagencyCodes((EntityReference<Organization>)ctx.getSubagency());
            this.agent = ctx.getAgent();
            this.client = ctx.getClient();
            this.agencyCode = CommonHelper.getAgencyCode((SalesContext)ctx);
        }
        finally {
            proxy.getTracer().traceObject("proxy", (Object)this);
            proxy.getTracer().traceExitingMethod(this.getClass(), "ctor()", new String[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GDSParametersProperties(GdsName gds, EntityReference<BaseGdsAccount> gdsAccountValue, SalesContext ctx, RuleProxy<?, ?> proxy) {
        proxy.getTracer().traceEnteringMethod(this.getClass(), "ctor()", new String[0]);
        try {
            this.gdsName = gds.name();
            this.gdsAccount = gdsAccountValue;
            this.addSubagencyCodes((EntityReference<Organization>)ctx.getSubagency());
            this.agent = ctx.getAgent();
            this.client = ctx.getClient();
            this.agencyCode = CommonHelper.getAgencyCode((SalesContext)ctx);
        }
        finally {
            proxy.getTracer().traceObject("proxy", (Object)this);
            proxy.getTracer().traceExitingMethod(this.getClass(), "ctor()", new String[0]);
        }
    }

    private void addSubagencyCodes(EntityReference<Organization> agencyRef) {
        if (agencyRef != null) {
            try {
                Organization agency = (Organization)EntityStorage.get().resolve(agencyRef).getEntity();
                this.subagencyCodes.add(agency.getCode());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GDSParametersProperties(List<? extends RouteSegment> route, SalesContext salesContext, GdsName gds, EntityReference<BaseGdsAccount> gdsAccountValue, RuleProxy<?, ?> proxy) {
        proxy.getTracer().traceEnteringMethod(this.getClass(), "ctor()", new String[0]);
        try {
            this.routeType = GDSHelper.getRouteType(route);
            ArrayList lvgl = new ArrayList();
            for (int i = 0; i < route.size(); ++i) {
                Country country;
                Set codes;
                RouteSegment seg = route.get(i);
                if (this.departureDate == null) {
                    this.departureDate = seg.getDate();
                }
                if (seg.getLocationBegin() != null) {
                    codes = RulesHelper.collectGeoCodes(Collections.singleton(seg.getLocationBegin().getCode()), (boolean)true, (boolean)true);
                    this.visitedCities.add(codes.toArray(new String[0]));
                    this.allLocations.addAll(codes);
                    if (i == 0) {
                        this.departureLocations.addAll(codes);
                    }
                    if (this.transportationType == null && (country = DictHelper.findCountry((String)seg.getLocationBegin().getCode())) != null && !country.isDomestic()) {
                        this.transportationType = Constants.TRANSPORTATION_INTRENATIONAL.name();
                    }
                }
                if (seg.getLocationEnd() != null) {
                    codes = RulesHelper.collectGeoCodes(Collections.singleton(seg.getLocationEnd().getCode()), (boolean)true, (boolean)true);
                    this.visitedCities.add(codes.toArray(new String[0]));
                    this.allLocations.addAll(codes);
                    if (i == route.size() - 1) {
                        this.arrivalLocations.addAll(codes);
                    }
                    if (this.transportationType == null && (country = DictHelper.findCountry((String)seg.getLocationEnd().getCode())) != null && !country.isDomestic()) {
                        this.transportationType = Constants.TRANSPORTATION_INTRENATIONAL.name();
                    }
                }
                ArrayList<DictionaryReference> referenceList = new ArrayList<DictionaryReference>();
                referenceList.add(seg.getLocationBegin());
                referenceList.add(seg.getLocationEnd());
                for (DictionaryReference reference : referenceList) {
                    HashSet<String> geoCodes = new HashSet<String>();
                    geoCodes.add(reference.getCode());
                    geoCodes.addAll(RulesHelper.collectGeoCodes(geoCodes, (boolean)true));
                    geoCodes.addAll(RulesHelper.collectGeoCodes((DictionaryReference)reference, (boolean)true, (boolean)true));
                    if (!lvgl.isEmpty() && ((Set)lvgl.get(lvgl.size() - 1)).equals(geoCodes)) continue;
                    lvgl.add(geoCodes);
                }
            }
            this.getVisitedGeolocations().addAll(RulesHelper.fillVisitedGeolocations(lvgl));
            if (this.transportationType == null) {
                this.transportationType = Constants.TRANSPORTATION_DOMESTIC.name();
            }
            String string = this.gdsName = gds == null ? null : gds.name();
            if (salesContext != null) {
                this.addSubagencyCodes((EntityReference<Organization>)salesContext.getSubagency());
                this.agent = salesContext.getAgent();
                this.agencyCode = CommonHelper.getAgencyCode((SalesContext)salesContext);
                this.client = salesContext.getClient();
            }
            this.gdsAccount = gdsAccountValue;
        }
        finally {
            proxy.getTracer().traceObject("proxy", (Object)this);
            proxy.getTracer().traceExitingMethod(this.getClass(), "ctor()", new String[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GDSParametersProperties(ScheduleSearchParameters searchParameters, SalesContext salesContext, GdsName gds, EntityReference<BaseGdsAccount> gdsAccountValue, RuleProxy<?, ?> proxy) {
        proxy.getTracer().traceEnteringMethod(this.getClass(), "ctor()", new String[0]);
        try {
            Country country;
            Set codes;
            if (searchParameters.getLocationBegin() != null) {
                codes = RulesHelper.collectGeoCodes(Collections.singleton(searchParameters.getLocationBegin().getCode()), (boolean)true, (boolean)true);
                this.visitedCities.add(codes.toArray(new String[0]));
                this.allLocations.addAll(codes);
                this.departureLocations.addAll(codes);
                if (this.transportationType == null && (country = DictHelper.findCountry((String)searchParameters.getLocationBegin().getCode())) != null && !country.isDomestic()) {
                    this.transportationType = Constants.TRANSPORTATION_INTRENATIONAL.name();
                }
            }
            if (searchParameters.getLocationEnd() != null) {
                codes = RulesHelper.collectGeoCodes(Collections.singleton(searchParameters.getLocationEnd().getCode()), (boolean)true, (boolean)true);
                this.visitedCities.add(codes.toArray(new String[0]));
                this.allLocations.addAll(codes);
                this.arrivalLocations.addAll(codes);
                if (this.transportationType == null && (country = DictHelper.findCountry((String)searchParameters.getLocationEnd().getCode())) != null && !country.isDomestic()) {
                    this.transportationType = Constants.TRANSPORTATION_INTRENATIONAL.name();
                }
            }
            if (this.transportationType == null) {
                this.transportationType = Constants.TRANSPORTATION_DOMESTIC.name();
            }
            this.gdsName = gds != null ? gds.name() : null;
            this.gdsAccount = gdsAccountValue;
            if (salesContext != null) {
                this.addSubagencyCodes((EntityReference<Organization>)salesContext.getSubagency());
                this.agent = salesContext.getAgent();
                this.agencyCode = CommonHelper.getAgencyCode((SalesContext)salesContext);
                this.client = salesContext.getClient();
            }
        }
        finally {
            proxy.getTracer().traceObject("proxy", (Object)this);
            proxy.getTracer().traceExitingMethod(this.getClass(), "ctor()", new String[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GDSParametersProperties(Flight flight, SalesContext ctx, RuleProxy<?, ?> proxy) {
        proxy.getTracer().traceEnteringMethod(this.getClass(), "ctor()", new String[0]);
        try {
            for (FlightSegmentTariff st : flight.getSegmentTariffs()) {
                for (FlightSegment seg : st.getSegments()) {
                    Country country;
                    Set codes;
                    if (this.departureDate == null) {
                        this.departureDate = seg.getDateBegin();
                    }
                    if (seg.getLocationBegin() != null) {
                        codes = RulesHelper.collectGeoCodes(Collections.singleton(seg.getLocationBegin().getCode()), (boolean)true, (boolean)true);
                        this.visitedCities.add(codes.toArray(new String[0]));
                        this.allLocations.addAll(codes);
                        this.departureLocations.addAll(codes);
                        if (this.transportationType == null && (country = DictHelper.findCountry((String)seg.getLocationBegin().getCode())) != null && !country.isDomestic()) {
                            this.transportationType = Constants.TRANSPORTATION_INTRENATIONAL.name();
                        }
                    }
                    if (seg.getLocationEnd() == null) continue;
                    codes = RulesHelper.collectGeoCodes(Collections.singleton(seg.getLocationEnd().getCode()), (boolean)true, (boolean)true);
                    this.visitedCities.add(codes.toArray(new String[0]));
                    this.allLocations.addAll(codes);
                    this.arrivalLocations.addAll(codes);
                    if (this.transportationType != null || (country = DictHelper.findCountry((String)seg.getLocationEnd().getCode())) == null || country.isDomestic()) continue;
                    this.transportationType = Constants.TRANSPORTATION_INTRENATIONAL.name();
                }
            }
            if (this.transportationType == null) {
                this.transportationType = Constants.TRANSPORTATION_DOMESTIC.name();
            }
            this.gdsName = flight.getGds() != null ? flight.getGds().name() : null;
            this.gdsAccount = flight.getGdsAccount();
            if (ctx != null) {
                this.addSubagencyCodes((EntityReference<Organization>)ctx.getSubagency());
                this.agent = ctx.getAgent();
                this.agencyCode = CommonHelper.getAgencyCode((SalesContext)ctx);
                this.client = ctx.getClient();
            }
        }
        finally {
            proxy.getTracer().traceObject("proxy", (Object)this);
            proxy.getTracer().traceExitingMethod(this.getClass(), "ctor()", new String[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GDSParametersProperties(Product product, SalesContext ctx, RuleProxy<?, ?> proxy) {
        proxy.getTracer().traceEnteringMethod(this.getClass(), "ctor()", new String[0]);
        try {
            for (SegmentTariff st : product.getSegmentTariffs()) {
                for (Segment seg : st.getSegments()) {
                    Country country;
                    Set codes;
                    if (this.departureDate == null) {
                        this.departureDate = seg.getStartDate();
                    }
                    if (seg.getDepartureLocation() != null) {
                        codes = RulesHelper.collectGeoCodes(Collections.singleton(seg.getDepartureLocation().getCode()), (boolean)true, (boolean)true);
                        this.visitedCities.add(codes.toArray(new String[0]));
                        this.allLocations.addAll(codes);
                        this.departureLocations.addAll(codes);
                        if (this.transportationType == null && (country = DictHelper.findCountry((String)seg.getDepartureLocation().getCode())) != null && !country.isDomestic()) {
                            this.transportationType = Constants.TRANSPORTATION_INTRENATIONAL.name();
                        }
                    }
                    if (seg.getArriveLocation() == null) continue;
                    codes = RulesHelper.collectGeoCodes(Collections.singleton(seg.getArriveLocation().getCode()), (boolean)true, (boolean)true);
                    this.visitedCities.add(codes.toArray(new String[0]));
                    this.allLocations.addAll(codes);
                    this.arrivalLocations.addAll(codes);
                    if (this.transportationType != null || (country = DictHelper.findCountry((String)seg.getArriveLocation().getCode())) == null || country.isDomestic()) continue;
                    this.transportationType = Constants.TRANSPORTATION_INTRENATIONAL.name();
                }
            }
            if (this.transportationType == null) {
                this.transportationType = Constants.TRANSPORTATION_DOMESTIC.name();
            }
            EntityReference gdsAccountRef = product.getReservation().getGdsNameInfo().getOnlineGdsAccount();
            this.gdsName = ((BaseGdsAccount)EntityStorage.get().resolve(gdsAccountRef).getEntity()).getGds().name();
            this.gdsAccount = gdsAccountRef;
            if (ctx != null) {
                this.addSubagencyCodes((EntityReference<Organization>)ctx.getSubagency());
                this.agencyCode = CommonHelper.getAgencyCode((SalesContext)ctx);
                this.client = ctx.getClient();
            }
            this.agent = product.getCashier();
        }
        finally {
            proxy.getTracer().traceObject("proxy", (Object)this);
            proxy.getTracer().traceExitingMethod(this.getClass(), "ctor()", new String[0]);
        }
    }

    public Set<String> getAllLocations() {
        return this.allLocations;
    }

    public Set<String> getSubagencyCodes() {
        return this.subagencyCodes;
    }

    public Set<String> getProfileGroups() {
        return this.profileGroups;
    }

    public Set<String> getArrivalLocations() {
        return this.arrivalLocations;
    }

    public Set<String> getDepartureLocations() {
        return this.departureLocations;
    }

    public List<String[]> getVisitedCities() {
        return this.visitedCities;
    }

    public Date getDepartureDate() {
        return this.departureDate;
    }

    public boolean isEticket() {
        return true;
    }

    public String getTransportationType() {
        return this.transportationType;
    }

    public String getGdsName() {
        return this.gdsName;
    }

    public List<List<String[]>> getFlightSegments() {
        return Collections.emptyList();
    }

    public List<String[]> getVisitedGeolocations() {
        return this.visitedGeoLocations;
    }

    public boolean isHasAirlineBonusCards() {
        return false;
    }

    public RouteType getRouteType() {
        return this.routeType;
    }

    public EntityReference<Person> getAgent() {
        return this.agent;
    }

    public EntityReference<Organization> getClient() {
        return this.client;
    }

    public EntityReference<? extends BaseGdsAccount> getGdsAccount() {
        return this.gdsAccount;
    }

    public String getAgencyCode() {
        return this.agencyCode;
    }
}

