/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.storage;

import com.gridnine.xtrip.common.gds.helper.PccHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ReservationSystemInfo;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.profile.Pcc;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.model.EntityInterceptor;
import com.gridnine.xtrip.server.model.licence2.AppConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BookingFileContainerInterceptor
implements EntityInterceptor {
    private static final Logger log = LoggerFactory.getLogger(BookingFileContainerInterceptor.class);
    public static final double PRIORITY = 2.8;

    public double getPriority() {
        return 2.8;
    }

    public void onSave(SessionCallback ss, EntityContainer<?> data) throws Exception {
        if (!BookingFile.class.getName().equals(data.getEntityType().getName())) {
            return;
        }
        if (!AppConfiguration.get().isOnlineGdsEnabled()) {
            return;
        }
        EntityContainer<?> bfCtr = data;
        this.restoreGdsAccount(bfCtr);
    }

    private void restoreGdsAccount(EntityContainer<BookingFile> bfCtr) {
        BookingFile bf = (BookingFile)bfCtr.getEntity();
        for (Reservation reservation : bf.getReservations()) {
            if (reservation.getGdsNameInfo().getOnlineGdsAccount() != null) continue;
            for (ReservationSystemInfo systemInfo : reservation.getGdsNameInfo().getSystemInfos()) {
                try {
                    Pcc pcc = reservation.getSalesPoint() != null ? PccHelper.findPcc((EntityReference)reservation.getSalesPoint(), (String)systemInfo.getBookingPcc(), (GdsName)systemInfo.getGdsName()) : PccHelper.findPcc((String)systemInfo.getBookingPcc(), (GdsName)systemInfo.getGdsName());
                    if (pcc != null) {
                        reservation.getGdsNameInfo().setOnlineGdsAccount(pcc.getGdsAccount());
                        continue;
                    }
                    log.error(String.format("failed restoring gds account in reservation %s of booking file %s by booking pcc %s : pcc not found", reservation.getUid(), bf.getUid(), systemInfo.getBookingPcc()));
                }
                catch (Exception ex) {
                    log.error(String.format("failed restoring gds account in reservation %s of booking file %s by booking pcc %s", reservation.getUid(), bf.getUid(), systemInfo.getBookingPcc()), (Throwable)ex);
                }
            }
        }
    }

    public void onDelete(SessionCallback ss, EntityContainer<?> data) throws Exception {
    }
}

