/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.storage;

import com.gridnine.xtrip.common.gds.stat.GDSStatEntry;
import com.gridnine.xtrip.common.gds.stat.RouteItem;
import com.gridnine.xtrip.common.gds.stat.SeatsItem;
import com.gridnine.xtrip.common.gds.stat.TraceDataItem;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.dict.AirlineReference;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.db.storage.model.BaseAssetData;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Lob;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Index;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

@Entity
public class GDSStatEntryData
extends BaseAssetData<GDSStatEntry> {
    @Temporal(value=TemporalType.TIMESTAMP)
    @Index(name="GDSStatEntryData_modified")
    private Date modified;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Index(name="GDSStatEntryData_date")
    private Date entryDate;
    @Index(name="GDSStatEntryData_user")
    private String entryUser;
    @Index(name="GDSStatEntryData_session")
    private String entrySession;
    @Enumerated(value=EnumType.STRING)
    @Index(name="GDSStatEntryData_gds")
    private GdsName gds;
    @Index(name="GDSStatEntryData_transactionNames")
    @Column(length=512)
    private String transactionNames;
    @Index(name="GDSStatEntryData_timing")
    private long timing;
    @Index(name="GDSStatEntryData_pnr")
    private String pnr;
    @Lob
    @Column(length=0x100000)
    private byte[] salesContextData;
    @Index(name="GDSStatEntryData_agencyUid")
    private String agencyUid;
    @Index(name="GDSStatEntryData_agentUid")
    private String agentUid;
    @Index(name="GDSStatEntryData_corporateClientUid")
    private String corporateClientUid;
    @Index(name="GDSStatEntryData_customerUid")
    private String customerUid;
    @Index(name="GDSStatEntryData_salesPointUid")
    private String salesPointUid;
    @Index(name="GDSStatEntryData_airline")
    private String airline;
    @Lob
    @Column(length=0x100000)
    private byte[] routeData;
    @Index(name="GDSStatEntryData_routeLocations")
    private String routeLocations;
    @Lob
    @Column(length=0x100000)
    private byte[] seatsData;
    @Index(name="GDSStatEntryData_passengerTypes")
    private String passengerTypes;
    @Lob
    @Column(length=0xA00000)
    private byte[] errorData;
    @Index(name="GDSStatEntryData_errorMessage")
    private String errorMessage;
    @Lob
    @Column(length=0x40000000)
    private byte[] traceData;

    public Date getModified() {
        return this.modified;
    }

    public void setModified(Date date) {
        this.modified = date;
    }

    public GDSStatEntry toAsset(Set<String> preferredProperties) throws Exception {
        RouteItem item;
        GDSStatEntry result = new GDSStatEntry(this.getUid());
        result.setModified(this.modified);
        if (preferredProperties.isEmpty() || preferredProperties.contains(GDSStatEntry.Property.entryDate.name())) {
            result.setDate(this.entryDate);
        }
        if (preferredProperties.isEmpty() || preferredProperties.contains(GDSStatEntry.Property.entryUser.name())) {
            result.setUser(this.entryUser);
        }
        if (preferredProperties.isEmpty() || preferredProperties.contains(GDSStatEntry.Property.entrySession.name())) {
            result.setSession(this.entrySession);
        }
        if (preferredProperties.isEmpty() || preferredProperties.contains(GDSStatEntry.Property.gds.name())) {
            result.setGds(this.gds);
        }
        if (preferredProperties.isEmpty() || preferredProperties.contains(GDSStatEntry.Property.transactionNames.name())) {
            this.parseNames(result.getTransactionNames(), this.transactionNames);
        }
        if (preferredProperties.isEmpty() || preferredProperties.contains(GDSStatEntry.Property.timing.name())) {
            result.setTiming(this.timing);
        }
        if (preferredProperties.isEmpty() || preferredProperties.contains(GDSStatEntry.Property.pnr.name())) {
            result.setPnr(this.pnr);
        }
        if ((preferredProperties.isEmpty() || preferredProperties.contains("salesContext")) && this.salesContextData != null && this.salesContextData.length > 0) {
            result.setSalesContext(new SalesContext());
            result.getSalesContext().fromXML(DocumentBuilderHelper.parse((InputSource)XUtil.createSource((InputStream)new ByteArrayInputStream(this.salesContextData))).getDocumentElement());
        }
        if ((preferredProperties.isEmpty() || preferredProperties.contains(GDSStatEntry.Property.airline.name())) && !TextUtil.isBlank((String)this.airline)) {
            result.setAirline((DictionaryReference)new AirlineReference(this.airline));
        }
        if ((preferredProperties.isEmpty() || preferredProperties.contains("route")) && this.routeData != null && this.routeData.length > 0) {
            for (Element elm : XmlUtil.getElements((Element)DocumentBuilderHelper.parse((InputSource)XUtil.createSource((InputStream)new ByteArrayInputStream(this.routeData))).getDocumentElement(), (String)"object")) {
                item = new RouteItem();
                item.fromXML(elm);
                result.getRoute().add(item);
            }
        }
        if ((preferredProperties.isEmpty() || preferredProperties.contains("seats")) && this.seatsData != null && this.seatsData.length > 0) {
            for (Element elm : XmlUtil.getElements((Element)DocumentBuilderHelper.parse((InputSource)XUtil.createSource((InputStream)new ByteArrayInputStream(this.seatsData))).getDocumentElement(), (String)"object")) {
                item = new SeatsItem();
                item.fromXML(elm);
                result.getSeats().add(item);
            }
        }
        if ((preferredProperties.isEmpty() || preferredProperties.contains(GDSStatEntry.Property.errorMessage.name())) && this.errorData != null && this.errorData.length > 0) {
            result.setError(new Message());
            result.getError().fromXML(DocumentBuilderHelper.parse((InputSource)XUtil.createSource((InputStream)new ByteArrayInputStream(this.errorData))).getDocumentElement());
        }
        if ((preferredProperties.isEmpty() || preferredProperties.contains("trace")) && this.traceData != null && this.traceData.length > 0) {
            for (Element elm : XmlUtil.getElements((Element)DocumentBuilderHelper.parse((InputSource)XUtil.createSource((InputStream)new ByteArrayInputStream(this.traceData))).getDocumentElement(), (String)"object")) {
                item = new TraceDataItem();
                item.fromXML(elm);
                result.getTrace().add(item);
            }
        }
        return result;
    }

    private void parseNames(List<String> result, String str) {
        if (TextUtil.isBlank((String)str)) {
            return;
        }
        for (String name : str.split("\\|")) {
            if (TextUtil.isBlank((String)name)) continue;
            result.add(name);
        }
    }

    public void fromAsset(GDSStatEntry asset) throws Exception {
        ByteArrayOutputStream strm;
        this.setUid(asset.getUid());
        this.modified = asset.getModified();
        this.entryDate = asset.getDate();
        this.entryUser = asset.getUser();
        this.entrySession = asset.getSession();
        this.gds = asset.getGds();
        this.transactionNames = this.buildNames(asset.getTransactionNames());
        this.timing = asset.getTiming();
        this.pnr = asset.getPnr();
        if (asset.getSalesContext() != null) {
            strm = new ByteArrayOutputStream();
            XUtil.serialize((XSerializable)asset.getSalesContext(), (OutputStream)strm);
            this.salesContextData = strm.toByteArray();
            if (asset.getSalesContext().getAgency() != null) {
                this.agencyUid = asset.getSalesContext().getAgency().getUid();
            }
            if (asset.getSalesContext().getAgent() != null) {
                this.agentUid = asset.getSalesContext().getAgent().getUid();
            }
            if (asset.getSalesContext().getClient() != null) {
                this.corporateClientUid = asset.getSalesContext().getClient().getUid();
            }
            if (asset.getSalesContext().getCustomer() != null) {
                this.customerUid = asset.getSalesContext().getCustomer().getUid();
            }
            if (asset.getSalesContext().getSalesPoint() != null) {
                this.salesPointUid = asset.getSalesContext().getSalesPoint().getUid();
            }
        }
        if (asset.getAirline() != null) {
            this.airline = asset.getAirline().getCode();
        }
        if (!asset.getRoute().isEmpty()) {
            strm = new ByteArrayOutputStream();
            XUtil.serialize((Iterable)asset.getRoute(), (OutputStream)strm);
            this.routeData = strm.toByteArray();
            this.routeLocations = this.buildLocations(asset.getRoute());
        }
        if (!asset.getSeats().isEmpty()) {
            strm = new ByteArrayOutputStream();
            XUtil.serialize((Iterable)asset.getSeats(), (OutputStream)strm);
            this.seatsData = strm.toByteArray();
            this.passengerTypes = this.buildPassengerTypes(asset.getSeats());
        }
        if (asset.getError() != null) {
            strm = new ByteArrayOutputStream();
            XUtil.serialize((XSerializable)asset.getError(), (OutputStream)strm);
            this.errorData = strm.toByteArray();
            String string = this.errorMessage = asset.getError().getMessage() == null ? asset.getError().toString() : asset.getError().getMessage().toString();
        }
        if (!asset.getTrace().isEmpty()) {
            strm = new ByteArrayOutputStream();
            XUtil.serialize((Iterable)asset.getTrace(), (OutputStream)strm);
            this.traceData = strm.toByteArray();
        }
    }

    private String buildNames(List<String> names) {
        if (names.isEmpty()) {
            return "";
        }
        StringBuilder result = new StringBuilder("|");
        for (String name : names) {
            if (TextUtil.isBlank((String)name)) continue;
            result.append(name).append('|');
        }
        return result.toString();
    }

    private String buildLocations(List<RouteItem> route) {
        StringBuilder result = new StringBuilder("|");
        for (RouteItem item : route) {
            if (item.getBegin() != null) {
                result.append(item.getBegin().getCode());
            }
            result.append('-');
            if (item.getEnd() != null) {
                result.append(item.getEnd().getCode());
            }
            result.append('|');
        }
        return result.toString();
    }

    private String buildPassengerTypes(List<SeatsItem> seats) {
        StringBuilder result = new StringBuilder("|");
        for (SeatsItem item : seats) {
            if (item.getPassengerType() == null) continue;
            result.append(item.getPassengerType().getCode()).append('|');
        }
        return result.toString();
    }

    public byte[] getSalesContextData() {
        return this.salesContextData;
    }

    public void setSalesContextData(byte[] salesContextData) {
        this.salesContextData = salesContextData;
    }

    public byte[] getRouteData() {
        return this.routeData;
    }

    public void setRouteData(byte[] routeData) {
        this.routeData = routeData;
    }

    public byte[] getSeatsData() {
        return this.seatsData;
    }

    public void setSeatsData(byte[] seatsData) {
        this.seatsData = seatsData;
    }

    public byte[] getErrorData() {
        return this.errorData;
    }

    public void setErrorData(byte[] errorData) {
        this.errorData = errorData;
    }

    public byte[] getTraceData() {
        return this.traceData;
    }

    public void setTraceData(byte[] traceData) {
        this.traceData = traceData;
    }

    public static enum Property {
        salesContextData,
        routeData,
        seatsData,
        errorData,
        traceData;

    }
}

