/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.storage;

import com.gridnine.xtrip.common.gds.model.GdsBookabilityItem;
import com.gridnine.xtrip.common.gds.model.GdsBookabilityItemIndex;
import com.gridnine.xtrip.common.gds.model.GdsBookabilityItemIndexData;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import java.util.Collection;

public class GdsBookabilityIndexHandler
implements IndexHandler<GdsBookabilityItem, GdsBookabilityItemIndex> {
    public Class<? extends BaseIndexData<GdsBookabilityItem, GdsBookabilityItemIndex>> getDataClass() {
        return GdsBookabilityItemIndexData.class;
    }

    public Class<GdsBookabilityItemIndex> getIndexClass() {
        return GdsBookabilityItemIndex.class;
    }

    public Class<GdsBookabilityItem> getEntityType() {
        return GdsBookabilityItem.class;
    }

    public void create(EntityContainer<GdsBookabilityItem> etc, Collection<BaseIndexData<GdsBookabilityItem, GdsBookabilityItemIndex>> indexes) {
        GdsBookabilityItem item = (GdsBookabilityItem)etc.getEntity();
        GdsBookabilityItemIndexData data = new GdsBookabilityItemIndexData();
        this.updateIndexData(data, item);
        indexes.add((BaseIndexData<GdsBookabilityItem, GdsBookabilityItemIndex>)data);
    }

    protected void updateIndexData(GdsBookabilityItemIndexData data, GdsBookabilityItem item) {
        data.setGds(item.getGds());
        data.setDepartureLocation(item.getDepartureLocation());
        data.setArrivalLocation(item.getArrivalLocation());
        data.setAirline(item.getAirline());
        data.setDateBegin(item.getDateBegin());
        data.setDateEnd(item.getDateEnd());
        data.setDate(item.getDate());
        data.setDescription(item.getDescription());
        data.setFlightNumber(item.getFlightNumber());
        data.setBookingClass(item.getBookingClass());
        data.setSeatsCount(item.getSeatsCount());
        data.setPassengerTypes((Collection)item.getPassengerTypes());
        String number = TextUtil.buildFullNumber((CompositeNumber)item);
        data.setNumber(number);
        DataAggregator aggregator = new DataAggregator();
        aggregator.aggregate(item.getDate());
        aggregator.aggregate(item.getDateBegin());
        aggregator.aggregate(item.getDateEnd());
        aggregator.aggregate((Object)item.getAirline());
        aggregator.aggregate((Object)item.getArrivalLocation());
        aggregator.aggregate((Object)item.getDepartureLocation());
        aggregator.aggregate((Enum)item.getGds());
        aggregator.aggregate((Object)item.getDescription());
        aggregator.aggregate((Object)number);
        aggregator.aggregate((Object)item.getFlightNumber());
        data.setAggregatedData(aggregator.toString());
    }
}

