/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.storage;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.util.ObjectFactory;
import com.gridnine.xtrip.server.db.storage.common.LogicalStorageConfigurator;
import com.gridnine.xtrip.server.db.storage.common.LogicalStorageRegistry;
import com.gridnine.xtrip.server.db.storage.model.DictionaryStorageOperationStartedInterceptor;
import com.gridnine.xtrip.server.db.storage.model.EntityInterceptor;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import com.gridnine.xtrip.server.gds.index.BrandedFareInformationIndexHandler;
import com.gridnine.xtrip.server.gds.index.GdsLogDocumentBasicDocumentIndexHandler;
import com.gridnine.xtrip.server.gds.interceptors.AncillaryFeeDescriptionInterceptor;
import com.gridnine.xtrip.server.gds.interceptors.GdsBookabilitySequenceNumberInterceptor;
import com.gridnine.xtrip.server.gds.storage.BaseGdsAccountIndexHandler;
import com.gridnine.xtrip.server.gds.storage.BaseMtdFareSettingsIndexHandler;
import com.gridnine.xtrip.server.gds.storage.BookingFileContainerInterceptor;
import com.gridnine.xtrip.server.gds.storage.GdsBookabilityIndexHandler;
import com.gridnine.xtrip.server.gds.storage.GdsRulesOptimizationInterceptor;
import com.gridnine.xtrip.server.gds.storage.GdsTracingSettingsInterceptor;
import com.gridnine.xtrip.server.gds.storage.PenaltyPropertiesIndexHandler;
import com.gridnine.xtrip.server.gds.storage.SpecialTariffIndexHandler;
import org.slf4j.LoggerFactory;

public class GdsLogicalStorageConfigurator
implements LogicalStorageConfigurator {
    public void configure(LogicalStorageRegistry registry) {
        registry.registerEntityInterceptor((EntityInterceptor)new BookingFileContainerInterceptor());
        registry.registerEntityInterceptor((EntityInterceptor)new GdsRulesOptimizationInterceptor());
        registry.registerIndexHandler((IndexHandler)new GdsLogDocumentBasicDocumentIndexHandler());
        registry.registerIndexHandler((IndexHandler)new PenaltyPropertiesIndexHandler());
        registry.registerIndexHandler(GdsLogicalStorageConfigurator.createHandler("gds-bookability-item-index-handler.className", GdsBookabilityIndexHandler::new));
        registry.registerIndexHandler(GdsLogicalStorageConfigurator.createHandler("gds-account-index-handler.className", BaseGdsAccountIndexHandler::new));
        registry.registerEntityInterceptor((EntityInterceptor)new GdsBookabilitySequenceNumberInterceptor());
        registry.registerIndexHandler((IndexHandler)new SpecialTariffIndexHandler());
        registry.registerIndexHandler((IndexHandler)new BrandedFareInformationIndexHandler());
        registry.registerIndexHandler((IndexHandler)new BaseMtdFareSettingsIndexHandler());
        registry.registerEntityInterceptor((EntityInterceptor)new GdsTracingSettingsInterceptor());
        registry.registerDictionaryOperationStartedInterceptor((DictionaryStorageOperationStartedInterceptor)new AncillaryFeeDescriptionInterceptor());
    }

    private static <E extends BaseEntity, I extends EntityIndex<E>, H extends IndexHandler<E, I>> H createHandler(String key, ObjectFactory<H> objectFactory) {
        String clsName = System.getProperty(key);
        if (clsName == null) {
            return (H)((IndexHandler)objectFactory.createObject());
        }
        try {
            return (H)((IndexHandler)GdsLogicalStorageConfigurator.class.getClassLoader().loadClass(clsName).newInstance());
        }
        catch (Exception e) {
            LoggerFactory.getLogger(GdsLogicalStorageConfigurator.class).error("unable to load class " + clsName, (Throwable)e);
            return (H)((IndexHandler)objectFactory.createObject());
        }
    }
}

